/*
 * Decompiled with CFR 0.152.
 */
package soft.com.github.houbb.opencc4j.core.impl;

import java.util.List;
import java.util.Map;
import soft.com.github.houbb.opencc4j.core.ZhConvert;
import soft.com.github.houbb.opencc4j.support.convert.context.impl.DefaultUnitConvertContext;
import soft.com.github.houbb.opencc4j.support.convert.core.UnitConvert;
import soft.com.github.houbb.opencc4j.support.convert.core.impl.DefaultUnitConvert;
import soft.com.github.houbb.opencc4j.support.data.impl.STCharData;
import soft.com.github.houbb.opencc4j.support.data.impl.STPhraseData;
import soft.com.github.houbb.opencc4j.support.data.impl.TSCharData;
import soft.com.github.houbb.opencc4j.support.data.impl.TSPhraseData;
import soft.com.github.houbb.opencc4j.support.instance.impl.InstanceFactory;
import soft.com.github.houbb.opencc4j.support.segment.Segment;
import soft.com.github.houbb.opencc4j.support.segment.impl.HuaBanSegment;
import soft.com.github.houbb.opencc4j.util.CollectionUtil;
import soft.com.github.houbb.opencc4j.util.StringUtil;

public class ZhConvertBootstrap
implements ZhConvert {
    private Segment segment = InstanceFactory.getInstance().singleton(HuaBanSegment.class);

    public static ZhConvertBootstrap newInstance() {
        return InstanceFactory.getInstance().multiple(ZhConvertBootstrap.class);
    }

    public ZhConvertBootstrap segment(Segment segment) {
        this.segment = segment;
        return this;
    }

    @Override
    public String toSimple(String original) {
        InstanceFactory instance = InstanceFactory.getInstance();
        return this.convert(original, this.segment, instance.singleton(TSPhraseData.class).data().getDataMap(), instance.singleton(TSCharData.class).data().getDataMap());
    }

    @Override
    public String toTraditional(String original) {
        InstanceFactory instance = InstanceFactory.getInstance();
        return this.convert(original, this.segment, instance.singleton(STPhraseData.class).data().getDataMap(), instance.singleton(STCharData.class).data().getDataMap());
    }

    private String convert(String original, Segment segment, Map<String, String> phraseData, Map<String, String> charData) {
        if (StringUtil.isEmpty(original)) {
            return original;
        }
        List<String> stringList = segment.seg(original);
        if (CollectionUtil.isEmpty(stringList)) {
            return original;
        }
        UnitConvert unitConvert = InstanceFactory.getInstance().singleton(DefaultUnitConvert.class);
        DefaultUnitConvertContext unitConvertContext = new DefaultUnitConvertContext();
        unitConvertContext.setPhraseData(phraseData);
        unitConvertContext.setCharData(charData);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringList) {
            unitConvertContext.setUnit(string);
            String result = unitConvert.convert(unitConvertContext);
            stringBuilder.append(result);
        }
        return stringBuilder.toString();
    }
}

