/*
 * Decompiled with CFR 0.152.
 */
package soft.com.github.houbb.opencc4j.support.instance.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import soft.com.github.houbb.opencc4j.annotation.ThreadSafe;
import soft.com.github.houbb.opencc4j.exception.Opencc4jRuntimeException;
import soft.com.github.houbb.opencc4j.support.instance.Instance;
import soft.com.github.houbb.opencc4j.util.ArgUtil;
import soft.com.github.houbb.opencc4j.util.ObjectUtil;

@ThreadSafe
public final class InstanceFactory
implements Instance {
    private final Map<String, Object> singletonMap = new ConcurrentHashMap<String, Object>();
    private ThreadLocal<Map<String, Object>> mapThreadLocal = new ThreadLocal();

    private InstanceFactory() {
    }

    public static InstanceFactory getInstance() {
        return SingletonHolder.INSTANCE_FACTORY;
    }

    @Override
    public <T> T singleton(Class<T> tClass) {
        this.notNull(tClass);
        return this.getSingleton(tClass, this.singletonMap);
    }

    @Override
    public <T> T threadLocal(Class<T> tClass) {
        this.notNull(tClass);
        Map<String, Object> map = this.mapThreadLocal.get();
        if (ObjectUtil.isNull(map)) {
            map = new ConcurrentHashMap<String, Object>();
        }
        T instance = this.getSingleton(tClass, map);
        this.mapThreadLocal.set(map);
        return instance;
    }

    @Override
    public <T> T multiple(Class<T> tClass) {
        this.notNull(tClass);
        try {
            return tClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new Opencc4jRuntimeException(e);
        }
    }

    private <T> T getSingleton(Class<T> tClass, Map<String, Object> instanceMap) {
        this.notNull(tClass);
        String fullClassName = tClass.getName();
        Object instance = instanceMap.get(fullClassName);
        if (ObjectUtil.isNull(instance)) {
            instance = this.multiple(tClass);
            instanceMap.put(fullClassName, instance);
        }
        return (T)instance;
    }

    private void notNull(Class tClass) {
        ArgUtil.notNull(tClass, "class");
    }

    private static class SingletonHolder {
        private static final InstanceFactory INSTANCE_FACTORY = new InstanceFactory();

        private SingletonHolder() {
        }
    }
}

