/*
 * Decompiled with CFR 0.152.
 */
package soft.com.github.houbb.opencc4j.util;

import soft.com.github.houbb.opencc4j.core.impl.ZhConvertBootstrap;
import soft.com.github.houbb.opencc4j.support.instance.impl.InstanceFactory;
import soft.com.github.houbb.opencc4j.support.segment.Segment;
import soft.com.github.houbb.opencc4j.support.segment.impl.CharSegment;
import soft.com.github.houbb.opencc4j.support.segment.impl.HuaBanSegment;

public final class ZhConverterUtil {
    private ZhConverterUtil() {
    }

    public static String convertToSimple(String original) {
        return ZhConverterUtil.convertToSimple(original, true);
    }

    public static String convertToTraditional(String original) {
        return ZhConverterUtil.convertToTraditional(original, true);
    }

    public static String convertToSimple(String original, boolean huabanSegment) {
        ZhConvertBootstrap zhConvertBootstrap = InstanceFactory.getInstance().multiple(ZhConvertBootstrap.class);
        Segment segment = ZhConverterUtil.getSegment(huabanSegment);
        return zhConvertBootstrap.segment(segment).toSimple(original);
    }

    public static String convertToTraditional(String original, boolean huabanSegment) {
        ZhConvertBootstrap zhConvertBootstrap = InstanceFactory.getInstance().multiple(ZhConvertBootstrap.class);
        Segment segment = ZhConverterUtil.getSegment(huabanSegment);
        return zhConvertBootstrap.segment(segment).toTraditional(original);
    }

    private static Segment getSegment(boolean huabanSegment) {
        InstanceFactory instance = InstanceFactory.getInstance();
        if (huabanSegment) {
            return instance.singleton(HuaBanSegment.class);
        }
        return instance.singleton(CharSegment.class);
    }
}

