/*
 * Decompiled with CFR 0.152.
 */
package top.codephon.digi_tsuuruzu.network;

import java.util.UUID;
import java.util.function.Supplier;
import mod.cyan.digimobs.entities.DigimonEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public class SendPack {
    private final UUID uuid;
    private final int anInt;
    private final short type;
    private final byte numB;
    private final String text;

    public SendPack(PacketBuffer buffer) {
        this.uuid = buffer.readUUID();
        this.anInt = buffer.readInt();
        this.type = buffer.readShort();
        this.text = buffer.readUtf();
        this.numB = buffer.readByte();
    }

    public SendPack(UUID uuid, String text, Byte numB, Integer anInt, short type) {
        this.uuid = uuid;
        this.anInt = anInt;
        this.type = type;
        this.text = text;
        this.numB = numB;
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeUUID(this.uuid);
        buf.writeInt(this.anInt);
        buf.writeShort((int)this.type);
        buf.writeUtf(this.text);
        buf.writeByte((int)this.numB);
    }

    public void handler(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (this.type == 1) {
                SendPack.editEvoLine(player, this.uuid, this.text, this.numB, (byte)this.anInt);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static void editEvoLine(ServerPlayerEntity playerEntity, UUID uuid, String lj, Byte num, Byte id) {
        DigimonEntity digimob = (DigimonEntity)((ServerWorld)playerEntity.level).getEntity(uuid);
        String to = lj.substring(0, lj.indexOf(","));
        String now = lj.substring(to.length() + 1);
        if (digimob != null) {
            switch (id) {
                case 0: {
                    digimob.digivolutions.setBabyForm(to);
                }
                case 1: {
                    digimob.digivolutions.setInTrainingForm(to);
                }
                case 2: {
                    digimob.digivolutions.setRookieForm(to);
                }
                case 3: {
                    digimob.digivolutions.getChampionForms().put(to, (INBT)new CompoundNBT());
                    digimob.getEvolutions().getCompound(now).putString("ChampionForm" + num, to);
                }
                case 4: {
                    digimob.digivolutions.getUltimateForms().put(to, (INBT)new CompoundNBT());
                    digimob.digivolutions.getChampionForms().getCompound(now).putString("UltimateForm" + num, to);
                }
                case 5: {
                    digimob.digivolutions.getMegaForms().put(to, (INBT)new CompoundNBT());
                    digimob.digivolutions.getUltimateForms().getCompound(now).putString("MegaForm" + num, to);
                }
            }
        }
    }
}

