/*
 * Decompiled with CFR 0.152.
 */
package com.huaban.analysis.jieba;

import java.util.regex.Pattern;

public class CharacterUtil {
    public static Pattern reSkip = Pattern.compile("(\\d+\\.\\d+|[a-zA-Z0-9]+)");
    private static final char[] connectors = new char[]{'+', '#', '&', '.', '_', '-'};

    public static boolean isChineseLetter(char ch) {
        return ch >= '\u4e00' && ch <= '\u9fa5';
    }

    public static boolean isEnglishLetter(char ch) {
        return ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z';
    }

    public static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static boolean isConnector(char ch) {
        for (char connector : connectors) {
            if (ch != connector) continue;
            return true;
        }
        return false;
    }

    public static boolean ccFind(char ch) {
        if (CharacterUtil.isChineseLetter(ch)) {
            return true;
        }
        if (CharacterUtil.isEnglishLetter(ch)) {
            return true;
        }
        if (CharacterUtil.isDigit(ch)) {
            return true;
        }
        return CharacterUtil.isConnector(ch);
    }

    public static char regularize(char input) {
        if (input == '\u3000') {
            return ' ';
        }
        if (input > '\uff00' && input < '\uff5f') {
            return (char)(input - 65248);
        }
        if (input >= 'A' && input <= 'Z') {
            input = (char)(input + 32);
            return input;
        }
        return input;
    }
}

