/*
 * Decompiled with CFR 0.152.
 */
package com.qianxinyao.analysis.jieba.keyword;

public class Keyword
implements Comparable<Keyword> {
    private double tfidfvalue;
    private String name;

    public double getTfidfvalue() {
        return this.tfidfvalue;
    }

    public void setTfidfvalue(double tfidfvalue) {
        this.tfidfvalue = tfidfvalue;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Keyword(String name, double tfidfvalue) {
        this.name = name;
        this.tfidfvalue = (double)Math.round(tfidfvalue * 10000.0) / 10000.0;
    }

    @Override
    public int compareTo(Keyword o) {
        if (this.tfidfvalue > o.tfidfvalue) {
            return -1;
        }
        if (this.tfidfvalue == o.tfidfvalue) {
            return 0;
        }
        return -1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        long temp = Double.doubleToLongBits(this.tfidfvalue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Keyword other = (Keyword)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

