/*
 * Decompiled with CFR 0.152.
 */
package mod.cyan.digimobs;

import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;
import mod.cyan.digimobs.config.DigimobsConfig;
import mod.cyan.digimobs.entities.setup.FieldGuide;
import mod.cyan.digimobs.init.ModBlocks;
import mod.cyan.digimobs.init.ModEntities;
import mod.cyan.digimobs.init.ModItems;
import mod.cyan.digimobs.init.ModPotions;
import mod.cyan.digimobs.init.ModTiles;
import mod.cyan.digimobs.init.RegisterCommandEvent;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.bernie.geckolib3.GeckoLib;
import software.bernie.geckolib3.resource.ResourceListener;

@Mod(value="digimobs")
public class Digimobs {
    public static final String MODID = "digimobs";
    public static final Logger LOGGER = LogManager.getLogger();
    public static EntityClassification DIGIMON = EntityClassification.create((String)"DIGIMON", (String)"digimon", (int)15, (boolean)false, (boolean)true, (int)128);
    public static final ResourceLocation FONT_DIGIMOBS = new ResourceLocation("digimobs", "digimobs");
    public static final ResourceLocation FONT_DEFAULT = new ResourceLocation("minecraft", "default");
    public static Map<EntityType<? extends MobEntity>, FieldGuide.DigimonTypes> typeMap = Maps.newHashMap();
    private static Map<String, String> trimmed = Maps.newConcurrentMap();

    public Digimobs() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, DigimobsConfig.COMMON_SPEC);
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(null, null));
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        ModTiles.TILES.register(modEventBus);
        ModBlocks.BLOCKS.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModEntities.ENTITIES.register(modEventBus);
        ModPotions.POTIONS.register(modEventBus);
        ModPotions.EFFECTS.register(modEventBus);
        DIGIMON = EntityClassification.create((String)"DIGIMON", (String)"digimon", (int)30, (boolean)false, (boolean)true, (int)128);
        MinecraftForge.EVENT_BUS.register((Object)this);
        GeckoLib.hasInitialized = true;
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ResourceListener::registerReloadListener);
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {});
        MinecraftForge.EVENT_BUS.register(RegisterCommandEvent.class);
    }

    public static String trim(String name) {
        if (name == null) {
            return null;
        }
        if (trimmed.containsKey(name)) {
            return trimmed.get(name);
        }
        String trim = name;
        trim = trim.toLowerCase(Locale.ROOT).trim();
        trim = trim.replaceAll("([^a-zA-Z0-9 _-])", "");
        trim = trim.replaceAll(" ", "_");
        trimmed.put(name, trim);
        return trim;
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
    }
}

