/*
 * Decompiled with CFR 0.152.
 */
package mod.cyan.digimobs.banktest;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PlayerDataHandler {
    private static Set<Class<? extends PlayerData>> dataMap = Sets.newHashSet();
    private static Set<String> dataIds = Sets.newHashSet();
    private static PlayerDataHandler INSTANCESERVER;
    private static PlayerDataHandler INSTANCECLIENT;
    private final Map<String, PlayerDataManager> data = Maps.newHashMap();

    public static void clear() {
        if (INSTANCECLIENT != null) {
            MinecraftForge.EVENT_BUS.unregister((Object)INSTANCECLIENT);
        }
        if (INSTANCESERVER != null) {
            MinecraftForge.EVENT_BUS.unregister((Object)INSTANCESERVER);
        }
        INSTANCESERVER = null;
        INSTANCECLIENT = null;
    }

    public static Set<String> getDataIDs() {
        if (dataIds.size() != dataMap.size()) {
            for (Class<? extends PlayerData> type : dataMap) {
                try {
                    PlayerData toAdd = type.newInstance();
                    dataIds.add(toAdd.getIdentifier());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
            }
        }
        return dataIds;
    }

    public static File getFileForUUID(String uuid, String fileName) {
        return null;
    }

    public static PlayerDataHandler getInstance() {
        return null;
    }

    public static void register(Class<? extends PlayerData> data) {
    }

    public static void saveCustomData(PlayerEntity player) {
    }

    public static void saveCustomData(String cachedUniqueIdString) {
        PlayerDataHandler.getInstance().save(cachedUniqueIdString, "misc");
    }

    public PlayerDataHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void cleanupOfflineData(WorldEvent.Save event) {
    }

    public PlayerDataManager getPlayerData(PlayerEntity player) {
        return null;
    }

    public PlayerDataManager getPlayerData(String uuid) {
        return null;
    }

    public PlayerDataManager getPlayerData(UUID uniqueID) {
        return null;
    }

    public PlayerDataManager load(String uuid) {
        return null;
    }

    public void save(String uuid) {
    }

    public void save(String uuid, String dataType) {
    }

    public static class PlayerDataManager {
        public Map<Class<? extends PlayerData>, PlayerData> data = Maps.newHashMap();
        Map<String, PlayerData> idMap = Maps.newHashMap();
        final String uuid;

        public PlayerDataManager(String uuid) {
            this.uuid = uuid;
            for (Class type : dataMap) {
                try {
                    PlayerData toAdd = (PlayerData)type.newInstance();
                    this.data.put(type, toAdd);
                    this.idMap.put(toAdd.getIdentifier(), toAdd);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }

        public <T extends PlayerData> T getData(Class<T> type) {
            return (T)this.data.get(type);
        }

        public PlayerData getData(String dataType) {
            return this.idMap.get(dataType);
        }
    }

    public static abstract class PlayerData
    implements IPlayerData {
        @Override
        public void readSync(ByteBuf data) {
        }

        @Override
        public void writeSync(ByteBuf data) {
        }
    }

    private static interface IPlayerData {
        public String dataFileName();

        public String getIdentifier();

        public void readFromNBT(CompoundNBT var1);

        public void readSync(ByteBuf var1);

        public boolean shouldSync();

        public void writeSync(ByteBuf var1);

        public void writeToNBT(CompoundNBT var1);

        default public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        }

        default public void onPlayerUpdate(LivingEvent.LivingUpdateEvent event) {
        }

        default public boolean canTick() {
            return false;
        }
    }
}

