/*
 * Decompiled with CFR 0.152.
 */
package mod.cyan.digimobs.block.digispawner;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import mod.cyan.digimobs.block.digispawner.WeightedSpawnerDigimon;
import mod.cyan.digimobs.entities.DigimonEntity;
import mod.cyan.digimobs.util.Tools;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.StringUtils;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class DigiSpawner {
    private static final Logger LOGGER = LogManager.getLogger();
    private int spawnDelay = 20;
    private final List<WeightedSpawnerDigimon> spawnPotentials = Lists.newArrayList();
    private WeightedSpawnerDigimon nextSpawnData = new WeightedSpawnerDigimon();
    private int minSpawnDelay = 200;
    private int maxSpawnDelay = 800;
    private int spawnCount = 1;
    @Nullable
    private Entity displayEntity;
    private int maxNearbyEntities = 4;
    private int requiredPlayerRange = 16;
    private int spawnRange = 4;

    @Nullable
    private ResourceLocation getEntityId() {
        String s = this.nextSpawnData.getTag().func_74779_i("id");
        try {
            return StringUtils.func_151246_b((String)s) ? null : new ResourceLocation(s);
        }
        catch (ResourceLocationException resourcelocationexception) {
            BlockPos blockpos = this.getPos();
            LOGGER.warn("Invalid entity id '{}' at spawner {}:[{},{},{}]", (Object)s, (Object)this.getLevel().func_234923_W_().func_240901_a_(), (Object)blockpos.func_177958_n(), (Object)blockpos.func_177956_o(), (Object)blockpos.func_177952_p());
            return null;
        }
    }

    public void setEntityId(EntityType<?> p_200876_1_) {
        this.nextSpawnData.getTag().func_74778_a("name", Registry.field_212629_r.func_177774_c(p_200876_1_).toString());
    }

    public void setDigimon(CompoundNBT compoundNBT) {
        this.nextSpawnData.getTag().func_218657_a("data", (INBT)compoundNBT);
        this.nextSpawnData.getTag().func_74778_a("id", "digimobs:" + compoundNBT.func_74779_i("name").toLowerCase());
    }

    public void tick() {
        World world = this.getLevel();
        BlockPos blockpos = this.getPos();
        if (!(world instanceof ServerWorld)) {
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            }
        } else {
            if (this.spawnDelay == -1) {
                this.delay();
            }
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
                return;
            }
            boolean flag = false;
            for (int i = 0; i < this.spawnCount; ++i) {
                double d2;
                CompoundNBT compoundnbt = this.nextSpawnData.getTag();
                Optional optional = EntityType.func_220347_a((CompoundNBT)compoundnbt);
                if (!optional.isPresent()) {
                    this.delay();
                    return;
                }
                ListNBT listnbt = compoundnbt.func_150295_c("Pos", 6);
                int j = listnbt.size();
                double d0 = j >= 1 ? listnbt.func_150309_d(0) : (double)blockpos.func_177958_n() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * (double)this.spawnRange + 0.5;
                double d1 = j >= 2 ? listnbt.func_150309_d(1) : (double)(blockpos.func_177956_o() + world.field_73012_v.nextInt(3) - 1);
                double d = d2 = j >= 3 ? listnbt.func_150309_d(2) : (double)blockpos.func_177952_p() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * (double)this.spawnRange + 0.5;
                if (!world.func_226664_a_(((EntityType)optional.get()).func_220328_a(d0, d1, d2))) continue;
                ServerWorld serverworld = (ServerWorld)world;
                DigimonEntity entity = (DigimonEntity)EntityType.func_220335_a((CompoundNBT)compoundnbt, (World)world, p_221408_6_ -> {
                    p_221408_6_.func_70012_b(d0, d1, d2, p_221408_6_.field_70177_z, p_221408_6_.field_70125_A);
                    return p_221408_6_;
                });
                if (entity == null) {
                    this.delay();
                    return;
                }
                int k = world.func_217357_a(((Object)((Object)entity)).getClass(), new AxisAlignedBB((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), (double)(blockpos.func_177958_n() + 1), (double)(blockpos.func_177956_o() + 1), (double)(blockpos.func_177952_p() + 1)).func_186662_g((double)this.spawnRange)).size();
                if (k >= this.maxNearbyEntities) {
                    this.delay();
                    return;
                }
                entity.func_70012_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                entity.stats.setGrades();
                if (!this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("personality").isEmpty()) {
                    entity.setup.setPersonality(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("personality"));
                } else {
                    entity.setup.createPersonality(Tools.getRandomNumber(0, 6));
                }
                if (!this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("minlevel").isEmpty() && !this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("maxlevel").isEmpty() && Integer.valueOf(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("minlevel")) > 0 && Integer.valueOf(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("maxlevel")) <= 100) {
                    entity.stats.setLevel(Tools.getRandomNumber(Integer.valueOf(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("minlevel")), Integer.valueOf(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("maxlevel"))));
                } else {
                    entity.stats.setLevel(1);
                }
                if (!this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("minhealth").isEmpty() && !this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("maxhealth").isEmpty() && Integer.valueOf(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("minhealth")) >= 0 && Integer.valueOf(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("maxhealth")) <= 7) {
                    entity.stats.setSpeciesGradeHP(Tools.getRandomNumber(Integer.valueOf(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("minhealth")), Integer.valueOf(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("maxhealth"))));
                } else {
                    entity.stats.setSpeciesGradeHP(7);
                }
                if (!this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("minenergy").isEmpty() && !this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("maxenergy").isEmpty() && Integer.valueOf(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("minenergy")) >= 0 && Integer.valueOf(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("maxenergy")) <= 7) {
                    entity.stats.setSpeciesGradeEG(Tools.getRandomNumber(Integer.valueOf(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("minenergy")), Integer.valueOf(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("maxenergy"))));
                } else {
                    entity.stats.setSpeciesGradeEG(7);
                }
                if (!this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("minattack").isEmpty() && !this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("maxattack").isEmpty() && Integer.valueOf(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("minattack")) >= 0 && Integer.valueOf(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("maxattack")) <= 7) {
                    entity.stats.setSpeciesGradeATK(Tools.getRandomNumber(Integer.valueOf(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("minattack")), Integer.valueOf(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("maxattack"))));
                } else {
                    entity.stats.setSpeciesGradeATK(7);
                }
                if (!this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("mindefense").isEmpty() && !this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("maxdefense").isEmpty() && Integer.valueOf(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("mindefense")) >= 0 && Integer.valueOf(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("maxdefense")) <= 7) {
                    entity.stats.setSpeciesGradeDEF(Tools.getRandomNumber(Integer.valueOf(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("mindefense")), Integer.valueOf(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("maxdefense"))));
                } else {
                    entity.stats.setSpeciesGradeDEF(7);
                }
                if (!this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("minspecialattack").isEmpty() && !this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("maxspecialattack").isEmpty() && Integer.valueOf(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("minspecialattack")) >= 0 && Integer.valueOf(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("maxspecialattack")) <= 7) {
                    entity.stats.setSpeciesGradeSATK(Tools.getRandomNumber(Integer.valueOf(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("minspecialattack")), Integer.valueOf(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("maxspecialattack"))));
                } else {
                    entity.stats.setSpeciesGradeSATK(7);
                }
                if (!this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("minspecialdefense").isEmpty() && !this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("maxspecialdefense").isEmpty() && Integer.valueOf(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("minspecialdefense")) >= 0 && Integer.valueOf(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("maxspecialdefense")) <= 7) {
                    entity.stats.setSpeciesGradeSDEF(Tools.getRandomNumber(Integer.valueOf(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("minspecialdefense")), Integer.valueOf(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("maxspecialdefense"))));
                } else {
                    entity.stats.setSpeciesGradeSDEF(7);
                }
                if (!this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("minspeed").isEmpty() && !this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("maxspeed").isEmpty() && Integer.valueOf(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("minspeed")) >= 0 && Integer.valueOf(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("maxspeed")) <= 7) {
                    entity.stats.setSpeciesGradeSPE(Tools.getRandomNumber(Integer.valueOf(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("minspeed")), Integer.valueOf(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("maxspeed"))));
                } else {
                    entity.stats.setSpeciesGradeSPE(7);
                }
                if (!this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("minluck").isEmpty() && !this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("maxluck").isEmpty() && Integer.valueOf(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("minluck")) >= 0 && Integer.valueOf(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("maxluck")) <= 7) {
                    entity.stats.setSpeciesGradeLUK(Tools.getRandomNumber(Integer.valueOf(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("minluck")), Integer.valueOf(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("maxluck"))));
                } else {
                    entity.stats.setSpeciesGradeLUK(7);
                }
                if (entity.setup.getPersonality().equals("Balanced")) {
                    entity.stats.setPersonalityGradeHP(3);
                    entity.stats.setPersonalityGradeEG(3);
                    entity.stats.setPersonalityGradeATK(3);
                    entity.stats.setPersonalityGradeDEF(3);
                    entity.stats.setPersonalityGradeSATK(3);
                    entity.stats.setPersonalityGradeSDEF(3);
                    entity.stats.setPersonalityGradeSPE(3);
                    entity.stats.setPersonalityGradeLUK(3);
                }
                if (entity.setup.getPersonality().equals("Headstrong")) {
                    entity.stats.setPersonalityGradeHP(4);
                    entity.stats.setPersonalityGradeEG(7);
                    entity.stats.setPersonalityGradeATK(1);
                    entity.stats.setPersonalityGradeDEF(3);
                    entity.stats.setPersonalityGradeSATK(7);
                    entity.stats.setPersonalityGradeSDEF(7);
                    entity.stats.setPersonalityGradeSPE(5);
                    entity.stats.setPersonalityGradeLUK(5);
                }
                if (entity.setup.getPersonality().equals("Cautious")) {
                    entity.stats.setPersonalityGradeHP(3);
                    entity.stats.setPersonalityGradeEG(7);
                    entity.stats.setPersonalityGradeATK(4);
                    entity.stats.setPersonalityGradeDEF(1);
                    entity.stats.setPersonalityGradeSATK(6);
                    entity.stats.setPersonalityGradeSDEF(4);
                    entity.stats.setPersonalityGradeSPE(7);
                    entity.stats.setPersonalityGradeLUK(5);
                }
                if (entity.setup.getPersonality().equals("Agile")) {
                    entity.stats.setPersonalityGradeHP(5);
                    entity.stats.setPersonalityGradeEG(6);
                    entity.stats.setPersonalityGradeATK(3);
                    entity.stats.setPersonalityGradeDEF(5);
                    entity.stats.setPersonalityGradeSATK(3);
                    entity.stats.setPersonalityGradeSDEF(6);
                    entity.stats.setPersonalityGradeSPE(1);
                    entity.stats.setPersonalityGradeLUK(3);
                }
                if (entity.setup.getPersonality().equals("Intelligent")) {
                    entity.stats.setPersonalityGradeHP(7);
                    entity.stats.setPersonalityGradeEG(2);
                    entity.stats.setPersonalityGradeATK(7);
                    entity.stats.setPersonalityGradeDEF(7);
                    entity.stats.setPersonalityGradeSATK(1);
                    entity.stats.setPersonalityGradeSDEF(4);
                    entity.stats.setPersonalityGradeSPE(6);
                    entity.stats.setPersonalityGradeLUK(5);
                }
                if (entity.setup.getPersonality().equals("Intuitive")) {
                    entity.stats.setPersonalityGradeHP(4);
                    entity.stats.setPersonalityGradeEG(3);
                    entity.stats.setPersonalityGradeATK(7);
                    entity.stats.setPersonalityGradeDEF(4);
                    entity.stats.setPersonalityGradeSATK(4);
                    entity.stats.setPersonalityGradeSDEF(1);
                    entity.stats.setPersonalityGradeSPE(5);
                    entity.stats.setPersonalityGradeLUK(5);
                }
                if (entity.setup.getPersonality().equals("Deft")) {
                    entity.stats.setPersonalityGradeHP(5);
                    entity.stats.setPersonalityGradeEG(5);
                    entity.stats.setPersonalityGradeATK(5);
                    entity.stats.setPersonalityGradeDEF(5);
                    entity.stats.setPersonalityGradeSATK(5);
                    entity.stats.setPersonalityGradeSDEF(5);
                    entity.stats.setPersonalityGradeSPE(5);
                    entity.stats.setPersonalityGradeLUK(1);
                }
                entity.digivolutions.setEggForm(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("egg"));
                entity.digivolutions.setBabyForm(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("baby"));
                entity.digivolutions.setInTrainingForm(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("intraining"));
                entity.digivolutions.setRookieForm(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("rookie"));
                entity.digivolutions.setChampionForm1(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("champion"));
                entity.digivolutions.setUltimateForm1(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("ultimate"));
                entity.digivolutions.setMegaForm1(this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("mega"));
                if (this.nextSpawnData.getTag().func_74775_l("data").func_74779_i("rookie").isEmpty()) {
                    entity.digivolutions.initEvolutions();
                }
                entity.createPassives();
                entity.specials.initSpecials();
                entity.specials.initSpecialsExtras();
                entity.func_70606_j(entity.stats.getSpeciesStatusHealth() + entity.stats.getPersonalityStatusHealth());
                entity.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)(entity.stats.getSpeciesStatusHealth() + entity.stats.getPersonalityStatusHealth()));
                entity.stats.setEnergy(1);
                entity.stats.setMaxEnergy(entity.stats.getSpeciesStatusEnergy() + entity.stats.getPersonalityStatusEnergy());
                entity.stats.setAttack(entity.stats.getSpeciesStatusAttack() + entity.stats.getPersonalityStatusAttack());
                entity.stats.setDefense(entity.stats.getSpeciesStatusDefense() + entity.stats.getPersonalityStatusDefense());
                entity.stats.setSpecialAttack(entity.stats.getSpeciesStatusSAttack() + entity.stats.getPersonalityStatusSAttack());
                entity.stats.setSpecialDefense(entity.stats.getSpeciesStatusSDefense() + entity.stats.getPersonalityStatusSDefense());
                entity.stats.setSpeed(entity.stats.getSpeciesStatusSpeed() + entity.stats.getPersonalityStatusSpeed());
                entity.stats.setLuck(entity.stats.getSpeciesStatusLuck() + entity.stats.getPersonalityStatusLuck());
                entity.stats.setDigimonAge(1);
                entity.stats.setBond(1);
                entity.stats.setWeight(10);
                entity.setup.createFavoriteFood();
                entity.setup.setCanBeRecruited(false);
                entity.func_70691_i(entity.func_110138_aP());
                if (entity instanceof DigimonEntity) {
                    DigimonEntity DigimonEntity2 = entity;
                    if (this.nextSpawnData.getTag().func_186856_d() == 1 && this.nextSpawnData.getTag().func_150297_b("id", 8)) {
                        entity.func_213386_a((IServerWorld)serverworld, world.func_175649_E(entity.func_233580_cy_()), SpawnReason.SPAWNER, null, null);
                    }
                }
                if (!serverworld.func_242106_g((Entity)entity)) {
                    this.delay();
                    return;
                }
                world.func_217379_c(2004, blockpos, 0);
                if (entity instanceof DigimonEntity) {
                    entity.func_70656_aK();
                }
                flag = true;
            }
            if (flag) {
                this.delay();
            }
        }
    }

    private void delay() {
        if (this.maxSpawnDelay <= this.minSpawnDelay) {
            this.spawnDelay = this.minSpawnDelay;
        } else {
            int i = this.maxSpawnDelay - this.minSpawnDelay;
            this.spawnDelay = this.minSpawnDelay + this.getLevel().field_73012_v.nextInt(i);
        }
        if (!this.spawnPotentials.isEmpty()) {
            this.setNextSpawnData((WeightedSpawnerDigimon)WeightedRandom.func_76271_a((Random)this.getLevel().field_73012_v, this.spawnPotentials));
        }
        this.broadcastEvent(1);
    }

    public void load(CompoundNBT p_98270_1_) {
        this.spawnDelay = p_98270_1_.func_74765_d("Delay");
        this.spawnPotentials.clear();
        if (p_98270_1_.func_150297_b("SpawnPotentials", 9)) {
            ListNBT listnbt = p_98270_1_.func_150295_c("SpawnPotentials", 10);
            for (int i = 0; i < listnbt.size(); ++i) {
                this.spawnPotentials.add(new WeightedSpawnerDigimon(listnbt.func_150305_b(i)));
            }
        }
        if (p_98270_1_.func_150297_b("SpawnData", 10)) {
            this.setNextSpawnData(new WeightedSpawnerDigimon(1, p_98270_1_.func_74775_l("SpawnData")));
        } else if (!this.spawnPotentials.isEmpty()) {
            this.setNextSpawnData((WeightedSpawnerDigimon)WeightedRandom.func_76271_a((Random)this.getLevel().field_73012_v, this.spawnPotentials));
        }
        if (p_98270_1_.func_150297_b("MinSpawnDelay", 99)) {
            this.minSpawnDelay = p_98270_1_.func_74765_d("MinSpawnDelay");
            this.maxSpawnDelay = p_98270_1_.func_74765_d("MaxSpawnDelay");
            this.spawnCount = p_98270_1_.func_74765_d("SpawnCount");
        }
        if (p_98270_1_.func_150297_b("MaxNearbyEntities", 99)) {
            this.maxNearbyEntities = p_98270_1_.func_74765_d("MaxNearbyEntities");
            this.requiredPlayerRange = p_98270_1_.func_74765_d("RequiredPlayerRange");
        }
        if (p_98270_1_.func_150297_b("SpawnRange", 99)) {
            this.spawnRange = p_98270_1_.func_74765_d("SpawnRange");
        }
        if (this.getLevel() != null) {
            this.displayEntity = null;
        }
    }

    public CompoundNBT save(CompoundNBT p_189530_1_) {
        ResourceLocation resourcelocation = this.getEntityId();
        if (resourcelocation == null) {
            return p_189530_1_;
        }
        p_189530_1_.func_74777_a("Delay", (short)this.spawnDelay);
        p_189530_1_.func_74777_a("MinSpawnDelay", (short)this.minSpawnDelay);
        p_189530_1_.func_74777_a("MaxSpawnDelay", (short)this.maxSpawnDelay);
        p_189530_1_.func_74777_a("SpawnCount", (short)this.spawnCount);
        p_189530_1_.func_74777_a("MaxNearbyEntities", (short)this.maxNearbyEntities);
        p_189530_1_.func_74777_a("RequiredPlayerRange", (short)this.requiredPlayerRange);
        p_189530_1_.func_74777_a("SpawnRange", (short)this.spawnRange);
        p_189530_1_.func_218657_a("SpawnData", (INBT)this.nextSpawnData.getTag().func_74737_b());
        ListNBT listnbt = new ListNBT();
        if (this.spawnPotentials.isEmpty()) {
            listnbt.add((Object)this.nextSpawnData.save());
        } else {
            for (WeightedSpawnerDigimon weightedSpawnerDigimon : this.spawnPotentials) {
                listnbt.add((Object)weightedSpawnerDigimon.save());
            }
        }
        p_189530_1_.func_218657_a("SpawnPotentials", (INBT)listnbt);
        return p_189530_1_;
    }

    public boolean onEventTriggered(int p_98268_1_) {
        if (p_98268_1_ == 1 && this.getLevel().field_72995_K) {
            this.spawnDelay = this.minSpawnDelay;
            return true;
        }
        return false;
    }

    public void setNextSpawnData(WeightedSpawnerDigimon p_184993_1_) {
        this.nextSpawnData = p_184993_1_;
    }

    @Nullable
    public Entity getSpawnerEntity() {
        return null;
    }

    public abstract void broadcastEvent(int var1);

    public abstract World getLevel();

    public abstract BlockPos getPos();
}

