/*
 * Decompiled with CFR 0.152.
 */
package mod.cyan.digimobs.block.firewall;

import mod.cyan.digimobs.init.ModTiles;
import mod.cyan.digimobs.world.NewSpawner;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class FirewallTile
extends TileEntity
implements IAnimatable {
    public int range = 64;
    public boolean enabled = true;
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public FirewallTile() {
        super((TileEntityType)ModTiles.FIREWALLTILE.get());
    }

    public FirewallTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public boolean addForbiddenSpawningCoord() {
        if (this.func_145831_w() == null || this.func_145831_w().field_72995_K || !this.enabled) {
            return false;
        }
        BlockPos pos = this.func_174877_v();
        return NewSpawner.addForbiddenSpawningCoord(pos, this.field_145850_b, this.range, NewSpawner.ForbidReason.REPEL);
    }

    public ActionResultType onInteract(BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(hand);
        this.removeForbiddenSpawningCoord();
        this.addForbiddenSpawningCoord();
        if (!this.func_145831_w().field_72995_K) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("repel.info.setrange", new Object[]{this.range, this.enabled}), true);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.removeForbiddenSpawningCoord();
        this.range = nbt.func_74762_e("range");
        this.addForbiddenSpawningCoord();
        this.enabled = nbt.func_74767_n("enabled");
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.removeForbiddenSpawningCoord();
    }

    public boolean removeForbiddenSpawningCoord() {
        if (this.func_145831_w() == null || this.func_145831_w().field_72995_K) {
            return false;
        }
        return NewSpawner.removeForbiddenSpawningCoord(this.func_174877_v(), this.field_145850_b);
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.addForbiddenSpawningCoord();
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("range", this.range);
        nbt.func_74757_a("enabled", true);
        return nbt;
    }

    private <E extends TileEntity> PlayState predicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 10.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

