/*
 * Decompiled with CFR 0.152.
 */
package mod.cyan.digimobs.client;

import java.util.function.Predicate;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.items.ItemStackHandler;

public class ChestContents
implements IInventory {
    private Predicate<PlayerEntity> canPlayerAccessInventoryLambda = x -> true;
    private Notify markDirtyNotificationLambda;
    private Notify openInventoryNotificationLambda;
    private Notify closeInventoryNotificationLambda;
    private final ItemStackHandler chestContents;

    public static ChestContents createForTileEntity(int size, Predicate<PlayerEntity> canPlayerAccessInventoryLambda, Notify markDirtyNotificationLambda) {
        return new ChestContents(size, canPlayerAccessInventoryLambda, markDirtyNotificationLambda);
    }

    public static ChestContents createForClientSideContainer(int size) {
        return new ChestContents(size);
    }

    public CompoundNBT serializeNBT() {
        return this.chestContents.serializeNBT();
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.chestContents.deserializeNBT(nbt);
    }

    public void setCanPlayerAccessInventoryLambda(Predicate<PlayerEntity> canPlayerAccessInventoryLambda) {
        this.canPlayerAccessInventoryLambda = canPlayerAccessInventoryLambda;
    }

    public void setMarkDirtyNotificationLambda(Notify markDirtyNotificationLambda) {
        this.markDirtyNotificationLambda = markDirtyNotificationLambda;
    }

    public void setOpenInventoryNotificationLambda(Notify openInventoryNotificationLambda) {
        this.openInventoryNotificationLambda = openInventoryNotificationLambda;
    }

    public void setCloseInventoryNotificationLambda(Notify closeInventoryNotificationLambda) {
        this.closeInventoryNotificationLambda = closeInventoryNotificationLambda;
    }

    public boolean func_70300_a(PlayerEntity player) {
        return this.canPlayerAccessInventoryLambda.test(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.chestContents.isItemValid(index, stack);
    }

    public void func_70296_d() {
        this.markDirtyNotificationLambda.invoke();
    }

    public void func_174889_b(PlayerEntity player) {
        this.openInventoryNotificationLambda.invoke();
    }

    public void func_174886_c(PlayerEntity player) {
        this.closeInventoryNotificationLambda.invoke();
    }

    public int func_70302_i_() {
        return this.chestContents.getSlots();
    }

    public boolean func_191420_l() {
        for (int i = 0; i < this.chestContents.getSlots(); ++i) {
            if (this.chestContents.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return this.chestContents.getStackInSlot(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return this.chestContents.extractItem(index, count, false);
    }

    public ItemStack func_70304_b(int index) {
        int maxPossibleItemStackSize = this.chestContents.getSlotLimit(index);
        return this.chestContents.extractItem(index, maxPossibleItemStackSize, false);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.chestContents.setStackInSlot(index, stack);
    }

    public void func_174888_l() {
        for (int i = 0; i < this.chestContents.getSlots(); ++i) {
            this.chestContents.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    private ChestContents(int size) {
        this.markDirtyNotificationLambda = () -> {};
        this.openInventoryNotificationLambda = () -> {};
        this.closeInventoryNotificationLambda = () -> {};
        this.chestContents = new ItemStackHandler(size);
    }

    private ChestContents(int size, Predicate<PlayerEntity> canPlayerAccessInventoryLambda, Notify markDirtyNotificationLambda) {
        this.markDirtyNotificationLambda = () -> {};
        this.openInventoryNotificationLambda = () -> {};
        this.closeInventoryNotificationLambda = () -> {};
        this.chestContents = new ItemStackHandler(size);
        this.canPlayerAccessInventoryLambda = canPlayerAccessInventoryLambda;
        this.markDirtyNotificationLambda = markDirtyNotificationLambda;
    }

    @FunctionalInterface
    public static interface Notify {
        public void invoke();
    }
}

