/*
 * Decompiled with CFR 0.152.
 */
package mod.cyan.digimobs.client.gui.fieldguide;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import mod.cyan.digimobs.client.gui.fieldguide.InvisibleButton;
import mod.cyan.digimobs.client.gui.fieldguide.TabCompleteTextField;
import mod.cyan.digimobs.entities.setup.FieldGuide;
import mod.cyan.digimobs.init.ModEntities;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class FieldGuideSearch
extends Screen {
    protected int xSize = 256;
    protected int ySize = 197;
    protected PlayerEntity playerEntity = null;
    private int currentRow = 0;
    private List<FieldGuide.DigimonTypes> digimon;
    private TextFieldWidget searchBar;
    private ItemStack digivice;
    public static int UNLISTED = 47;

    public FieldGuideSearch(PlayerEntity playerEntity, int row, ItemStack itemStackIn) {
        super((ITextComponent)new TranslationTextComponent("digimobs.fieldguide.gui"));
        this.playerEntity = playerEntity;
        this.digimon = Lists.newArrayList();
        this.currentRow = row;
        this.digivice = itemStackIn;
    }

    public boolean func_231046_a_(int keyCode, int b, int c) {
        if (keyCode == 256) {
            this.field_230706_i_.func_147108_a(null);
        }
        return super.func_231046_a_(keyCode, b, c);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_230710_m_.clear();
        int yOffset = this.field_230709_l_ / 2 - 80;
        int xOffset = this.field_230708_k_ / 2;
        this.searchBar = new TabCompleteTextField(0, this.field_230706_i_.field_71466_p, xOffset - 75, yOffset - 10, 150, 10).setCompletions(ModEntities.getFormattedEnglishNameSet());
        this.searchBar.func_212954_a(s -> this.generateDigimonList());
        if (this.currentRow == 0) {
            this.field_230705_e_.add(this.searchBar);
        }
        this.generateDigimonList();
        int i = this.currentRow * 4;
        while (0 <= i && i < Math.min(this.digimon.size(), this.currentRow * 4 + 16)) {
            int j = i - this.currentRow * 4;
            int x = (int)((double)xOffset + (double)(j % 4) * 61.9 - 106.0);
            int y = yOffset + j / 4 * 39 + 98;
            int digi = i++;
            this.func_230480_a_((Widget)new InvisibleButton(x + 2, y - 70, 16, 16, (ITextComponent)new TranslationTextComponent(""), b -> {
                if (this.digimon.size() > 0) {
                    this.field_230706_i_.execute(null);
                }
            }));
        }
        if (this.currentRow != 0) {
            this.func_230480_a_((Widget)new Button(xOffset - 24, yOffset - 13, 40, 20, (ITextComponent)new TranslationTextComponent("Search"), b -> this.field_230706_i_.execute(null)));
        }
        this.func_230480_a_((Widget)new Button(xOffset + 100, yOffset - 13, 25, 20, (ITextComponent)new TranslationTextComponent("Next"), b -> {
            this.currentRow += 4;
            this.field_230706_i_.execute(null);
        }));
        this.func_230480_a_((Widget)new Button(xOffset - 124, yOffset - 13, 25, 20, (ITextComponent)new TranslationTextComponent("Back"), b -> {
            if (this.currentRow >= 4) {
                this.currentRow -= 4;
                this.field_230706_i_.execute(null);
            }
        }));
    }

    public void func_231175_as__() {
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void func_230430_a_(MatrixStack mat, int mouseX, int mouseY, float f) {
        int j2 = (this.field_230708_k_ - this.xSize) / 2;
        int k2 = (this.field_230709_l_ - this.ySize) / 2;
        this.func_230446_a_(mat);
        this.field_230706_i_.func_110434_K().func_110577_a(new ResourceLocation("digimobs", "textures/gui/dterminal.png"));
        this.func_238474_b_(mat, j2, k2 + 2, 0, 0, this.xSize, this.ySize);
        if (this.currentRow == 0) {
            this.searchBar.func_230430_a_(mat, mouseX, mouseY, f);
        }
        for (int i = this.currentRow * 4; 0 <= i && i < Math.min(this.digimon.size(), this.currentRow * 4 + 16); ++i) {
            int j = i - this.currentRow * 4;
            int x = (int)((double)j2 + (double)(j % 4) * 61.9 - 106.0);
            int y = k2 + j / 4 * 39 + 148;
            this.field_230706_i_.func_110434_K().func_110577_a(new ResourceLocation("digimobs", "textures/sprites/" + this.digimon.get(i).func_176610_l().toLowerCase() + ".png"));
            if (!this.playerEntity.func_184812_l_() && !this.digivice.func_77978_p().func_74764_b(this.digimon.get(i).func_176610_l().toLowerCase())) {
                RenderSystem.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                AbstractGui.func_238463_a_((MatrixStack)mat, (int)(x + 130), (int)(y - 110), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
                continue;
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            AbstractGui.func_238463_a_((MatrixStack)mat, (int)(130 + x), (int)(y - 110), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            this.easyScaledString(mat, new TranslationTextComponent("entity.digimobs." + this.digimon.get(i).toString().toLowerCase()).getString(), x + 139, y - 90);
        }
        super.func_230430_a_(mat, mouseX, mouseY, f);
    }

    public void easyScaledString(MatrixStack mat, String text, float x, float y) {
        float size = 0.5f;
        GlStateManager.func_227672_b_((float)size, (float)size, (float)size);
        float mSize = (float)Math.pow(size, -1.0);
        FieldGuideSearch.func_238471_a_((MatrixStack)mat, (FontRenderer)this.field_230712_o_, (String)text, (int)Math.round(x / size), (int)Math.round(y / size), (int)0xFFFFFF);
        GlStateManager.func_227672_b_((float)mSize, (float)mSize, (float)mSize);
    }

    public void easyString(MatrixStack mat, String text, int x, int y) {
        FieldGuideSearch.func_238476_c_((MatrixStack)mat, (FontRenderer)this.field_230712_o_, (String)text, (int)x, (int)y, (int)0xFFFFFF);
    }

    public void generateDigimonList() {
        if (this.currentRow != 0 && this.searchBar.func_230999_j_()) {
            this.currentRow = 0;
            this.func_231160_c_();
        }
        this.digimon = this.getDigimonList();
    }

    private List<FieldGuide.DigimonTypes> getDigimonList() {
        ArrayList species = Lists.newArrayList();
        for (int x = 0; x < FieldGuide.DigimonTypes.values().length - UNLISTED; ++x) {
            if (!FieldGuide.DigimonTypes.values()[x].func_176610_l().toLowerCase().startsWith(this.searchBar.func_146179_b().toLowerCase())) continue;
            species.add(FieldGuide.DigimonTypes.values()[x]);
        }
        return species;
    }
}

