/*
 * Decompiled with CFR 0.152.
 */
package mod.cyan.digimobs.client.models;

import mod.cyan.digimobs.entities.DEButterflyEntity;
import mod.cyan.digimobs.entities.DigimonEntity;
import net.minecraft.util.ResourceLocation;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

public class DigimonModel
extends AnimatedGeoModel<DigimonEntity> {
    public ResourceLocation getModelLocation(DigimonEntity object) {
        return new ResourceLocation("digimobs", "geo/" + object.getInternalDigimonName() + ".geo.json");
    }

    public ResourceLocation getTextureLocation(DigimonEntity object) {
        if (object instanceof DEButterflyEntity) {
            return new ResourceLocation("digimobs", "textures/entity/" + object.setup.getDigimonTexture() + ((DEButterflyEntity)object).setup.getColor().toLowerCase() + ".png");
        }
        if (!object.setup.getSpecialTexture().isEmpty() && object.hasSkin()) {
            return new ResourceLocation("digimobs", "textures/entity/" + object.setup.getDigimonTexture() + object.setup.getSpecialTexture() + ".png");
        }
        if (object.setup.getColor().equals("Anomaly")) {
            return new ResourceLocation("digimobs", "textures/entity/" + object.setup.getDigimonTexture() + "a.png");
        }
        return new ResourceLocation("digimobs", "textures/entity/" + object.setup.getDigimonTexture() + ".png");
    }

    public ResourceLocation getAnimationFileLocation(DigimonEntity object) {
        return new ResourceLocation("digimobs", "animations/" + object.getInternalDigimonName() + ".json");
    }

    public void setLivingAnimations(DigimonEntity entity, Integer uniqueID, AnimationEvent<?> customPredicate) {
        this.setLivingAnimations(entity, uniqueID, customPredicate);
        IBone head = this.getAnimationProcessor().getBone("HEAD");
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        if (!(entity instanceof DEButterflyEntity)) {
            head.setRotationY(extraData.netHeadYaw * ((float)Math.PI / 180));
        }
    }
}

