/*
 * Decompiled with CFR 0.152.
 */
package mod.cyan.digimobs.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.UUID;
import mod.cyan.digimobs.Digimobs;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.WrittenBookItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;

public class DigiCodeCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder root = Commands.func_197057_a((String)"digicode");
        root.then(Commands.func_197057_a((String)"say").then(Commands.func_197056_a((String)"text", (ArgumentType)StringArgumentType.greedyString()).executes(DigiCodeCommand::commandSay)));
        root.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"hand").requires(p -> p.func_197034_c(2))).executes(DigiCodeCommand::commandHand));
        LiteralArgumentBuilder book = (LiteralArgumentBuilder)Commands.func_197057_a((String)"book").requires(p -> p.func_197034_c(2));
        book.then(Commands.func_197057_a((String)"encode").executes(ctx -> DigiCodeCommand.commandBook((CommandContext<CommandSource>)ctx, Digimobs.FONT_DIGIMOBS)));
        book.then(Commands.func_197057_a((String)"decode").executes(ctx -> DigiCodeCommand.commandBook((CommandContext<CommandSource>)ctx, Digimobs.FONT_DEFAULT)));
        root.then((ArgumentBuilder)book);
        LiteralArgumentBuilder tile = (LiteralArgumentBuilder)Commands.func_197057_a((String)"tile").requires(p -> p.func_197034_c(2));
        tile.then(Commands.func_197057_a((String)"encode").then(Commands.func_197056_a((String)"pos", (ArgumentType)BlockPosArgument.func_197276_a()).executes(ctx -> DigiCodeCommand.commandPos((CommandContext<CommandSource>)ctx, Digimobs.FONT_DIGIMOBS))));
        tile.then(Commands.func_197057_a((String)"decode").then(Commands.func_197056_a((String)"pos", (ArgumentType)BlockPosArgument.func_197276_a()).executes(ctx -> DigiCodeCommand.commandPos((CommandContext<CommandSource>)ctx, Digimobs.FONT_DEFAULT))));
        root.then((ArgumentBuilder)tile);
        dispatcher.register(root);
    }

    private static int commandSay(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ITextComponent inputMessage = DigiCodeCommand.applyFont((ITextComponent)new StringTextComponent(StringArgumentType.getString(ctx, (String)"text")), Digimobs.FONT_DIGIMOBS);
        TranslationTextComponent txtMessage = new TranslationTextComponent("chat.type.announcement", new Object[]{((CommandSource)ctx.getSource()).func_197019_b(), inputMessage});
        Entity sender = ((CommandSource)ctx.getSource()).func_197022_f();
        ChatType chatType = sender != null ? ChatType.CHAT : ChatType.SYSTEM;
        UUID senderId = sender != null ? sender.func_110124_au() : Util.field_240973_b_;
        ((CommandSource)ctx.getSource()).func_197028_i().func_184103_al().func_232641_a_((ITextComponent)txtMessage, chatType, senderId);
        return 1;
    }

    private static int commandHand(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        Entity sender = ((CommandSource)ctx.getSource()).func_197022_f();
        if (sender instanceof LivingEntity) {
            ItemStack stack = ((LivingEntity)sender).func_184614_ca();
            stack.func_200302_a(DigiCodeCommand.applyFont(stack.func_151000_E(), Digimobs.FONT_DIGIMOBS));
        }
        return 1;
    }

    private static int commandPos(CommandContext<CommandSource> ctx, ResourceLocation font) throws CommandSyntaxException {
        BlockPos pos;
        ServerWorld world = ((CommandSource)ctx.getSource()).func_197023_e();
        TileEntity tile = world.func_175625_s(pos = BlockPosArgument.func_197273_a(ctx, (String)"pos"));
        if (tile != null) {
            if (tile instanceof LockableTileEntity) {
                LockableTileEntity lockable = (LockableTileEntity)tile;
                lockable.func_213903_a(DigiCodeCommand.applyFont(lockable.func_200200_C_(), font));
            }
            if (tile instanceof SignTileEntity) {
                SignTileEntity sign = (SignTileEntity)tile;
                CompoundNBT signTag = sign.func_189515_b(new CompoundNBT());
                for (int line = 1; line <= 4; ++line) {
                    String lineData = signTag.func_74779_i("Text" + line);
                    ITextComponent lineText = DigiCodeCommand.applyFont((ITextComponent)ITextComponent.Serializer.func_240643_a_((String)(lineData.isEmpty() ? "\"\"" : lineData)), font);
                    sign.func_212365_a(line - 1, lineText);
                }
                world.func_184138_a(pos, tile.func_195044_w(), tile.func_195044_w(), 11);
            }
        }
        return 1;
    }

    private static int commandBook(CommandContext<CommandSource> ctx, ResourceLocation font) throws CommandSyntaxException {
        ItemStack stack;
        Entity sender = ((CommandSource)ctx.getSource()).func_197022_f();
        if (sender instanceof LivingEntity && (stack = ((LivingEntity)sender).func_184614_ca()).func_77973_b() instanceof WrittenBookItem && stack.func_77942_o()) {
            stack.func_200302_a(DigiCodeCommand.applyFont(stack.func_151000_E(), font));
            CompoundNBT stackTag = stack.func_77978_p();
            if (stackTag != null) {
                ListNBT pageData = stackTag.func_150295_c("pages", 8);
                for (int pageNum = 0; pageNum < pageData.size(); ++pageNum) {
                    IFormattableTextComponent pageText = ITextComponent.Serializer.func_240644_b_((String)pageData.func_150307_f(pageNum));
                    DigiCodeCommand.applyFont((ITextComponent)pageText, font);
                    pageData.set(pageNum, (INBT)StringNBT.func_229705_a_((String)ITextComponent.Serializer.func_150696_a((ITextComponent)pageText)));
                }
                stackTag.func_218657_a("pages", (INBT)pageData);
            }
        }
        return 1;
    }

    private static ITextComponent applyFont(ITextComponent text, ResourceLocation font) {
        if (text instanceof IFormattableTextComponent) {
            ((IFormattableTextComponent)text).func_230530_a_(text.func_150256_b().func_240719_a_(font));
        }
        text.func_150253_a().forEach(sib -> DigiCodeCommand.applyFont(sib, font));
        return text;
    }
}

