/*
 * Decompiled with CFR 0.152.
 */
package mod.cyan.digimobs.entities;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import mod.cyan.digimobs.config.DigimobsConfig;
import mod.cyan.digimobs.config.EntityConfig;
import mod.cyan.digimobs.entities.ai.DigimonAttackGoal;
import mod.cyan.digimobs.entities.ai.LogicFloatFlySwim;
import mod.cyan.digimobs.entities.ai.LogicInLiquid;
import mod.cyan.digimobs.entities.ai.LogicMounts;
import mod.cyan.digimobs.entities.setup.Conversation;
import mod.cyan.digimobs.entities.setup.DigimonSetup;
import mod.cyan.digimobs.entities.setup.Digivolutions;
import mod.cyan.digimobs.entities.setup.FieldGuide;
import mod.cyan.digimobs.entities.setup.NPCSetup;
import mod.cyan.digimobs.entities.setup.SpawnParameters;
import mod.cyan.digimobs.entities.setup.Specials;
import mod.cyan.digimobs.entities.setup.SpecialsList;
import mod.cyan.digimobs.entities.setup.Stats;
import mod.cyan.digimobs.entities.setup.helpers.AEF;
import mod.cyan.digimobs.entities.setup.helpers.Form;
import mod.cyan.digimobs.entities.setup.helpers.Mounts;
import mod.cyan.digimobs.init.ModItems;
import mod.cyan.digimobs.init.ModPotions;
import mod.cyan.digimobs.util.CommandChatHandler;
import mod.cyan.digimobs.util.Tools;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.PatrolVillageGoal;
import net.minecraft.entity.ai.goal.ReturnToVillageGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.EnumUtils;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class DigimonEntity
extends TameableEntity
implements IAnimatable,
IInventoryChangedListener,
IJumpingMount {
    public DigimonSetup setup = new DigimonSetup(this);
    public Stats stats = new Stats(this);
    public Digivolutions digivolutions = new Digivolutions(this);
    public Specials specials = new Specials(this);
    public Conversation convo = new Conversation(this);
    public NPCSetup npcsetup = new NPCSetup(this);
    public LazyOptional<?> itemHandler = null;
    private static final DataParameter<Boolean> INTERACTING = EntityDataManager.func_187226_a(DigimonEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<String> WORLDTEXT = EntityDataManager.func_187226_a(DigimonEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> ATTACKTYPE = EntityDataManager.func_187226_a(DigimonEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> ENEMYINFO = EntityDataManager.func_187226_a(DigimonEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<CompoundNBT> DIGIMON = EntityDataManager.func_187226_a(DigimonEntity.class, (IDataSerializer)DataSerializers.field_192734_n);
    private static final DataParameter<CompoundNBT> STATS = EntityDataManager.func_187226_a(DigimonEntity.class, (IDataSerializer)DataSerializers.field_192734_n);
    private static final DataParameter<CompoundNBT> EVOLUTIONS = EntityDataManager.func_187226_a(DigimonEntity.class, (IDataSerializer)DataSerializers.field_192734_n);
    private static final DataParameter<CompoundNBT> SPECIALS = EntityDataManager.func_187226_a(DigimonEntity.class, (IDataSerializer)DataSerializers.field_192734_n);
    private static final DataParameter<CompoundNBT> NPCINFO = EntityDataManager.func_187226_a(DigimonEntity.class, (IDataSerializer)DataSerializers.field_192734_n);
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    public short vpetcolor = (short)-1;
    protected int animationTime;
    private int evolutionTime;
    protected int speechTime;
    public int abilitycooldown;
    protected float jumpPower;
    LogicInLiquid liquidlogic = new LogicInLiquid(this);
    LogicFloatFlySwim floatflyswimlogic = new LogicFloatFlySwim(this);
    LogicMounts mountlogic = new LogicMounts(this);
    LogicFloatFlySwim.WalkController walklogic = new LogicFloatFlySwim.WalkController(this);
    LogicFloatFlySwim.FlyController flylogic = new LogicFloatFlySwim.FlyController(this);
    LogicFloatFlySwim.SwimController swimlogic = new LogicFloatFlySwim.SwimController(this);
    public String levelrange;
    public int weathercond = 0;
    public int timecond = 0;
    public int moonphasecond = 0;
    public Inventory inventory;
    public String[] specialskin = new String[]{"agumon", "kamemon", "armadillomon", "kunemon", "elecmon", "salamon", "lopmon", "lunamon", "terriermon", "gaomon", "kingchessmon", "queenchessmon", "guilmon", "growlmon", "turuiemon", "lekismon", "antylamondata", "wargrowlmon", "gallantmon", "miragegaogamon", "ankylomon", "gammamon", "gatomon", "kausgammamon", "palmon", "stingmon", "syakomon", "tanemon"};
    public String[] modechanges = new String[]{"metalgreymon", "metalgreymonalterous", "weregarurumon", "weregarurumonsagittarius", "beelzemon", "beelzemonbm", "gallantmon", "gallantmoncm", "chaosgallantmon", "chaosgallantmoncm", "imperialdramondm", "imperialdramonfm", "blackimperialdramondm", "blackimperialdramonfm", "leopardmon", "leopardmonlm"};
    public String[] jogresslist = new String[]{"exveemon", "stingmon", "aquilamon", "gatomon", "ankylomon", "angemon", "wargreymon", "metalgarurumon", "angewomon", "ladydevimon", "apollomon", "dianamon", "blackwargreymon", "blackmetalgarurumon", "slayerdramon", "breakdramon", "megadramon", "gigadramon"};
    public String[] pokemonskin = new String[]{"agumon", "kamemon", "armadillomon", "kunemon", "elecmon", "salamon", "lopmon", "terriermon", "ankylomon", "gammamon", "gatomon", "kausgammamon", "palmon", "stingmon", "syakomon", "tanemon", "wormmon"};
    public String[] chinesenewyear = new String[]{"lunamon", "lekismon", "lopmon", "turuiemon", "antylamondata", "cherubimonvirtue"};

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74777_a("vpetcolor", this.vpetcolor);
        compound.func_74768_a("enemyinfo", this.getEnemyInfo());
        compound.func_74778_a("text", this.getWorldText());
        compound.func_74768_a("attacktype", this.getAttackType());
        if (!this.getDigimon().isEmpty()) {
            compound.func_218657_a("Digimon", (INBT)this.getDigimon());
        }
        if (!this.getStats().isEmpty()) {
            compound.func_218657_a("Stats", (INBT)this.getStats());
        }
        if (!this.getEvolutions().isEmpty()) {
            compound.func_218657_a("Evolutions", (INBT)this.getEvolutions());
        }
        if (!this.getSpecials().isEmpty()) {
            compound.func_218657_a("Specials", (INBT)this.getSpecials());
        }
        if (!this.getNPC().isEmpty()) {
            compound.func_218657_a("NPC", (INBT)this.getNPC());
        }
        ListNBT listnbt = new ListNBT();
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack itemstack = this.inventory.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            CompoundNBT compoundnbt = new CompoundNBT();
            compoundnbt.func_74774_a("Slot", (byte)i);
            itemstack.func_77955_b(compoundnbt);
            listnbt.add((Object)compoundnbt);
        }
        compound.func_218657_a("Inventory", (INBT)listnbt);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.vpetcolor = compound.func_74765_d("vpetcolor");
        this.setAttackType(compound.func_74762_e("attacktype"));
        this.setEnemyInfo(compound.func_74762_e("enemyinfo"));
        this.setWorldText(compound.func_74779_i("text"));
        if (compound.func_74764_b("Digimon")) {
            this.setDigimon(compound.func_74775_l("Digimon"));
        }
        if (compound.func_74764_b("Stats")) {
            this.setStats(compound.func_74775_l("Stats"));
        }
        if (compound.func_74764_b("Evolutions")) {
            this.setEvolutions(compound.func_74775_l("Evolutions"));
        }
        if (compound.func_74764_b("Specials")) {
            this.setSpecials(compound.func_74775_l("Specials"));
        }
        if (compound.func_74764_b("NPC")) {
            this.setNPC(compound.func_74775_l("NPC"));
        }
        ListNBT listnbt = compound.func_150295_c("Inventory", 10);
        this.createInventory();
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundNBT compoundnbt = listnbt.func_150305_b(i);
            int j = compoundnbt.func_74771_c("Slot") & 0xFF;
            if (j >= this.inventory.func_70302_i_()) continue;
            this.inventory.func_70299_a(j, ItemStack.func_199557_a((CompoundNBT)compoundnbt));
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233821_d_, (double)0.3f).func_233815_a_(Attributes.field_233818_a_, 100.0).func_233815_a_(Attributes.field_233823_f_, 2.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(INTERACTING, (Object)false);
        this.field_70180_af.func_187214_a(WORLDTEXT, (Object)"");
        this.field_70180_af.func_187214_a(ENEMYINFO, (Object)-1);
        this.field_70180_af.func_187214_a(ATTACKTYPE, (Object)0);
        this.field_70180_af.func_187214_a(DIGIMON, (Object)new CompoundNBT());
        this.field_70180_af.func_187214_a(STATS, (Object)new CompoundNBT());
        this.field_70180_af.func_187214_a(EVOLUTIONS, (Object)new CompoundNBT());
        this.field_70180_af.func_187214_a(SPECIALS, (Object)new CompoundNBT());
        this.field_70180_af.func_187214_a(NPCINFO, (Object)new CompoundNBT());
    }

    protected void func_184651_r() {
        if (this.isNPC()) {
            this.field_70714_bg.func_75776_a(2, (Goal)new MoveTowardsTargetGoal((CreatureEntity)this, 0.9, 32.0f));
            this.field_70714_bg.func_75776_a(2, (Goal)new ReturnToVillageGoal((CreatureEntity)this, 0.6, false));
            this.field_70714_bg.func_75776_a(3, (Goal)new PatrolVillageGoal((CreatureEntity)this, 0.6));
            this.field_70714_bg.func_75776_a(1, (Goal)new DigimonAttackGoal(this, 1.0, true, 0));
            this.field_70714_bg.func_75776_a(6, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 5.0f, 2.0f, false));
            this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
            this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
            this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        } else {
            this.field_70714_bg.func_75776_a(2, (Goal)new SitGoal((TameableEntity)this));
        }
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowOwnerGoal((TameableEntity)this, 10.0, 2.0f, 2.0f, false));
        this.field_70714_bg.func_75776_a(5, (Goal)new DigimonAttackGoal(this, 1.0, true, 0));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.isInteracting() && this.field_70146_Z.nextInt(100) + 1 >= 100) {
            this.setInteracting(false);
        }
        if (!this.field_70170_p.field_72995_K && this.getEnemyInfo() > 0 && this.func_70638_az() == null) {
            this.setEnemyInfo(0);
        }
        if (this.stats.getLevel() == 0) {
            this.stats.setLevel(1);
        }
        this.liquidlogic.tick(this.field_70170_p);
        this.walklogic.func_75641_c();
        this.flylogic.func_75641_c();
        this.swimlogic.func_75641_c();
        this.floatflyswimlogic.tick(this.field_70170_p);
    }

    public boolean func_70097_a(DamageSource strafeDamageSource, float vertical) {
        if (strafeDamageSource == DamageSource.field_76368_d) {
            return false;
        }
        return super.func_70097_a(strafeDamageSource, vertical);
    }

    public boolean func_225503_b_(float p_225503_1_, float p_225503_2_) {
        if (this.setup.getPassive().equals("Icarus")) {
            return false;
        }
        if (this.func_184207_aI()) {
            return false;
        }
        return super.func_225503_b_(p_225503_1_, p_225503_2_);
    }

    public boolean func_70648_aU() {
        return this.swims() || this.stats.getElement() == AEF.AefTypes.WATER || this.stats.getField() == AEF.AefTypes.DEEPSAVERS;
    }

    public void func_70030_z() {
        super.func_70030_z();
        this.Age();
        if (this.func_70909_n() && this.isSpiral()) {
            this.func_174812_G();
        }
        if (this.npcsetup.getJob().equals("Vendor") || this.npcsetup.getJob().equals("Weapon Vendor") || this.npcsetup.getJob().equals("Armor Vendor") || this.npcsetup.getJob().equals("Food Vendor")) {
            if (!this.getNPC().func_74764_b("VendorRefresh")) {
                this.npcsetup.setVendorRefresh(96000);
            }
            if (this.npcsetup.getVendorRefresh() > 0) {
                this.npcsetup.setVendorRefresh(this.npcsetup.getVendorRefresh() - 1);
            }
            if (this.npcsetup.getVendorRefresh() <= 0) {
                if (this.npcsetup.getJob().equals("Vendor")) {
                    this.npcsetup.refreshShop(DigimobsConfig.ServerConfig.VENDORSHOPS.spawnBiomes);
                }
                if (this.npcsetup.getJob().equals("Weapon Vendor")) {
                    this.npcsetup.refreshShop(this.npcsetup.weaponvendor);
                }
                if (this.npcsetup.getJob().equals("Armor Vendor")) {
                    this.npcsetup.refreshShop(this.npcsetup.armorvendor);
                }
                if (this.npcsetup.getJob().equals("Food Vendor")) {
                    this.npcsetup.refreshShop(this.npcsetup.foodvendor);
                }
                this.npcsetup.setVendorRefresh(96000);
            }
        }
        if (this.isNPC() && !this.func_70644_a(Effects.field_76428_l) && this.func_110143_aJ() < this.func_110138_aP()) {
            this.func_195064_c(new EffectInstance(Effects.field_76428_l, 60, 6, false, false));
        }
        if ((float)this.stats.getWeight() >= (float)this.stats.getMaxWeight() * 0.75f && !this.func_70644_a(Effects.field_76428_l) && this.func_233684_eK_()) {
            this.func_195064_c(new EffectInstance(Effects.field_76428_l, 30, 1, false, false));
        }
        if (this.setup.getPassive().equals("Revitalize") && !this.func_70644_a(Effects.field_76428_l) && this.func_110143_aJ() <= this.func_110138_aP() / 2.0f) {
            this.func_195064_c(new EffectInstance(Effects.field_76428_l, 30, 1, false, false));
        }
        if (this.setup.getPassive().equals("Recharge") && !this.func_70644_a((Effect)ModPotions.RECHARGE.get()) && this.stats.getEnergy() <= this.stats.getMaxEnergy() / 2) {
            this.func_195064_c(new EffectInstance((Effect)ModPotions.RECHARGE.get(), 30, 1, false, false));
        }
        if (this.stats.getWeight() <= 0 && !this.func_233685_eM_() && this.func_70638_az() == null) {
            this.func_233687_w_(true);
        }
        if (this.abilitycooldown > 0) {
            --this.abilitycooldown;
            if (this.abilitycooldown == 1 && this.func_70902_q() != null) {
                CommandChatHandler.sendChat((ICommandSource)this.func_70902_q(), this.func_184753_b(), "Ability Ready!", new Object[0]);
            }
        }
        if (!this.getWorldText().isEmpty()) {
            ++this.speechTime;
            if (this.speechTime >= 100) {
                this.speechTime = 0;
                this.setWorldText("");
            }
        }
        if (this.getAttackType() >= 1 && this.func_70638_az() == null) {
            ++this.animationTime;
            if (this.animationTime >= 100) {
                this.animationTime = 0;
                this.setAttackType(0);
            }
        }
        if (this.getDigimon().func_74764_b("digivolvingstart")) {
            this.Evolve();
        }
        if (this.getDigimon().func_74767_n("digivolvingfinish")) {
            ++this.evolutionTime;
            if (this.evolutionTime >= 70) {
                this.getDigimon().func_82580_o("digivolvingfinish");
                this.getDigimon().func_82580_o("evolutiontype");
                this.evolutionTime = 0;
                this.func_233687_w_(false);
            }
        }
        if (this.func_70909_n() && this.func_70902_q() == null) {
            this.func_233687_w_(true);
        }
    }

    public void Evolve() {
        DigimonEntity evolution;
        EntityType type;
        PlayerEntity theplayer = (PlayerEntity)this.func_70902_q();
        ++this.evolutionTime;
        int bonustime = 0;
        if (this.getDigimon().func_74779_i("evolutiontype").equals("armor")) {
            bonustime = 36;
        }
        if (this.getDigimon().func_74779_i("evolutiontype").equals("jogress")) {
            bonustime = 20;
        }
        if (this.evolutionTime == 10 && !this.field_70170_p.field_72995_K && this.stats.getForm() != Form.FormTypes.DIGITALENTITY && this.func_70909_n()) {
            CommandChatHandler.sendChat((ICommandSource)theplayer, theplayer.func_110124_au(), this.setup.getName() + "...", new Object[0]);
            if (this.getDigimon().func_74779_i("evolutiontype").equals("armor")) {
                CommandChatHandler.sendChat((ICommandSource)theplayer, theplayer.func_110124_au(), "msg.armordigivolve.txt", new Object[0]);
            }
            if (this.getDigimon().func_74779_i("evolutiontype").equals("jogress")) {
                CommandChatHandler.sendChat((ICommandSource)theplayer, theplayer.func_110124_au(), "msg.jogressdigivolve.txt", new Object[0]);
            } else {
                CommandChatHandler.sendChat((ICommandSource)theplayer, theplayer.func_110124_au(), "msg.digivolve.txt", new Object[0]);
            }
            if (this.getDigimon().func_74767_n("todelete")) {
                this.func_70106_y();
            }
        }
        if (this.stats.getForm() != Form.FormTypes.DIGITALENTITY && this.evolutionTime == 15) {
            type = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("digimobs", "evolution"));
            evolution = (DigimonEntity)type.func_200721_a(this.field_70170_p);
            this.digivolutions.copyStats(this, evolution);
            this.stats.setEnergy(this.stats.getEnergy() - this.stats.getMaxEnergy() / 2 - 1);
            evolution.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            evolution.getDigimon().func_74778_a("digivolvingstart", this.getDigimon().func_74779_i("digivolvingstart"));
            this.func_70106_y();
            this.field_70170_p.func_217376_c((Entity)evolution);
            evolution.func_233687_w_(true);
        }
        if (this.evolutionTime >= 63 + bonustime) {
            type = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("digimobs", this.getDigimon().func_74779_i("digivolvingstart").toLowerCase()));
            evolution = (DigimonEntity)type.func_200721_a(this.field_70170_p);
            if (!this.field_70170_p.field_72995_K) {
                this.digivolutions.copyStats(this, evolution);
                evolution.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
                this.func_70106_y();
                this.field_70170_p.func_217376_c((Entity)evolution);
                this.getDigimon().func_82580_o("digivolvingstart");
                evolution.getDigimon().func_74757_a("digivolvingfinish", true);
                if (this.func_70909_n()) {
                    CommandChatHandler.sendChat((ICommandSource)theplayer, theplayer.func_110124_au(), evolution.setup.getName() + "!", new Object[0]);
                }
            }
        }
    }

    public void createBranch(DigimonEntity digi, Form.FormTypes form, String evo) {
        CompoundNBT champions = digi.digivolutions.getChampionForms();
        CompoundNBT ultimates = digi.digivolutions.getUltimateForms();
        CompoundNBT megas = digi.digivolutions.getMegaForms();
        CompoundNBT currentform = digi.getEvolutions().func_74775_l(FieldGuide.DigimonTypes.valueOf(digi.getInternalDigimonName().toUpperCase()).toString());
        CompoundNBT championform = champions.func_74775_l(FieldGuide.DigimonTypes.valueOf(digi.getInternalDigimonName().toUpperCase()).toString());
        CompoundNBT ultimateform = ultimates.func_74775_l(FieldGuide.DigimonTypes.valueOf(digi.getInternalDigimonName().toUpperCase()).toString());
        if (digi.digivolutions.getEmptySlots() <= 0) {
            CommandChatHandler.sendChat((ICommandSource)digi.func_70902_q(), digi.func_184753_b(), "\u6402C" + digi.setup.getTrueName() + " " + new TranslationTextComponent("evolution1.txt").getString(), new Object[0]);
            return;
        }
        if (digi.stats.getForm() != form) {
            CommandChatHandler.sendChat((ICommandSource)digi.func_70902_q(), digi.func_184753_b(), "\u6402C" + new TranslationTextComponent("evolution5.txt").getString() + new TranslationTextComponent((Object)((Object)form) + ".stat").getString().toLowerCase(), new Object[0]);
            return;
        }
        if (form == Form.FormTypes.ROOKIE && champions.func_186856_d() < digi.digivolutions.getMaxChampion()) {
            if (currentform.func_74779_i("ChampionForm1").equals(evo)) {
                CommandChatHandler.sendChat((ICommandSource)digi.func_70902_q(), digi.func_184753_b(), "\u6402C" + new TranslationTextComponent("evolution6.txt").getString(), new Object[0]);
                return;
            }
            if (currentform.func_74779_i("ChampionForm2").equals(evo)) {
                CommandChatHandler.sendChat((ICommandSource)digi.func_70902_q(), digi.func_184753_b(), "\u6402C" + new TranslationTextComponent("evolution6.txt").getString(), new Object[0]);
                return;
            }
            if (currentform.func_74779_i("ChampionForm3").equals(evo)) {
                CommandChatHandler.sendChat((ICommandSource)digi.func_70902_q(), digi.func_184753_b(), "\u6402C" + new TranslationTextComponent("evolution6.txt").getString(), new Object[0]);
                return;
            }
            if (currentform.func_74779_i("ChampionForm4").equals(evo)) {
                CommandChatHandler.sendChat((ICommandSource)digi.func_70902_q(), digi.func_184753_b(), "\u6402C" + new TranslationTextComponent("evolution6.txt").getString(), new Object[0]);
                return;
            }
            if (!champions.func_74764_b(evo)) {
                champions.func_218657_a(evo, (INBT)new CompoundNBT());
            }
            currentform.func_74778_a("ChampionForm" + (currentform.func_186856_d() + 1), evo);
            digi.digivolutions.setEmptySlots(digi.digivolutions.getEmptySlots() - 1);
            CommandChatHandler.sendChat((ICommandSource)digi.func_70902_q(), digi.func_184753_b(), "\u6402a" + digi.setup.getTrueName() + " " + new TranslationTextComponent("evolution8.txt").getString(), new Object[0]);
        } else if (form == Form.FormTypes.CHAMPION && ultimates.func_186856_d() < digi.digivolutions.getMaxUltimate()) {
            if (currentform.func_74779_i("UltimateForm1").equals(evo)) {
                CommandChatHandler.sendChat((ICommandSource)digi.func_70902_q(), digi.func_184753_b(), "\u6402C" + new TranslationTextComponent("evolution6.txt").getString(), new Object[0]);
                return;
            }
            if (currentform.func_74779_i("UltimateForm2").equals(evo)) {
                CommandChatHandler.sendChat((ICommandSource)digi.func_70902_q(), digi.func_184753_b(), "\u6402C" + new TranslationTextComponent("evolution6.txt").getString(), new Object[0]);
                return;
            }
            if (currentform.func_74779_i("UltimateForm3").equals(evo)) {
                CommandChatHandler.sendChat((ICommandSource)digi.func_70902_q(), digi.func_184753_b(), "\u6402C" + new TranslationTextComponent("evolution6.txt").getString(), new Object[0]);
                return;
            }
            if (currentform.func_74779_i("UltimateForm4").equals(evo)) {
                CommandChatHandler.sendChat((ICommandSource)digi.func_70902_q(), digi.func_184753_b(), "\u6402C" + new TranslationTextComponent("evolution6.txt").getString(), new Object[0]);
                return;
            }
            if (!ultimates.func_74764_b(evo)) {
                ultimates.func_218657_a(evo, (INBT)new CompoundNBT());
            }
            championform.func_74778_a("UltimateForm" + (championform.func_186856_d() + 1), evo);
            digi.digivolutions.setEmptySlots(digi.digivolutions.getEmptySlots() - 1);
            CommandChatHandler.sendChat((ICommandSource)digi.func_70902_q(), digi.func_184753_b(), "\u6402a" + digi.setup.getTrueName() + " " + new TranslationTextComponent("evolution8.txt").getString(), new Object[0]);
        } else if (form == Form.FormTypes.ULTIMATE && megas.func_186856_d() < digi.digivolutions.getMaxMega()) {
            if (currentform.func_74779_i("MegaForm1").equals(evo)) {
                CommandChatHandler.sendChat((ICommandSource)digi.func_70902_q(), digi.func_184753_b(), "\u6402C" + new TranslationTextComponent("evolution6.txt").getString(), new Object[0]);
                return;
            }
            if (currentform.func_74779_i("MegaForm2").equals(evo)) {
                CommandChatHandler.sendChat((ICommandSource)digi.func_70902_q(), digi.func_184753_b(), "\u6402C" + new TranslationTextComponent("evolution6.txt").getString(), new Object[0]);
                return;
            }
            if (currentform.func_74779_i("MegaForm3").equals(evo)) {
                CommandChatHandler.sendChat((ICommandSource)digi.func_70902_q(), digi.func_184753_b(), "\u6402C" + new TranslationTextComponent("evolution6.txt").getString(), new Object[0]);
                return;
            }
            if (currentform.func_74779_i("MegaForm4").equals(evo)) {
                CommandChatHandler.sendChat((ICommandSource)digi.func_70902_q(), digi.func_184753_b(), "\u6402C" + new TranslationTextComponent("evolution6.txt").getString(), new Object[0]);
                return;
            }
            if (!megas.func_74764_b(evo)) {
                megas.func_218657_a(evo, (INBT)new CompoundNBT());
            }
            ultimateform.func_74778_a("MegaForm" + (ultimateform.func_186856_d() + 1), evo);
            digi.digivolutions.setEmptySlots(digi.digivolutions.getEmptySlots() - 1);
            CommandChatHandler.sendChat((ICommandSource)digi.func_70902_q(), digi.func_184753_b(), "\u6402a" + digi.setup.getTrueName() + " " + new TranslationTextComponent("evolution8.txt").getString(), new Object[0]);
        } else {
            CommandChatHandler.sendChat((ICommandSource)digi.func_70902_q(), digi.func_184753_b(), "\u6402C" + new TranslationTextComponent("evolution7.txt").getString(), new Object[0]);
            return;
        }
    }

    public void createBranch(ItemStack stack, DigimonEntity digi, Form.FormTypes form, @Nullable AEF.AefTypes attribute, @Nullable AEF.AefTypes element, @Nullable AEF.AefTypes field, String evo) {
        CompoundNBT champions = digi.digivolutions.getChampionForms();
        CompoundNBT ultimates = digi.digivolutions.getUltimateForms();
        CompoundNBT megas = digi.digivolutions.getMegaForms();
        CompoundNBT currentform = digi.getEvolutions().func_74775_l(FieldGuide.DigimonTypes.valueOf(digi.getInternalDigimonName().toUpperCase()).toString());
        CompoundNBT championform = champions.func_74775_l(FieldGuide.DigimonTypes.valueOf(digi.getInternalDigimonName().toUpperCase()).toString());
        CompoundNBT ultimateform = ultimates.func_74775_l(FieldGuide.DigimonTypes.valueOf(digi.getInternalDigimonName().toUpperCase()).toString());
        if (digi.digivolutions.getEmptySlots() <= 0) {
            CommandChatHandler.sendChat((ICommandSource)digi.func_70902_q(), digi.func_184753_b(), "\u6402C" + digi.setup.getTrueName() + " " + new TranslationTextComponent("evolution1.txt").getString(), new Object[0]);
            return;
        }
        if (attribute != null && digi.stats.getAttribute() != attribute) {
            CommandChatHandler.sendChat((ICommandSource)digi.func_70902_q(), digi.func_184753_b(), "\u6402C" + new TranslationTextComponent("evolution2.txt").getString() + new TranslationTextComponent((Object)((Object)attribute) + ".stat").getString().toLowerCase(), new Object[0]);
            return;
        }
        if (element != null && digi.stats.getElement() != element) {
            CommandChatHandler.sendChat((ICommandSource)digi.func_70902_q(), digi.func_184753_b(), "\u6402C" + new TranslationTextComponent("evolution3.txt").getString() + new TranslationTextComponent((Object)((Object)element) + ".stat").getString().toLowerCase(), new Object[0]);
            return;
        }
        if (field != null && digi.stats.getField() != field) {
            CommandChatHandler.sendChat((ICommandSource)digi.func_70902_q(), digi.func_184753_b(), "\u6402C" + new TranslationTextComponent("evolution4.txt").getString() + new TranslationTextComponent((Object)((Object)field) + ".stat").getString().toLowerCase(), new Object[0]);
            return;
        }
        if (digi.stats.getForm() != form) {
            CommandChatHandler.sendChat((ICommandSource)digi.func_70902_q(), digi.func_184753_b(), "\u6402C" + new TranslationTextComponent("evolution5.txt").getString() + new TranslationTextComponent((Object)((Object)form) + ".stat").getString().toLowerCase(), new Object[0]);
            return;
        }
        if (form == Form.FormTypes.ROOKIE && champions.func_186856_d() < digi.digivolutions.getMaxChampion()) {
            if (currentform.func_74779_i("ChampionForm1").equals(evo)) {
                CommandChatHandler.sendChat((ICommandSource)digi.func_70902_q(), digi.func_184753_b(), "\u6402C" + new TranslationTextComponent("evolution6.txt").getString(), new Object[0]);
                return;
            }
            if (currentform.func_74779_i("ChampionForm2").equals(evo)) {
                CommandChatHandler.sendChat((ICommandSource)digi.func_70902_q(), digi.func_184753_b(), "\u6402C" + new TranslationTextComponent("evolution6.txt").getString(), new Object[0]);
                return;
            }
            if (currentform.func_74779_i("ChampionForm3").equals(evo)) {
                CommandChatHandler.sendChat((ICommandSource)digi.func_70902_q(), digi.func_184753_b(), "\u6402C" + new TranslationTextComponent("evolution6.txt").getString(), new Object[0]);
                return;
            }
            if (currentform.func_74779_i("ChampionForm4").equals(evo)) {
                CommandChatHandler.sendChat((ICommandSource)digi.func_70902_q(), digi.func_184753_b(), "\u6402C" + new TranslationTextComponent("evolution6.txt").getString(), new Object[0]);
                return;
            }
            if (!champions.func_74764_b(evo)) {
                champions.func_218657_a(evo, (INBT)new CompoundNBT());
            }
            currentform.func_74778_a("ChampionForm" + (currentform.func_186856_d() + 1), evo);
            stack.func_190918_g(1);
            digi.digivolutions.setEmptySlots(digi.digivolutions.getEmptySlots() - 1);
            CommandChatHandler.sendChat((ICommandSource)digi.func_70902_q(), digi.func_184753_b(), "\u6402a" + digi.setup.getTrueName() + " " + new TranslationTextComponent("evolution8.txt").getString(), new Object[0]);
        } else if (form == Form.FormTypes.CHAMPION && ultimates.func_186856_d() < digi.digivolutions.getMaxUltimate()) {
            if (currentform.func_74779_i("UltimateForm1").equals(evo)) {
                CommandChatHandler.sendChat((ICommandSource)digi.func_70902_q(), digi.func_184753_b(), "\u6402C" + new TranslationTextComponent("evolution6.txt").getString(), new Object[0]);
                return;
            }
            if (currentform.func_74779_i("UltimateForm2").equals(evo)) {
                CommandChatHandler.sendChat((ICommandSource)digi.func_70902_q(), digi.func_184753_b(), "\u6402C" + new TranslationTextComponent("evolution6.txt").getString(), new Object[0]);
                return;
            }
            if (currentform.func_74779_i("UltimateForm3").equals(evo)) {
                CommandChatHandler.sendChat((ICommandSource)digi.func_70902_q(), digi.func_184753_b(), "\u6402C" + new TranslationTextComponent("evolution6.txt").getString(), new Object[0]);
                return;
            }
            if (currentform.func_74779_i("UltimateForm4").equals(evo)) {
                CommandChatHandler.sendChat((ICommandSource)digi.func_70902_q(), digi.func_184753_b(), "\u6402C" + new TranslationTextComponent("evolution6.txt").getString(), new Object[0]);
                return;
            }
            if (!ultimates.func_74764_b(evo)) {
                ultimates.func_218657_a(evo, (INBT)new CompoundNBT());
            }
            championform.func_74778_a("UltimateForm" + (championform.func_186856_d() + 1), evo);
            stack.func_190918_g(1);
            digi.digivolutions.setEmptySlots(digi.digivolutions.getEmptySlots() - 1);
            CommandChatHandler.sendChat((ICommandSource)digi.func_70902_q(), digi.func_184753_b(), "\u6402a" + digi.setup.getTrueName() + " " + new TranslationTextComponent("evolution8.txt").getString(), new Object[0]);
        } else if (form == Form.FormTypes.ULTIMATE && megas.func_186856_d() < digi.digivolutions.getMaxMega()) {
            if (currentform.func_74779_i("MegaForm1").equals(evo)) {
                CommandChatHandler.sendChat((ICommandSource)digi.func_70902_q(), digi.func_184753_b(), "\u6402C" + new TranslationTextComponent("evolution6.txt").getString(), new Object[0]);
                return;
            }
            if (currentform.func_74779_i("MegaForm2").equals(evo)) {
                CommandChatHandler.sendChat((ICommandSource)digi.func_70902_q(), digi.func_184753_b(), "\u6402C" + new TranslationTextComponent("evolution6.txt").getString(), new Object[0]);
                return;
            }
            if (currentform.func_74779_i("MegaForm3").equals(evo)) {
                CommandChatHandler.sendChat((ICommandSource)digi.func_70902_q(), digi.func_184753_b(), "\u6402C" + new TranslationTextComponent("evolution6.txt").getString(), new Object[0]);
                return;
            }
            if (currentform.func_74779_i("MegaForm4").equals(evo)) {
                CommandChatHandler.sendChat((ICommandSource)digi.func_70902_q(), digi.func_184753_b(), "\u6402C" + new TranslationTextComponent("evolution6.txt").getString(), new Object[0]);
                return;
            }
            if (!megas.func_74764_b(evo)) {
                megas.func_218657_a(evo, (INBT)new CompoundNBT());
            }
            ultimateform.func_74778_a("MegaForm" + (ultimateform.func_186856_d() + 1), evo);
            stack.func_190918_g(1);
            digi.digivolutions.setEmptySlots(digi.digivolutions.getEmptySlots() - 1);
            CommandChatHandler.sendChat((ICommandSource)digi.func_70902_q(), digi.func_184753_b(), "\u6402a" + digi.setup.getTrueName() + " " + new TranslationTextComponent("evolution8.txt").getString(), new Object[0]);
        } else {
            CommandChatHandler.sendChat((ICommandSource)digi.func_70902_q(), digi.func_184753_b(), "\u6402C" + new TranslationTextComponent("evolution7.txt").getString(), new Object[0]);
            return;
        }
    }

    public void Age() {
        if (this.stats.getDigimonAgeTimer() <= 24000 && !this.field_70170_p.field_72995_K) {
            this.stats.setDigimonAgeTimer((int)((double)this.stats.getDigimonAgeTimer() + 1.0));
        }
        if (this.stats.getDigimonAgeTimer() >= 24000 && !this.field_70170_p.field_72995_K) {
            this.stats.incrementDigimonAge(1);
            this.stats.setDigimonAgeTimer(0);
        }
    }

    public boolean canDigivolve() {
        return this.stats.getForm() != Form.FormTypes.DIGITALENTITY && this.stats.getForm() != Form.FormTypes.EGG;
    }

    public boolean canModeChange() {
        return Arrays.asList(this.modechanges).contains(this.getInternalDigimonName());
    }

    public boolean canWarpDigivolve() {
        return this.getInternalDigimonName().equals("bulucomon");
    }

    public boolean canDegenerate() {
        return this.stats.getForm() != Form.FormTypes.EGG && this.stats.getForm() != Form.FormTypes.BABY && this.stats.getForm() != Form.FormTypes.DIGITALENTITY;
    }

    public boolean canJogress() {
        return Arrays.asList(this.jogresslist).contains(this.getInternalDigimonName());
    }

    public boolean hasSkin() {
        return Arrays.asList(this.specialskin).contains(this.getInternalDigimonName());
    }

    public boolean isNPC() {
        return this.getNPC().func_74764_b("Job");
    }

    public boolean isQuestGiver() {
        return this.getNPC().func_74764_b("Quest");
    }

    public boolean isAmbientDigital() {
        return this.getInternalDigimonName().equals("evolution");
    }

    protected int func_70693_a(PlayerEntity player) {
        return 1 + this.field_70170_p.field_73012_v.nextInt(3);
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        if (this.func_70909_n()) {
            return false;
        }
        if (this.isNPC()) {
            return false;
        }
        if (this.isNPC() && !((ServerWorld)this.field_70170_p).func_241119_a_(this.func_233580_cy_(), 4)) {
            return true;
        }
        return true;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.15f, 1.0f);
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return null;
    }

    public DigimonEntity(EntityType<? extends TameableEntity> type, World worldIn) {
        super(type, worldIn);
        this.vpetcolor = (short)-1;
        this.setup.initDigimon();
        this.specials.initSpecials();
        this.specials.initSpecialsExtras();
        this.weathercond = SpawnParameters.SpawnParamTypes.valueOf(this.getInternalDigimonName().toUpperCase()).getWeatherType();
        this.timecond = SpawnParameters.SpawnParamTypes.valueOf(this.getInternalDigimonName().toUpperCase()).getTimeType();
        this.moonphasecond = SpawnParameters.SpawnParamTypes.valueOf(this.getInternalDigimonName().toUpperCase()).getMoonType();
        this.levelrange = SpawnParameters.SpawnParamTypes.valueOf(this.getInternalDigimonName().toUpperCase()).getRange();
        this.createSize();
        this.createMutations();
        this.createInventory();
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    public int func_70641_bl() {
        return 1;
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return true;
    }

    public static boolean canSpawn(EntityType<? extends DigimonEntity> animal, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        BlockState blockstate = worldIn.func_180495_p(pos.func_177977_b());
        return true;
    }

    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity ageable) {
        return null;
    }

    public void tameDigimon(PlayerEntity player) {
        this.func_193101_c(player);
        this.field_70699_by.func_75499_g();
        this.func_70624_b(null);
        this.func_233687_w_(true);
        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
        if (player instanceof ServerPlayerEntity) {
            CriteriaTriggers.field_193136_w.func_193178_a((ServerPlayerEntity)player, (AnimalEntity)this);
        }
    }

    public void chanceToTame(int rarity, PlayerEntity entity) {
        Random rand = new Random();
        if (rand.nextInt(100) <= rarity) {
            this.setup.setCanBeRecruited(true);
            CommandChatHandler.sendChat((ICommandSource)entity, entity.func_110124_au(), this.setup.getName() + " wants to join your team!", new Object[0]);
        }
    }

    public void joinTeam(PlayerEntity player) {
        this.func_193101_c(player);
        this.setTamedPenalties();
        this.func_70691_i(this.func_110138_aP());
        this.stats.setBond(100);
        this.field_70699_by.func_75499_g();
        this.func_70624_b(null);
        this.func_233687_w_(true);
        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
    }

    public void setTamedPenalties() {
        if (this.stats.getForm() == Form.FormTypes.BABY) {
            if (Tools.getRandomNumber(1, 2) == 1) {
                this.getEvolutions().func_74757_a("becomeEgg", false);
                this.getEvolutions().func_74757_a("evolveToRookie", false);
                this.getEvolutions().func_74757_a("evolveToChampion", false);
                this.getEvolutions().func_74757_a("evolveToUltimate", false);
                this.getEvolutions().func_74757_a("evolveToMega", false);
            } else if (Tools.getRandomNumber(1, 5) == 1) {
                this.getEvolutions().func_74757_a("becomeEgg", false);
                this.getEvolutions().func_74757_a("evolveToChampion", false);
                this.getEvolutions().func_74757_a("evolveToUltimate", false);
                this.getEvolutions().func_74757_a("evolveToMega", false);
            } else if (Tools.getRandomNumber(1, 10) == 1) {
                this.getEvolutions().func_74757_a("becomeEgg", false);
                this.getEvolutions().func_74757_a("evolveToUltimate", false);
                this.getEvolutions().func_74757_a("evolveToMega", false);
            } else if (Tools.getRandomNumber(1, 20) == 1) {
                this.getEvolutions().func_74757_a("becomeEgg", false);
                this.getEvolutions().func_74757_a("evolveToMega", false);
            }
            this.getEvolutions().func_74757_a("becomeEgg", false);
        }
        if (this.stats.getForm() == Form.FormTypes.INTRAINING) {
            if (Tools.getRandomNumber(1, 2) == 1) {
                this.getEvolutions().func_74757_a("becomeEgg", false);
                this.getEvolutions().func_74757_a("evolveToChampion", false);
                this.getEvolutions().func_74757_a("evolveToUltimate", false);
                this.getEvolutions().func_74757_a("evolveToMega", false);
            } else if (Tools.getRandomNumber(1, 5) == 1) {
                this.getEvolutions().func_74757_a("becomeEgg", false);
                this.getEvolutions().func_74757_a("evolveToUltimate", false);
                this.getEvolutions().func_74757_a("evolveToMega", false);
            } else if (Tools.getRandomNumber(1, 10) == 1) {
                this.getEvolutions().func_74757_a("becomeEgg", false);
                this.getEvolutions().func_74757_a("evolveToMega", false);
            }
            this.getEvolutions().func_74757_a("becomeEgg", false);
        }
        if (this.stats.getForm() == Form.FormTypes.ROOKIE) {
            if (Tools.getRandomNumber(1, 2) == 1) {
                this.getEvolutions().func_74757_a("becomeEgg", false);
                this.getEvolutions().func_74757_a("evolveToUltimate", false);
                this.getEvolutions().func_74757_a("evolveToMega", false);
            } else if (Tools.getRandomNumber(1, 5) == 1) {
                this.getEvolutions().func_74757_a("becomeEgg", false);
                this.getEvolutions().func_74757_a("evolveToMega", false);
            }
            this.getEvolutions().func_74757_a("becomeEgg", false);
        }
        if (this.stats.getForm() == Form.FormTypes.CHAMPION) {
            if (Tools.getRandomNumber(1, 2) == 1) {
                this.getEvolutions().func_74757_a("becomeEgg", false);
                this.getEvolutions().func_74757_a("evolveToMega", false);
            }
            this.getEvolutions().func_74757_a("becomeEgg", false);
        }
        if (this.stats.getForm() == Form.FormTypes.ULTIMATE) {
            this.getEvolutions().func_74757_a("becomeEgg", false);
        }
        this.getEvolutions().func_74757_a("becomeEgg", false);
    }

    public void removeTamedPenalties() {
        if (this.stats.getBond() >= 100 && this.getEvolutions().func_74764_b("evolveToRookie")) {
            this.getEvolutions().func_82580_o("evolveToRookie");
            CommandChatHandler.sendChat((ICommandSource)this.func_70902_q(), this.func_184753_b(), this.setup.getName() + " has unlocked an evolution!", new Object[0]);
        }
        if (this.stats.getBond() >= 200 && this.getEvolutions().func_74764_b("evolveToChampion")) {
            this.getEvolutions().func_82580_o("evolveToChampion");
            CommandChatHandler.sendChat((ICommandSource)this.func_70902_q(), this.func_184753_b(), this.setup.getName() + " has unlocked an evolution!", new Object[0]);
        }
        if (this.stats.getBond() >= 400 && this.getEvolutions().func_74764_b("evolveToUltimate")) {
            this.getEvolutions().func_82580_o("evolveToUltimate");
            CommandChatHandler.sendChat((ICommandSource)this.func_70902_q(), this.func_184753_b(), this.setup.getName() + " has unlocked an evolution!", new Object[0]);
        }
        if (this.stats.getBond() >= 500 && this.getEvolutions().func_74764_b("evolveToMega")) {
            this.getEvolutions().func_82580_o("evolveToMega");
            CommandChatHandler.sendChat((ICommandSource)this.func_70902_q(), this.func_184753_b(), this.setup.getName() + " has unlocked an evolution!", new Object[0]);
        }
        if (this.stats.getBond() >= 300 && this.getEvolutions().func_74764_b("becomeEgg")) {
            this.getEvolutions().func_82580_o("becomeEgg");
            CommandChatHandler.sendChat((ICommandSource)this.func_70902_q(), this.func_184753_b(), this.setup.getName() + " has unlocked the ability to revert into an egg!", new Object[0]);
        }
    }

    public static ItemStack digimonToVPet(DigimonEntity digimon) {
        ItemStack itemStack = new ItemStack((IItemProvider)ModItems.VPET.get(), 1);
        itemStack.func_77982_d(new CompoundNBT());
        CompoundNBT digidata = new CompoundNBT();
        digimon.func_213281_b(digidata);
        itemStack.func_77978_p().func_218657_a("digimon", (INBT)digidata);
        itemStack.func_77978_p().func_74778_a("name", digimon.func_145748_c_().func_150261_e());
        itemStack.func_77978_p().func_74776_a("health", digimon.func_110143_aJ());
        if (digimon.func_70902_q() != null) {
            itemStack.func_77978_p().func_74778_a("tamer", digimon.func_70902_q().func_200200_C_().getString());
        }
        itemStack.func_77978_p().func_74778_a("uuid", digimon.func_184753_b().toString());
        itemStack.func_77978_p().func_74778_a("mobid", digimon.func_200600_R().getRegistryName().toString());
        itemStack.func_77978_p().func_74777_a("color", digimon.vpetcolor);
        itemStack.func_77978_p().func_74778_a("internalname", digimon.getInternalDigimonName());
        String rank = digimon.stats.getRank() == 0 ? "F" : (digimon.stats.getRank() == 1 ? "E" : (digimon.stats.getRank() == 2 ? "D" : (digimon.stats.getRank() == 3 ? "C" : (digimon.stats.getRank() == 4 ? "\u95c8\ufffd" : (digimon.stats.getRank() == 5 ? "A" : (digimon.stats.getRank() == 6 ? "S" : (digimon.stats.getRank() == 7 ? "SS" : (digimon.stats.getRank() == 8 ? "SSS" : (digimon.stats.getRank() == 9 ? "U" : (digimon.stats.getRank() == 10 ? "UR" : ""))))))))));
        itemStack.func_77978_p().func_74778_a("rank", rank);
        digimon.func_70106_y();
        return itemStack;
    }

    public void createInventory() {
        Inventory inventory = this.inventory;
        this.inventory = new Inventory(11);
        if (inventory != null) {
            inventory.func_110132_b((IInventoryChangedListener)this);
            int i = Math.min(inventory.func_70302_i_(), this.inventory.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = inventory.func_70301_a(j);
                if (itemstack.func_190926_b()) continue;
                this.inventory.func_70299_a(j, itemstack.func_77946_l());
            }
        }
        this.inventory.func_110134_a((IInventoryChangedListener)this);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.func_70089_S() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.itemHandler != null) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            LazyOptional<?> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }

    public void func_76316_a(IInventory p_76316_1_) {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void doPlayerRide(PlayerEntity player) {
        if (!this.field_70170_p.field_72995_K) {
            player.field_70177_z = this.field_70177_z;
            player.field_70125_A = this.field_70125_A;
            player.func_184220_m((Entity)this);
        }
    }

    public boolean func_205710_ba() {
        return this.swims();
    }

    public boolean func_184652_a(PlayerEntity player) {
        return !this.func_70909_n();
    }

    public void func_213352_e(Vector3d dr) {
        if (this.func_184207_aI()) {
            LivingEntity livingentity = (LivingEntity)this.func_184179_bs();
            this.field_70126_B = this.field_70177_z = livingentity.field_70177_z;
            this.field_70125_A = livingentity.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            float strafe = livingentity.field_70702_br * 0.5f;
            float forwards = livingentity.field_191988_bg;
            if (forwards <= 0.0f) {
                forwards *= 0.25f;
            }
            if (!this.field_70122_E && this.jumpPower == 0.0f) {
                strafe = 0.0f;
                forwards = 0.0f;
            }
            if (this.jumpPower > 0.0f && !this.field_70703_bu && this.field_70122_E) {
                double jumpStrength = 1.7;
                double preBoostJump = 1.7 * (double)this.jumpPower * (double)this.func_226269_ah_();
                double jumpAmount = this.func_70644_a(Effects.field_76430_j) ? preBoostJump + (double)((float)(this.func_70660_b(Effects.field_76430_j).func_76458_c() + 1) * 0.1f) : preBoostJump;
                Vector3d vector3d = this.func_213322_ci();
                this.func_213293_j(vector3d.field_72450_a, jumpAmount, vector3d.field_72449_c);
                this.func_70637_d(true);
                this.field_70160_al = true;
                ForgeHooks.onLivingJump((LivingEntity)this);
                if (forwards > 0.0f) {
                    float sinYaw = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                    float cosYaw = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                    this.func_213317_d(this.func_213322_ci().func_72441_c((double)(-0.4f * sinYaw * this.jumpPower), 0.0, (double)(0.4f * cosYaw * this.jumpPower)));
                }
                this.jumpPower = 0.0f;
            }
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            if (this.func_184186_bw()) {
                float speedFactor = (float)(1.0 + Math.sqrt((float)this.stats.getSpeed() / 20.0f));
                float moveSpeed = (float)(1.0 * this.func_233637_b_(Attributes.field_233821_d_) * (double)speedFactor);
                this.func_70659_e(moveSpeed);
                super.func_213352_e(new Vector3d((double)strafe, dr.field_72448_b, (double)forwards));
            } else if (livingentity instanceof PlayerEntity) {
                this.func_213317_d(Vector3d.field_186680_a);
            }
            if (this.field_70122_E) {
                this.jumpPower = 0.0f;
                this.func_70637_d(false);
            }
            this.func_233629_a_((LivingEntity)this, false);
            return;
        }
        this.field_70747_aH = 0.02f;
        if (this.func_70613_aW() && this.func_70090_H() && this.swims()) {
            this.func_213309_a(this.func_70689_ay(), dr);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.8));
        } else {
            super.func_213352_e(dr);
        }
    }

    public boolean func_184186_bw() {
        if (this.func_184188_bt().isEmpty()) {
            return false;
        }
        return ((Entity)this.func_184188_bt().get(0)).func_110124_au().equals(this.func_184753_b());
    }

    public Entity func_184179_bs() {
        List passengers = this.func_184188_bt();
        if (passengers.isEmpty()) {
            return null;
        }
        return ((Entity)this.func_184188_bt().get(0)).func_110124_au().equals(this.func_184753_b()) ? (Entity)this.func_184188_bt().get(0) : null;
    }

    public double func_70042_X() {
        if (EnumUtils.isValidEnum(Mounts.RidingTypes.class, (String)this.getInternalDigimonName().toUpperCase())) {
            return (double)this.func_213302_cg() * Mounts.RidingTypes.valueOf(this.getInternalDigimonName().toUpperCase()).getOffSet();
        }
        return (double)this.func_213302_cg() * 0.75;
    }

    public void doSpecial(int slot) {
        if (!this.field_70170_p.field_72995_K) {
            SpecialsList.SpecialTypes specials = null;
            if (slot == 0) {
                specials = SpecialsList.SpecialTypes.valueOf(this.setup.getSignature().toUpperCase());
            }
            if (slot == 1) {
                specials = SpecialsList.SpecialTypes.valueOf(this.setup.getSpecial1().toUpperCase());
            }
            if (slot == 2) {
                specials = SpecialsList.SpecialTypes.valueOf(this.setup.getSpecial2().toUpperCase());
            }
            DigimonEntity digimonEntity = (DigimonEntity)this.field_70170_p.func_73045_a(this.getEnemyInfo());
            int basedamage = this.getMDMG() + this.getV(slot) + this.getdInt(digimonEntity) * this.getM(slot);
            float amount = Math.round((double)((float)basedamage + (float)basedamage * this.getElementAdvantage(slot, digimonEntity)) * this.getResistance(this, (LivingEntity)digimonEntity));
            if (this.stats.getEnergy() >= specials.getEGCost() || !this.func_70909_n()) {
                this.setAttackType(2);
                this.setWorldText(specials.func_176610_l() + "!");
                if (!this.func_70909_n() && slot != 0) {
                    this.getDigimon().func_74778_a("usedspecial", specials.name().toLowerCase());
                }
                if (digimonEntity.func_110143_aJ() <= amount) {
                    digimonEntity.func_70606_j(1.0f);
                } else {
                    digimonEntity.func_70606_j(digimonEntity.func_110143_aJ() - amount);
                }
                digimonEntity.func_70624_b((LivingEntity)this);
                digimonEntity.setEnemyInfo(this.func_145782_y());
                this.func_184185_a(SoundEvents.field_187539_bB, 0.5f, 0.5f);
                if (this.func_70909_n()) {
                    this.stats.incrementEnergy(-specials.getEGCost());
                    this.stats.updateStats();
                    this.abilitycooldown = this.stats.getSpecialDelay();
                }
            } else if (this.func_70902_q() != null) {
                CommandChatHandler.sendChat((ICommandSource)this.func_70902_q(), this.func_184753_b(), "Not enough energy!", new Object[0]);
            }
        }
    }

    public void resisted(int r, DigimonEntity digimon, LivingEntity enemy) {
        if (!this.field_70170_p.field_72995_K) {
            if (r == 1) {
                if (digimon.func_70902_q() != null) {
                    CommandChatHandler.sendChat((ICommandSource)digimon.func_70902_q(), digimon.func_184753_b(), "\u6402C" + digimon.setup.getTrueName() + "'s move was partially resisted!", new Object[0]);
                }
                if (((TameableEntity)enemy).func_70902_q() != null) {
                    CommandChatHandler.sendChat((ICommandSource)((TameableEntity)enemy).func_70902_q(), ((TameableEntity)enemy).func_184753_b(), "\u6402C" + ((DigimonEntity)enemy).setup.getTrueName() + " partially resisted the move!", new Object[0]);
                }
            }
            if (r == 2) {
                if (digimon.func_70902_q() != null) {
                    CommandChatHandler.sendChat((ICommandSource)digimon.func_70902_q(), digimon.func_184753_b(), "\u6402C" + digimon.setup.getTrueName() + "'s move was resisted!", new Object[0]);
                }
                if (((TameableEntity)enemy).func_70902_q() != null) {
                    CommandChatHandler.sendChat((ICommandSource)((TameableEntity)enemy).func_70902_q(), ((TameableEntity)enemy).func_184753_b(), "\u6402C" + ((DigimonEntity)enemy).setup.getTrueName() + " resisted the move!", new Object[0]);
                }
            }
            if (r == 3) {
                if (digimon.func_70902_q() != null) {
                    CommandChatHandler.sendChat((ICommandSource)digimon.func_70902_q(), digimon.func_184753_b(), "\u6402C" + digimon.setup.getTrueName() + "'s move was mostly resisted!", new Object[0]);
                }
                if (((TameableEntity)enemy).func_70902_q() != null) {
                    CommandChatHandler.sendChat((ICommandSource)((TameableEntity)enemy).func_70902_q(), ((TameableEntity)enemy).func_184753_b(), "\u6402C" + ((DigimonEntity)enemy).setup.getTrueName() + " resisted most of the move!", new Object[0]);
                }
            }
        }
    }

    public double getResistance(DigimonEntity digimon, LivingEntity enemy) {
        if (Tools.getRandomNumber(1, 100) > digimon.getMagicHitRate(digimon, enemy)) {
            this.resisted(1, digimon, enemy);
            return 0.5;
        }
        if (Tools.getRandomNumber(1, 100) > digimon.getMagicHitRate(digimon, enemy)) {
            this.resisted(2, digimon, enemy);
            return 0.25;
        }
        if (Tools.getRandomNumber(1, 100) > digimon.getMagicHitRate(digimon, enemy)) {
            this.resisted(3, digimon, enemy);
            return 0.125;
        }
        return 1.0;
    }

    public int getMagicHitRate(DigimonEntity digimon, LivingEntity enemy) {
        int dmacc = digimon.getMagicAccuracy(digimon, enemy) - ((DigimonEntity)enemy).getMagicEvasion();
        if (dmacc < 0) {
            return (int)Math.min(95.0, 50.0 + Math.floor(dmacc / 2));
        }
        if (dmacc > 0) {
            return Math.min(95, 50 + dmacc);
        }
        return 0;
    }

    public int getMagicAccuracy(DigimonEntity digimon, LivingEntity enemy) {
        int skillbefore50 = this.stats.getLevel() * 3;
        int skillafter50 = Math.max(0, (this.stats.getLevel() - 50) * 5);
        int skill = skillbefore50 + skillafter50;
        double dstat = this.getDSTAT(digimon, enemy);
        return (int)((double)skill + dstat);
    }

    public double getDSTAT(DigimonEntity digimon, LivingEntity enemy) {
        int difference = digimon.stats.getSpecialAttack() - ((DigimonEntity)enemy).stats.getSpecialDefense();
        if (difference <= 10) {
            return digimon.stats.getSpecialAttack();
        }
        if (difference == 0) {
            return (double)digimon.stats.getSpecialAttack() * 0.75;
        }
        if (difference <= 30) {
            return (double)digimon.stats.getSpecialAttack() * 0.5;
        }
        if (difference > 30) {
            return (double)digimon.stats.getSpecialAttack() * 0.25;
        }
        if (difference > 70) {
            return 0.0;
        }
        return 0.0;
    }

    public int getMagicEvasion() {
        return this.stats.getLevel() * 4;
    }

    public float getElementAdvantage(int slot, DigimonEntity enemy) {
        SpecialsList.SpecialTypes specials = null;
        if (slot == 0) {
            specials = SpecialsList.SpecialTypes.valueOf(this.setup.getSignature().toUpperCase());
        }
        if (slot == 1) {
            specials = SpecialsList.SpecialTypes.valueOf(this.setup.getSpecial1().toUpperCase());
        }
        if (slot == 2) {
            specials = SpecialsList.SpecialTypes.valueOf(this.setup.getSpecial2().toUpperCase());
        }
        if (specials != null) {
            if (specials.getElement() == AEF.AefTypes.FIRE && enemy.stats.getElement() == AEF.AefTypes.ICE) {
                return 0.5f;
            }
            if (specials.getElement() == AEF.AefTypes.THUNDER && enemy.stats.getElement() == AEF.AefTypes.WATER) {
                return 0.5f;
            }
            if (specials.getElement() == AEF.AefTypes.ICE && enemy.stats.getElement() == AEF.AefTypes.WIND) {
                return 0.5f;
            }
            if (specials.getElement() == AEF.AefTypes.WIND && enemy.stats.getElement() == AEF.AefTypes.WOOD) {
                return 0.5f;
            }
            if (specials.getElement() == AEF.AefTypes.STEEL && enemy.stats.getElement() == AEF.AefTypes.EARTH) {
                return 0.5f;
            }
            if (specials.getElement() == AEF.AefTypes.EARTH && enemy.stats.getElement() == AEF.AefTypes.THUNDER) {
                return 0.5f;
            }
            if (specials.getElement() == AEF.AefTypes.WOOD && enemy.stats.getElement() == AEF.AefTypes.STEEL) {
                return 0.5f;
            }
            if (specials.getElement() == AEF.AefTypes.WATER && enemy.stats.getElement() == AEF.AefTypes.FIRE) {
                return 0.5f;
            }
            if (specials.getElement() == AEF.AefTypes.LIGHT && enemy.stats.getElement() == AEF.AefTypes.DARKNESS) {
                return 0.5f;
            }
            if (specials.getElement() == AEF.AefTypes.DARKNESS && enemy.stats.getElement() == AEF.AefTypes.LIGHT) {
                return 0.5f;
            }
            if (specials.getElement() == AEF.AefTypes.FIRE && enemy.stats.getElement() == AEF.AefTypes.WATER) {
                return -0.5f;
            }
            if (specials.getElement() == AEF.AefTypes.THUNDER && enemy.stats.getElement() == AEF.AefTypes.EARTH) {
                return -0.5f;
            }
            if (specials.getElement() == AEF.AefTypes.ICE && enemy.stats.getElement() == AEF.AefTypes.FIRE) {
                return -0.5f;
            }
            if (specials.getElement() == AEF.AefTypes.WIND && enemy.stats.getElement() == AEF.AefTypes.ICE) {
                return -0.5f;
            }
            if (specials.getElement() == AEF.AefTypes.STEEL && enemy.stats.getElement() == AEF.AefTypes.WOOD) {
                return -0.5f;
            }
            if (specials.getElement() == AEF.AefTypes.EARTH && enemy.stats.getElement() == AEF.AefTypes.STEEL) {
                return -0.5f;
            }
            if (specials.getElement() == AEF.AefTypes.WOOD && enemy.stats.getElement() == AEF.AefTypes.WIND) {
                return -0.5f;
            }
            if (specials.getElement() == AEF.AefTypes.WATER && enemy.stats.getElement() == AEF.AefTypes.THUNDER) {
                return -0.5f;
            }
            return 0.0f;
        }
        return 0.0f;
    }

    public int getMDMG() {
        return 0;
    }

    public int getV(int slot) {
        if (slot == 0) {
            if (this.stats.getSpecialAttack() <= 49) {
                return SpecialsList.SpecialTypes.valueOf(this.setup.getSignature().toUpperCase()).DInt();
            }
            if (this.stats.getSpecialAttack() >= 50 && this.stats.getSpecialAttack() <= 99) {
                return SpecialsList.SpecialTypes.valueOf(this.setup.getSignature().toUpperCase()).DInt2();
            }
            if (this.stats.getSpecialAttack() >= 100 && this.stats.getSpecialAttack() <= 199) {
                return SpecialsList.SpecialTypes.valueOf(this.setup.getSignature().toUpperCase()).DInt3();
            }
            if (this.stats.getSpecialAttack() >= 200) {
                return SpecialsList.SpecialTypes.valueOf(this.setup.getSignature().toUpperCase()).DInt3();
            }
        }
        if (slot == 1) {
            if (this.stats.getSpecialAttack() <= 49) {
                return SpecialsList.SpecialTypes.valueOf(this.setup.getSpecial1().toUpperCase()).DInt();
            }
            if (this.stats.getSpecialAttack() >= 50 && this.stats.getSpecialAttack() <= 99) {
                return SpecialsList.SpecialTypes.valueOf(this.setup.getSpecial1().toUpperCase()).DInt2();
            }
            if (this.stats.getSpecialAttack() >= 100 && this.stats.getSpecialAttack() <= 199) {
                return SpecialsList.SpecialTypes.valueOf(this.setup.getSpecial1().toUpperCase()).DInt3();
            }
            if (this.stats.getSpecialAttack() >= 200) {
                return SpecialsList.SpecialTypes.valueOf(this.setup.getSpecial1().toUpperCase()).DInt3();
            }
        }
        if (slot == 2) {
            if (this.stats.getSpecialAttack() <= 49) {
                return SpecialsList.SpecialTypes.valueOf(this.setup.getSpecial2().toUpperCase()).DInt();
            }
            if (this.stats.getSpecialAttack() >= 50 && this.stats.getSpecialAttack() <= 99) {
                return SpecialsList.SpecialTypes.valueOf(this.setup.getSpecial2().toUpperCase()).DInt2();
            }
            if (this.stats.getSpecialAttack() >= 100 && this.stats.getSpecialAttack() <= 199) {
                return SpecialsList.SpecialTypes.valueOf(this.setup.getSpecial2().toUpperCase()).DInt3();
            }
            if (this.stats.getSpecialAttack() >= 200) {
                return SpecialsList.SpecialTypes.valueOf(this.setup.getSpecial2().toUpperCase()).DInt3();
            }
        }
        return 0;
    }

    public int getdInt(DigimonEntity enemy) {
        if (enemy != null) {
            return this.stats.getSpecialAttack() - enemy.stats.getSpecialDefense();
        }
        return 10;
    }

    public void func_110206_u(int jumpPowerIn) {
        if (jumpPowerIn < 0) {
            jumpPowerIn = 0;
        }
        this.jumpPower = jumpPowerIn >= 90 ? 1.0f : 1.4f + 0.4f * (float)jumpPowerIn / 90.0f;
    }

    public int getM(int slot) {
        if (slot == 0) {
            if (this.stats.getSpecialAttack() <= 49) {
                return SpecialsList.SpecialTypes.valueOf(this.setup.getSignature().toUpperCase()).DIntM();
            }
            if (this.stats.getSpecialAttack() >= 50 && this.stats.getSpecialAttack() <= 99) {
                return SpecialsList.SpecialTypes.valueOf(this.setup.getSignature().toUpperCase()).DInt2M();
            }
            if (this.stats.getSpecialAttack() >= 100 && this.stats.getSpecialAttack() <= 199) {
                return SpecialsList.SpecialTypes.valueOf(this.setup.getSignature().toUpperCase()).DInt3M();
            }
            if (this.stats.getSpecialAttack() >= 200) {
                return SpecialsList.SpecialTypes.valueOf(this.setup.getSignature().toUpperCase()).DInt3M();
            }
        }
        if (slot == 1) {
            if (this.stats.getSpecialAttack() <= 49) {
                return SpecialsList.SpecialTypes.valueOf(this.setup.getSpecial1().toUpperCase()).DIntM();
            }
            if (this.stats.getSpecialAttack() >= 50 && this.stats.getSpecialAttack() <= 99) {
                return SpecialsList.SpecialTypes.valueOf(this.setup.getSpecial1().toUpperCase()).DInt2M();
            }
            if (this.stats.getSpecialAttack() >= 100 && this.stats.getSpecialAttack() <= 199) {
                return SpecialsList.SpecialTypes.valueOf(this.setup.getSpecial1().toUpperCase()).DInt3M();
            }
            if (this.stats.getSpecialAttack() >= 200) {
                return SpecialsList.SpecialTypes.valueOf(this.setup.getSpecial1().toUpperCase()).DInt3M();
            }
        }
        if (slot == 2) {
            if (this.stats.getSpecialAttack() <= 49) {
                return SpecialsList.SpecialTypes.valueOf(this.setup.getSpecial2().toUpperCase()).DIntM();
            }
            if (this.stats.getSpecialAttack() >= 50 && this.stats.getSpecialAttack() <= 99) {
                return SpecialsList.SpecialTypes.valueOf(this.setup.getSpecial2().toUpperCase()).DInt2M();
            }
            if (this.stats.getSpecialAttack() >= 100 && this.stats.getSpecialAttack() <= 199) {
                return SpecialsList.SpecialTypes.valueOf(this.setup.getSpecial2().toUpperCase()).DInt3M();
            }
            if (this.stats.getSpecialAttack() >= 200) {
                return SpecialsList.SpecialTypes.valueOf(this.setup.getSpecial2().toUpperCase()).DInt3M();
            }
        }
        return 0;
    }

    public void npcify() {
        if (!(this.setup.getDigimonTexture().equals("spiralred") || this.setup.getDigimonTexture().equals("spiralblue") || this.setup.getDigimonTexture().equals("spiralgreen") || this.setup.getDigimonTexture().equals("spiralpurple") || this.setup.getDigimonTexture().equals("spiralyellow"))) {
            this.npcsetup.initNPC();
        }
    }

    public EntityConfig getConfiguration() {
        return DigimobsConfig.ServerConfig.AGUMON;
    }

    public void setInteracting(boolean interact) {
        this.field_70180_af.func_187227_b(INTERACTING, (Object)interact);
    }

    public boolean isInteracting() {
        return (Boolean)this.field_70180_af.func_187225_a(INTERACTING);
    }

    public void setWorldText(String type) {
        this.field_70180_af.func_187227_b(WORLDTEXT, (Object)type);
    }

    public String getWorldText() {
        return (String)this.field_70180_af.func_187225_a(WORLDTEXT);
    }

    public void setAttackType(int type) {
        this.field_70180_af.func_187227_b(ATTACKTYPE, (Object)type);
    }

    public int getAttackType() {
        return (Integer)this.field_70180_af.func_187225_a(ATTACKTYPE);
    }

    public void setEnemyInfo(int info) {
        this.field_70180_af.func_187227_b(ENEMYINFO, (Object)info);
    }

    public int getEnemyInfo() {
        return (Integer)this.field_70180_af.func_187225_a(ENEMYINFO);
    }

    public CompoundNBT getDigimon() {
        return (CompoundNBT)this.field_70180_af.func_187225_a(DIGIMON);
    }

    public void setDigimon(CompoundNBT tag) {
        this.field_70180_af.func_187227_b(DIGIMON, (Object)tag);
    }

    public CompoundNBT getStats() {
        return (CompoundNBT)this.field_70180_af.func_187225_a(STATS);
    }

    public void setStats(CompoundNBT tag) {
        this.field_70180_af.func_187227_b(STATS, (Object)tag);
    }

    public CompoundNBT getEvolutions() {
        return (CompoundNBT)this.field_70180_af.func_187225_a(EVOLUTIONS);
    }

    public void setEvolutions(CompoundNBT tag) {
        this.field_70180_af.func_187227_b(EVOLUTIONS, (Object)tag);
    }

    public CompoundNBT getSpecials() {
        return (CompoundNBT)this.field_70180_af.func_187225_a(SPECIALS);
    }

    public void setSpecials(CompoundNBT tag) {
        this.field_70180_af.func_187227_b(SPECIALS, (Object)tag);
    }

    public CompoundNBT getNPC() {
        return (CompoundNBT)this.field_70180_af.func_187225_a(NPCINFO);
    }

    public void setNPC(CompoundNBT tag) {
        this.field_70180_af.func_187227_b(NPCINFO, (Object)tag);
    }

    public void setMovementControl(MovementController control) {
        this.field_70765_h = control;
    }

    public void setNavigator(PathNavigator nav) {
        this.field_70699_by = nav;
    }

    public String getInternalDigimonName() {
        String name = this.func_200600_R().toString();
        return name.replaceAll("entity.digimobs.", "");
    }

    public void createSize() {
        if (this.field_70170_p.field_73012_v.nextInt(50) == 1) {
            this.setup.setScale("Large");
        } else if (this.field_70170_p.field_73012_v.nextInt(250) == 1) {
            this.setup.setScale("Huge");
        } else if (this.field_70170_p.field_73012_v.nextInt(500) == 1) {
            this.setup.setScale("Massive");
        } else if (this.field_70170_p.field_73012_v.nextInt(50) == 1) {
            this.setup.setScale("Small");
        } else if (this.field_70170_p.field_73012_v.nextInt(250) == 1) {
            this.setup.setScale("Tiny");
        } else if (this.field_70170_p.field_73012_v.nextInt(500) == 1) {
            this.setup.setScale("Micro");
        } else {
            this.setup.setScale("Normal");
        }
    }

    public void createPassives() {
        if (this.field_70170_p.field_73012_v.nextInt(1000) == 1) {
            this.setup.setPassive("Vampiric");
        } else if (this.field_70170_p.field_73012_v.nextInt(1000) == 1) {
            this.setup.setPassive("Siphonic");
        } else if (this.field_70170_p.field_73012_v.nextInt(1000) == 1) {
            this.setup.setPassive("Revitalize");
        } else if (this.field_70170_p.field_73012_v.nextInt(1000) == 1) {
            this.setup.setPassive("Recharge");
        } else if (this.field_70170_p.field_73012_v.nextInt(800) == 1) {
            this.setup.setPassive("Nestbound");
        } else if (this.field_70170_p.field_73012_v.nextInt(800) == 1) {
            this.setup.setPassive("Glutton");
        } else if (this.field_70170_p.field_73012_v.nextInt(1000) == 1) {
            this.setup.setPassive("Scrappy");
        } else if (this.field_70170_p.field_73012_v.nextInt(800) == 1) {
            this.setup.setPassive("Gourmand");
        } else if (this.field_70170_p.field_73012_v.nextInt(800) == 1) {
            this.setup.setPassive("Caretaker");
        } else if (this.field_70170_p.field_73012_v.nextInt(1200) == 1) {
            this.setup.setPassive("Haste");
        } else if (this.field_70170_p.field_73012_v.nextInt(800) == 1) {
            this.setup.setPassive("Icarus");
        } else if (this.field_70170_p.field_73012_v.nextInt(500) == 1) {
            this.setup.setPassive("Aeronautic");
        } else if (this.field_70170_p.field_73012_v.nextInt(500) == 1) {
            this.setup.setPassive("Subnautic");
        } else {
            this.setup.setPassive("None");
        }
    }

    public void createMutations() {
        int chinesenewyear;
        int thanksgiving = Tools.isThanksgiving() ? 500 : 0;
        int christmas = Tools.isChristmas() ? 500 : 0;
        int n = chinesenewyear = Tools.isChineseNewYear() ? 500 : 0;
        if (this.field_70170_p.field_73012_v.nextInt(1000 - thanksgiving - christmas - chinesenewyear) == 1) {
            this.setup.setColor("Red");
        } else if (this.field_70170_p.field_73012_v.nextInt(1000) == 1) {
            this.setup.setColor("Blue");
        } else if (this.field_70170_p.field_73012_v.nextInt(1000 - christmas) == 1) {
            this.setup.setColor("Green");
        } else if (this.field_70170_p.field_73012_v.nextInt(1000 - thanksgiving - chinesenewyear) == 1) {
            this.setup.setColor("Yellow");
        } else if (this.field_70170_p.field_73012_v.nextInt(5000) == 1) {
            this.setup.setColor("Pink");
        } else if (this.field_70170_p.field_73012_v.nextInt(1000) == 1) {
            this.setup.setColor("Magenta");
        } else if (this.field_70170_p.field_73012_v.nextInt(5000) == 1) {
            this.setup.setColor("Lime");
        } else if (this.field_70170_p.field_73012_v.nextInt(5000) == 1) {
            this.setup.setColor("Gray");
        } else if (this.field_70170_p.field_73012_v.nextInt(5000) == 1) {
            this.setup.setColor("Silver");
        } else if (this.field_70170_p.field_73012_v.nextInt(5000 - thanksgiving) == 1) {
            this.setup.setColor("Brown");
        } else if (this.field_70170_p.field_73012_v.nextInt(1000) == 1) {
            this.setup.setColor("Cyan");
        } else if (this.field_70170_p.field_73012_v.nextInt(5000) == 1) {
            this.setup.setColor("LightBlue");
        } else if (this.field_70170_p.field_73012_v.nextInt(2000) == 1) {
            this.setup.setColor("Black");
        } else if (this.field_70170_p.field_73012_v.nextInt(7000) == 1) {
            this.setup.setColor("Ruby");
        } else if (this.field_70170_p.field_73012_v.nextInt(7000) == 1) {
            this.setup.setColor("Sapphire");
        } else if (this.field_70170_p.field_73012_v.nextInt(7000) == 1) {
            this.setup.setColor("Emerald");
        } else if (this.field_70170_p.field_73012_v.nextInt(7000) == 1) {
            this.setup.setColor("Amethyst");
        } else if (this.field_70170_p.field_73012_v.nextInt(7000) == 1) {
            this.setup.setColor("Topaz");
        } else if (this.field_70170_p.field_73012_v.nextInt(7000) == 1) {
            this.setup.setColor("Peridot");
        } else if (this.field_70170_p.field_73012_v.nextInt(5000) == 1) {
            this.setup.setColor("Periwinkle");
        } else if (this.field_70170_p.field_73012_v.nextInt(5000 - thanksgiving) == 1) {
            this.setup.setColor("Raspberry");
        } else if (this.field_70170_p.field_73012_v.nextInt(5000) == 1) {
            this.setup.setColor("Olive");
        } else if (this.field_70170_p.field_73012_v.nextInt(5000) == 1) {
            this.setup.setColor("CyberGrape");
        } else if (this.field_70170_p.field_73012_v.nextInt(5000) == 1) {
            this.setup.setColor("BloodOrange");
        } else if (this.field_70170_p.field_73012_v.nextInt(5000) == 1) {
            this.setup.setColor("Cherry");
        } else if (this.field_70170_p.field_73012_v.nextInt(5000) == 1) {
            this.setup.setColor("Marmalade");
        } else if (this.field_70170_p.field_73012_v.nextInt(5000) == 1) {
            this.setup.setColor("Apricot");
        } else if (this.field_70170_p.field_73012_v.nextInt(5000) == 1) {
            this.setup.setColor("ElectricBlue");
        } else if (this.field_70170_p.field_73012_v.nextInt(5000) == 1) {
            this.setup.setColor("Lavender");
        } else if (this.field_70170_p.field_73012_v.nextInt(5000) == 1) {
            this.setup.setColor("Purple");
        } else if (this.field_70170_p.field_73012_v.nextInt(9999) == 1) {
            this.setup.setColor("Rainbow");
        } else if (this.field_70170_p.field_73012_v.nextInt(8192) == 1) {
            this.setup.setColor("Anomaly");
        } else {
            this.setup.setColor("Normal");
        }
    }

    public void spiralize() {
        if (!this.isNPC()) {
            this.setup.setFavoriteFood(this.setup.favoritefood.length - 1);
            if (Tools.getRandomNumber(1, 10) == 1) {
                this.setup.setDigimonTexture("spiralred");
                this.setup.setNickname("\u94fb\u70d8\u68c6-10" + Tools.getRandomNumber(10, 99) + "\u74a7\ufffd");
            } else if (Tools.getRandomNumber(1, 10) == 2) {
                this.setup.setDigimonTexture("spiralyellow");
                this.setup.setNickname("\u94fb\u70d8\u68c6-40" + Tools.getRandomNumber(10, 99) + "\u699b\ufffd");
            } else if (Tools.getRandomNumber(1, 10) == 3) {
                this.setup.setDigimonTexture("spiralgreen");
                this.setup.setNickname("\u94fb\u70d8\u68c6-50" + Tools.getRandomNumber(10, 99) + "\u947b\ufffd");
            } else if (Tools.getRandomNumber(1, 10) == 4) {
                this.setup.setDigimonTexture("spiralpurple");
                this.setup.setNickname("\u94fb\u70d8\u68c6-30" + Tools.getRandomNumber(10, 99) + "\u59d8\ufffd");
            } else {
                this.setup.setDigimonTexture("spiralblue");
                this.setup.setNickname("\u94fb\u70d8\u68c6-20" + Tools.getRandomNumber(10, 99) + "\u95c8\ufffd");
            }
        }
    }

    public boolean isSpiral() {
        if (this.setup.getDigimonTexture().equals("spiralred")) {
            return true;
        }
        if (this.setup.getDigimonTexture().equals("spiralblue")) {
            return true;
        }
        if (this.setup.getDigimonTexture().equals("spiralgreen")) {
            return true;
        }
        if (this.setup.getDigimonTexture().equals("spiralyellow")) {
            return true;
        }
        return this.setup.getDigimonTexture().equals("spiralpurple");
    }

    public void checkLifeDrain(DigimonEntity theattacker, double physicaldmg) {
        if (Tools.getRandomNumber(1, 100) <= 25) {
            if (theattacker.setup.getPassive().equals("Vampiric")) {
                theattacker.func_70691_i((float)Math.round(physicaldmg * 0.3) + 1.0f);
            }
            if (theattacker.setup.getPassive().equals("Siphonic")) {
                theattacker.stats.setEnergy((int)((long)theattacker.stats.getEnergy() + Math.round(physicaldmg * 0.3) + 1L));
            }
        }
    }

    public void checkForSkins() {
        if (Tools.getRandomNumber(1, 100) <= 25 && Tools.isChineseNewYear() && Arrays.asList(this.chinesenewyear).contains(this.getInternalDigimonName())) {
            this.setup.setSpecialTexture("rabbit");
        }
        if (Tools.getRandomNumber(1, 100) <= 50 && Tools.isPokemonDay() && Arrays.asList(this.pokemonskin).contains(this.getInternalDigimonName())) {
            this.setup.setSpecialTexture("pokemon");
        }
    }

    public boolean flys() {
        return FieldGuide.DigimonTypes.flyingmobs.contains(this.getInternalDigimonName()) && !this.isNPC();
    }

    public boolean swims() {
        return FieldGuide.DigimonTypes.watermobs.contains(this.getInternalDigimonName()) && !this.isNPC();
    }

    public boolean floats() {
        return FieldGuide.DigimonTypes.floatingmobs.contains(this.getInternalDigimonName()) && !this.isNPC();
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.stats.getForm() != Form.FormTypes.DIGITALENTITY) {
            if (this.getDigimon().func_74764_b("digivolvingstart")) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("digivolveto", Boolean.valueOf(false)));
                return PlayState.CONTINUE;
            }
            if (this.getDigimon().func_74764_b("digivolvingfinish")) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("digivolvefrom", Boolean.valueOf(false)));
                return PlayState.CONTINUE;
            }
            if (this.getAttackType() == 1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("attack", Boolean.valueOf(true)));
                return PlayState.CONTINUE;
            }
            if (this.getAttackType() == 2) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("ranged", Boolean.valueOf(true)));
                return PlayState.CONTINUE;
            }
            if (!this.func_233570_aj_() && !this.func_70090_H() && this.func_70638_az() == null || (double)this.field_70143_R > 1.0) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("flying", Boolean.valueOf(true)));
                return PlayState.CONTINUE;
            }
            if (this.func_70090_H()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("swimming", Boolean.valueOf(true)));
                return PlayState.CONTINUE;
            }
            if (this.func_233684_eK_()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("sitting", Boolean.valueOf(true)));
                return PlayState.CONTINUE;
            }
            if (this.isInteracting()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("interaction", Boolean.valueOf(true)));
                return PlayState.CONTINUE;
            }
            if (event.getLimbSwingAmount() <= -0.15f || event.getLimbSwingAmount() >= 0.15f) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("walking", Boolean.valueOf(true)));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public boolean func_184776_b() {
        return true;
    }

    public void func_184775_b(int p_184775_1_) {
    }

    public void func_184777_r_() {
    }
}

