/*
 * Decompiled with CFR 0.152.
 */
package mod.cyan.digimobs.entities.ai;

import java.util.EnumSet;
import mod.cyan.digimobs.entities.DigimonEntity;
import net.minecraft.block.BlockState;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.gen.Heightmap;

public class DigimonFlyingGoal
extends Goal {
    DigimonEntity digimon;
    boolean wantsToFly = true;
    int actionTicks = -1;
    BlockPos target = null;
    float lastYaw;
    BlockPos.Mutable reusablePos = new BlockPos.Mutable(0, 0, 0);

    public DigimonFlyingGoal(DigimonEntity digimon) {
        this.digimon = digimon;
    }

    public void startExecuting() {
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        BlockPos pos = this.digimon.func_130014_f_().func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, this.digimon.func_233580_cy_());
        if (this.digimon.func_233580_cy_().func_177956_o() - pos.func_177956_o() > 10) {
            this.wantsToFly = true;
            this.actionTicks = 1;
            this.func_75250_a();
        }
    }

    public boolean func_75250_a() {
        if (this.digimon.func_233684_eK_()) {
            return false;
        }
        if (this.digimon.func_70638_az() != null) {
            return false;
        }
        --this.actionTicks;
        if (this.wantsToFly) {
            if (this.target == null && this.actionTicks <= 0) {
                this.findAerialTarget();
                if (this.target != null) {
                    this.actionTicks = (int)(2400.0 * ((double)this.digimon.func_70681_au().nextFloat() - 0.5) / 5.0);
                    this.moveToTarget();
                }
            } else if (this.target != null) {
                this.moveToTarget();
            }
            if (this.reachedTarget()) {
                this.findAerialTarget();
                if (this.target != null) {
                    this.moveToTarget();
                }
                return true;
            }
            if (this.actionTicks <= 0) {
                this.target = this.findLanding();
                if (this.target != null) {
                    this.wantsToFly = false;
                    this.actionTicks = 800;
                    this.moveToTarget();
                }
            }
        } else {
            if (this.target != null && this.target.func_177951_i((Vector3i)this.digimon.func_233580_cy_()) > 4.0) {
                this.moveToTarget();
            }
            if (this.actionTicks <= 0) {
                this.wantsToFly = true;
                this.findAerialTarget();
            }
        }
        return false;
    }

    private double findAngle(double x, double z) {
        if (x >= 0.0 && z >= 0.0) {
            return MathHelper.func_181159_b((double)x, (double)z);
        }
        if (x <= 0.0 && z >= 0.0) {
            return Math.PI - MathHelper.func_181159_b((double)x, (double)z);
        }
        if (x <= 0.0 && z <= 0.0) {
            return Math.PI + MathHelper.func_181159_b((double)x, (double)z);
        }
        if (x >= 0.0 && z <= 0.0) {
            return Math.PI * 2 - MathHelper.func_181159_b((double)x, (double)z);
        }
        return 0.0;
    }

    public void moveToTarget() {
        double diffX = (double)this.target.func_177958_n() - this.digimon.func_213303_ch().field_72450_a;
        double diffZ = (double)this.target.func_177952_p() - this.digimon.func_213303_ch().field_72449_c;
        double angleDiff = this.findAngle(diffX, diffZ);
        double angleCurrent = this.findAngle(this.digimon.func_213322_ci().field_72450_a, this.digimon.func_213322_ci().field_72449_c);
        double theta = angleDiff - angleCurrent;
        if (angleDiff - angleCurrent > 180.0) {
            theta = -1.0 * (360.0 - theta);
        }
        if (Math.abs(theta) > 0.05235987755982988) {
            theta = 0.05235987755982988;
        }
        double motionMagnitude = Math.sqrt(Math.pow(this.digimon.func_213322_ci().field_72450_a, 2.0) + Math.pow(this.digimon.func_213322_ci().field_72449_c, 2.0));
        double diffMagnitude = Math.sqrt(Math.pow(diffX, 2.0) + Math.pow(diffZ, 2.0));
        if (this.digimon.func_213322_ci().field_72450_a == 0.0 && this.digimon.func_213322_ci().field_72449_c == 0.0) {
            this.digimon.func_213293_j(-0.01, this.digimon.func_213322_ci().field_72448_b, -0.01);
        }
        if ((motionMagnitude += 0.1) > 0.25) {
            motionMagnitude = 0.25;
        }
        double desiredMotionX = Math.cos(theta) * this.digimon.func_213322_ci().field_72450_a - Math.sin(theta) * this.digimon.func_213322_ci().field_72449_c;
        double desiredMotionZ = Math.sin(theta) * this.digimon.func_213322_ci().field_72450_a + Math.cos(theta) * this.digimon.func_213322_ci().field_72449_c;
        double newMotionSpeed = Math.sqrt(Math.pow(desiredMotionX, 2.0) + Math.pow(desiredMotionZ, 2.0));
        double ratio = newMotionSpeed / motionMagnitude;
        double yDist = (double)this.target.func_177956_o() - this.digimon.func_213303_ch().field_72448_b;
        this.digimon.func_213293_j(desiredMotionX /= ratio, yDist / diffMagnitude, desiredMotionZ /= ratio);
        float yaw = (float)Math.atan2(-this.digimon.func_213322_ci().field_72450_a, this.digimon.func_213322_ci().field_72449_c);
        this.digimon.field_70177_z = (float)((double)(yaw * 180.0f) / Math.PI);
    }

    public boolean reachedTarget() {
        double dist;
        return this.target != null && (dist = Math.sqrt(Math.pow(this.digimon.func_213303_ch().field_72450_a - (double)this.target.func_177958_n(), 2.0) + Math.pow(this.digimon.func_213303_ch().field_72449_c - (double)this.target.func_177952_p(), 2.0))) <= 3.0;
    }

    public boolean findAerialTarget() {
        double baseDir = (double)this.digimon.field_70177_z + (this.digimon.func_70681_au().nextDouble() - 0.5) * 60.0;
        for (int i = 0; i < 3; ++i) {
            int radius = this.digimon.func_70681_au().nextInt(30) + 50;
            double direction = baseDir + (double)(i * 60);
            int x = (int)((double)radius * Math.cos(direction * Math.PI / 180.0));
            int z = (int)((double)radius * Math.sin(direction * Math.PI / 180.0));
            this.reusablePos.func_189533_g((Vector3i)this.digimon.func_130014_f_().func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, (BlockPos)this.reusablePos.func_181079_c(x, 1, z)));
            if (this.reusablePos.func_177956_o() <= 0 || this.reusablePos.func_177956_o() > 230) continue;
            this.target = this.reusablePos.func_177982_a(0, 20, 0).func_185334_h();
            return true;
        }
        return false;
    }

    public BlockPos findLanding() {
        this.reusablePos.func_189533_g((Vector3i)this.digimon.func_130014_f_().func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, this.digimon.func_233580_cy_()));
        if (this.reusablePos.func_177956_o() > 0) {
            BlockPos pos = this.reusablePos.func_177973_b(new Vector3i(0, 1, 0));
            BlockState blockState = this.digimon.func_130014_f_().func_180495_p(pos);
            if (blockState.func_200132_m() && blockState.func_215686_e((IBlockReader)this.digimon.func_130014_f_(), pos)) {
                return this.reusablePos.func_185334_h();
            }
        }
        return null;
    }
}

