/*
 * Decompiled with CFR 0.152.
 */
package mod.cyan.digimobs.entities.ai;

import java.util.EnumSet;
import java.util.Random;
import mod.cyan.digimobs.entities.DigimonEntity;
import mod.cyan.digimobs.entities.setup.FieldGuide;
import mod.cyan.digimobs.util.Vector3;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;

public class DigimonIdleGoal
extends Goal {
    public static int IDLETIMER = 1;
    final DigimonEntity entry;
    private double x;
    private double y;
    private double z;
    Vector3 v = Vector3.getNewVector();
    Vector3 v1 = Vector3.getNewVector();

    public static Vector3 getRandomPointNear(IBlockReader world, DigimonEntity mob, Vector3 v, int distance) {
        Random rand = new Random();
        double x = rand.nextGaussian() * (double)distance;
        double z = rand.nextGaussian() * (double)distance;
        if (Math.abs(x) > (double)distance) {
            x = Math.signum(x) * (double)distance;
        }
        if (Math.abs(z) > (double)distance) {
            z = Math.signum(z) * (double)distance;
        }
        double y = Math.min(Math.max(1.0, rand.nextGaussian() * 4.0), 2.0);
        v.addTo(x, y, z);
        ServerChunkProvider serverChunkProvider = ((ServerWorld)world).func_72863_F();
        if (!serverChunkProvider.func_212864_k_().isAreaLoaded(v.getPos(), 8)) {
            return null;
        }
        if (v.isClearOfBlocks(world)) {
            return v;
        }
        return null;
    }

    public DigimonIdleGoal(DigimonEntity digimon) {
        this.entry = digimon;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    private void doFloatingIdle() {
        this.v.set(this.x, this.y, this.z);
        Vector3 temp = Vector3.getNextSurfacePoint((IBlockReader)this.entry.field_70170_p, this.v, Vector3.secondAxisNeg, this.v.y);
        if (temp == null) {
            return;
        }
        this.y = temp.y + 1.5;
    }

    private void doFlyingIdle() {
        double diff;
        PlayerEntity player;
        boolean up;
        boolean tamed = this.entry.func_70909_n() && !this.entry.func_233684_eK_();
        boolean bl = up = Math.random() < 0.9;
        if (!tamed || up) {
            this.doGroundIdle();
        }
        if ((player = this.entry.field_70170_p.func_217362_a((Entity)this.entry, 32.0)) != null && (diff = Math.abs(player.func_226278_cu_() - this.y)) > 5.0) {
            this.y = player.func_226278_cu_() + 5.0 * (1.0 - Math.random());
        }
    }

    private void doGroundIdle() {
        this.v.set(this.x, this.y, this.z);
        this.v.set(Vector3.getNextSurfacePoint((IBlockReader)this.entry.field_70170_p, this.v, Vector3.secondAxisNeg, this.v.y));
        if (this.v != null) {
            this.y = this.v.y;
        }
    }

    public void doStationaryIdle() {
        this.x = this.entry.func_226277_ct_();
        this.y = this.entry.func_226278_cu_();
        this.z = this.entry.func_226281_cx_();
    }

    public void doWaterIdle() {
        this.v.set(this.x, this.y, this.z);
        if (this.entry.field_70170_p.func_204610_c(this.v.getPos()).func_206884_a((ITag)FluidTags.field_206959_a)) {
            this.x = this.entry.func_226277_ct_();
            this.y = this.entry.func_226278_cu_();
            this.z = this.entry.func_226281_cx_();
        }
    }

    private boolean getLocation() {
        boolean tameFactor = this.entry.func_70909_n() && !this.entry.func_233684_eK_();
        int distance = tameFactor ? 4 : 16;
        boolean goHome = false;
        if (!tameFactor) {
            if (this.entry.setup.getBasePos() == null || this.entry.setup.getBasePos().func_177958_n() == 0 && this.entry.setup.getBasePos().func_177956_o() == 0 && this.entry.setup.getBasePos().func_177952_p() == 0) {
                this.v1.set((Object)this.entry);
                this.entry.setup.setBasePos(this.v1.intX(), this.v1.intY(), this.v1.intZ());
            }
            distance = Math.min(distance, 16);
            this.v.set(this.entry.setup.getBasePos());
            if (this.entry.func_233580_cy_().func_177951_i((Vector3i)this.entry.setup.getBasePos()) > 256.0) {
                goHome = true;
            }
        } else {
            LivingEntity livingEntity = null;
            DigimonEntity digimonEntity = this.entry;
            if (this.entry.func_70902_q() != null) {
                livingEntity = this.entry.func_70902_q();
            }
            this.v.set(livingEntity);
        }
        if (goHome) {
            this.x = this.v.x;
            this.y = Math.round(this.v.y);
            this.z = this.v.z;
        } else {
            Vector3 v = DigimonIdleGoal.getRandomPointNear((IBlockReader)this.entry.field_70170_p, this.entry, this.v, distance);
            if (v == null) {
                return false;
            }
            double diff = Math.max(FieldGuide.DigimonTypes.valueOf(this.entry.getInternalDigimonName().toUpperCase()).getWidth() * FieldGuide.DigimonTypes.valueOf(this.entry.getInternalDigimonName().toUpperCase()).getScale(), FieldGuide.DigimonTypes.valueOf(this.entry.getInternalDigimonName().toUpperCase()).getWidth() * FieldGuide.DigimonTypes.valueOf(this.entry.getInternalDigimonName().toUpperCase()).getScale());
            diff = Math.max(2.0, diff);
            if (this.v1.distToSq(v) < diff) {
                return false;
            }
            this.x = v.x;
            this.y = Math.round(v.y);
            this.z = v.z;
        }
        return true;
    }

    public void run() {
        if (!this.getLocation()) {
            return;
        }
        if (this.entry.flys()) {
            this.doFlyingIdle();
        } else if (this.entry.floats()) {
            this.doFloatingIdle();
        } else if (this.entry.swims() && this.entry.func_70090_H()) {
            this.doWaterIdle();
        } else {
            this.doGroundIdle();
        }
        this.v1.set((Object)this.entry);
        this.v.set(this.x, this.y, this.z);
        if (this.v1.distToSq(this.v) <= 1.0) {
            return;
        }
        this.entry.func_70661_as().func_75492_a(this.v.x, this.v.y, this.v.z, (double)0.7f);
    }

    public void func_75251_c() {
        super.func_75251_c();
    }

    public void func_75249_e() {
        this.run();
    }

    public boolean func_75253_b() {
        return !this.entry.func_70661_as().func_75500_f();
    }

    public boolean func_75250_a() {
        if (IDLETIMER <= 0) {
            return false;
        }
        if (this.entry.func_233684_eK_()) {
            return false;
        }
        if (this.entry.func_70681_au().nextInt(IDLETIMER) != 0) {
            return false;
        }
        if (this.entry.func_70638_az() != null) {
            return false;
        }
        return !this.entry.func_184207_aI();
    }
}

