/*
 * Decompiled with CFR 0.152.
 */
package mod.cyan.digimobs.entities.ai;

import mod.cyan.digimobs.entities.DigimonEntity;
import mod.cyan.digimobs.entities.ai.WorldHelper;
import mod.cyan.digimobs.util.Tools;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;

public class DigimonSwimmingGoal
extends Goal {
    private DigimonEntity pixelmon;
    private float swimSpeed = 1.5f;
    private float decayRate = 0.99f;
    private int depthRangeStart = 50;
    private int depthRangeEnd = 75;
    private float moveSpeed;
    private int ticksToRefresh;
    private double delta = 0.0;
    private boolean shouldSink = false;
    boolean lastChangeDirection;
    boolean useLastChangeDirection;

    public DigimonSwimmingGoal(DigimonEntity entity) {
        this.pixelmon = entity;
    }

    public boolean func_75250_a() {
        return this.pixelmon.func_70090_H();
    }

    public void func_75246_d() {
        if (this.shouldSink || this.depthRangeStart == -1) {
            this.pixelmon.func_213317_d(new Vector3d(0.0, -0.01, 0.0));
            return;
        }
        boolean useLastChangeDirection = false;
        BlockRayTraceResult blockRayTraceResult = this.pixelmon.field_70170_p.func_217299_a(new RayTraceContext(new Vector3d(this.pixelmon.func_226277_ct_(), this.pixelmon.func_174813_aQ().field_72338_b, this.pixelmon.func_226281_cx_()), new Vector3d(this.pixelmon.func_226277_ct_() + this.pixelmon.func_213322_ci().func_82615_a() * 100.0, this.pixelmon.func_174813_aQ().field_72338_b, this.pixelmon.func_226281_cx_() + this.pixelmon.func_213322_ci().func_82616_c() * 100.0), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this.pixelmon));
        if (blockRayTraceResult.func_216346_c() == RayTraceResult.Type.MISS) {
            blockRayTraceResult = this.pixelmon.field_70170_p.func_217299_a(new RayTraceContext(new Vector3d(this.pixelmon.func_226277_ct_(), this.pixelmon.func_174813_aQ().field_72337_e, this.pixelmon.func_226281_cx_()), new Vector3d(this.pixelmon.func_226277_ct_() + this.pixelmon.func_213322_ci().field_72450_a * 100.0, this.pixelmon.func_174813_aQ().field_72337_e, this.pixelmon.func_226281_cx_() + this.pixelmon.func_213322_ci().field_72449_c * 100.0), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this.pixelmon));
        }
        if (blockRayTraceResult.func_216346_c() != RayTraceResult.Type.MISS) {
            useLastChangeDirection = true;
        }
        --this.ticksToRefresh;
        if (this.moveSpeed == 0.0f || useLastChangeDirection || this.pixelmon.func_213322_ci().field_72450_a * this.pixelmon.func_213322_ci().field_72450_a + this.pixelmon.func_213322_ci().field_72449_c * this.pixelmon.func_213322_ci().field_72449_c < (double)(this.moveSpeed / 4.0f)) {
            this.pickDirection(useLastChangeDirection);
            this.pickSpeed();
            this.pixelmon.func_213352_e(new Vector3d(0.0, 0.0, (double)this.moveSpeed));
        }
    }

    public boolean shouldContinueExecuting() {
        this.moveSpeed *= this.decayRate;
        this.pixelmon.func_213293_j(this.pixelmon.func_213322_ci().field_72450_a * (double)this.decayRate, this.pixelmon.func_213322_ci().field_72448_b * (double)this.decayRate, this.pixelmon.func_213322_ci().field_72449_c * (double)this.decayRate);
        this.pixelmon.field_70761_aq = this.pixelmon.field_70177_z;
        return true;
    }

    public void pickDirection(boolean useLastChangeDirection) {
        double rotAmt;
        if (useLastChangeDirection) {
            rotAmt = this.pixelmon.func_70681_au().nextInt(5) + 5;
            if (this.lastChangeDirection) {
                rotAmt *= -1.0;
            }
        } else {
            rotAmt = this.pixelmon.func_70681_au().nextInt(10) - 5;
            this.lastChangeDirection = rotAmt > 0.0;
        }
        DigimonEntity pixelmon = this.pixelmon;
        pixelmon.field_70177_z += (float)rotAmt;
    }

    public void pickSpeed() {
        if (this.ticksToRefresh < 0) {
            this.ticksToRefresh = 160;
        }
        this.moveSpeed = 2.8f * (this.pixelmon.func_70681_au().nextFloat() * this.swimSpeed + this.swimSpeed / 2.0f);
        double refreshRate = 160.0;
        if (refreshRate == 0.0) {
            refreshRate = 1.0;
        }
        double v = Tools.getRandomNumber(5, 10);
        int wdepth = WorldHelper.getWaterDepth(this.pixelmon.func_233580_cy_(), this.pixelmon.field_70170_p);
        this.pixelmon.func_213317_d(new Vector3d(this.pixelmon.func_213322_ci().field_72450_a, ((double)wdepth - v) / refreshRate, this.pixelmon.func_213322_ci().field_72449_c));
    }
}

