/*
 * Decompiled with CFR 0.152.
 */
package mod.cyan.digimobs.entities.ai;

import mod.cyan.digimobs.entities.DigimonEntity;
import mod.cyan.digimobs.entities.ai.ClimbPathNavi;
import mod.cyan.digimobs.entities.ai.FlyPathNavi;
import mod.cyan.digimobs.entities.ai.LogicBase;
import mod.cyan.digimobs.entities.ai.SwimPathNavi;
import mod.cyan.digimobs.entities.ai.WalkPathNavi;
import mod.cyan.digimobs.util.Vector3;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class LogicFloatFlySwim
extends LogicBase {
    NaviState state = null;
    Vector3 here = Vector3.getNewVector();
    private final FlyingPathNavigator flyPather;
    private final WalkPathNavi walkPather;
    private final ClimbPathNavi climbPather;
    private final SwimPathNavi swimPather;
    private final MovementController flyController;
    private final MovementController walkController;
    private final MovementController swimController;
    Vector3 lastPos = Vector3.getNewVector();
    int time_at_pos = 0;

    public LogicFloatFlySwim(DigimonEntity entity) {
        super(entity);
        this.flyPather = new FlyPathNavi((MobEntity)entity, entity.func_130014_f_());
        this.walkPather = new WalkPathNavi((MobEntity)entity, entity.func_130014_f_());
        this.climbPather = new ClimbPathNavi((MobEntity)entity, entity.func_130014_f_());
        this.swimPather = new SwimPathNavi((MobEntity)entity, entity.func_130014_f_());
        this.flyPather.func_192879_a(false);
        this.flyPather.func_212239_d(true);
        this.flyPather.func_192878_b(true);
        this.swimPather.func_179688_b(false);
        this.swimPather.func_212239_d(true);
        this.walkPather.func_179688_b(false);
        this.walkPather.func_212239_d(true);
        this.flyController = new FlyController(entity);
        this.walkController = new WalkController(entity);
        this.swimController = new SwimController(entity);
        this.world = this.entity.func_130014_f_();
    }

    @Override
    public void tick(World world) {
        boolean water;
        super.tick(world);
        Path path = this.entity.func_70661_as().func_75505_d();
        if (path != null && !path.func_75879_b()) {
            BlockPos next = path.func_242948_g();
            Vector3 hereVec = Vector3.getNewVector().set((Object)this.entity);
            Vector3 nextVec = Vector3.getNewVector().set(next);
            if (hereVec.distToSq(this.lastPos) < 1.0) {
                ++this.time_at_pos;
                if (this.time_at_pos > 100) {
                    double dr = nextVec.distanceTo(hereVec);
                    if (dr < 3.0) {
                        nextVec.moveEntity((Entity)this.entity);
                    } else {
                        this.entity.func_70661_as().func_75499_g();
                    }
                    this.time_at_pos = 0;
                }
            } else {
                this.lastPos.set((Object)this.entity);
                this.time_at_pos = 0;
            }
            if (nextVec.distToSq(hereVec) < 1.0 && path.func_75873_e() + 1 < path.func_75874_d()) {
                path.func_75872_c(path.func_75873_e() + 1);
            }
        }
        PathNavigator oldNavi = this.entity.func_70661_as();
        boolean air = this.entity.floats() || this.entity.flys() || this.entity.setup.getPassive().equals("Aeronautic") && this.entity.func_70638_az() != null;
        boolean bl = water = this.entity.getEntity().func_70090_H() && this.entity.swims() || this.entity.getEntity().func_70090_H() && this.entity.setup.getPassive().equals("Subnautic") && this.entity.func_70638_az() != null;
        if (air && this.entity.func_70089_S()) {
            if (this.state != NaviState.FLY) {
                this.entity.func_189654_d(!this.entity.func_233684_eK_());
                this.entity.setNavigator((PathNavigator)this.flyPather);
                this.entity.setMovementControl(this.flyController);
            }
            this.state = NaviState.FLY;
        } else if (water && this.entity.func_70089_S()) {
            if (this.state != NaviState.SWIM) {
                this.entity.setNavigator((PathNavigator)this.swimPather);
                this.entity.setMovementControl(this.swimController);
            }
            this.state = NaviState.SWIM;
        } else {
            if (this.state != NaviState.WALK) {
                this.entity.func_189654_d(false);
                this.entity.setNavigator((PathNavigator)this.climbPather);
                this.entity.setMovementControl(this.walkController);
            }
            this.state = NaviState.WALK;
        }
    }

    private static enum NaviState {
        FLY,
        SWIM,
        WALK;

    }

    public static class FlyController
    extends FlyingMovementController {
        final DigimonEntity digimon;

        public FlyController(DigimonEntity mob) {
            super((MobEntity)mob, 20, true);
            this.digimon = mob;
        }

        public double func_75638_b() {
            return super.func_75638_b() * 1.25;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                this.field_188491_h = MovementController.Action.WAIT;
                this.field_75648_a.func_189654_d(true);
                double dx = this.field_75646_b - this.field_75648_a.func_226277_ct_();
                double dy = this.field_75647_c - this.field_75648_a.func_226278_cu_();
                double dz = this.field_75644_d - this.field_75648_a.func_226281_cx_();
                double ds2 = dx * dx + dy * dy + dz * dz;
                if (ds2 < (double)0.01f) {
                    this.field_75648_a.func_70657_f(0.0f);
                    this.field_75648_a.func_191989_p(0.0f);
                    return;
                }
                float dh = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
                float ds = MathHelper.func_76133_a((double)ds2);
                float f = (float)(MathHelper.func_181159_b((double)dz, (double)dx) * 57.2957763671875) - 90.0f;
                this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, f, 10.0f);
                float angleDiff = this.field_75648_a.field_70177_z - f;
                float dot = MathHelper.func_76134_b((float)(angleDiff /= 57.295776f));
                float f1 = (float)(this.func_75638_b() / 2.0);
                this.field_75648_a.func_70659_e(f1 * dot);
                this.field_75648_a.field_70747_aH = (float)((double)f1 * 0.05);
                float f2 = (float)(-(MathHelper.func_181159_b((double)dy, (double)dh) * 57.2957763671875));
                this.field_75648_a.field_70125_A = this.func_75639_a(this.field_75648_a.field_70125_A, f2, 10.0f);
                f1 = (float)((double)f1 * Math.abs(dy / (double)ds));
                if (dy < 2.0 && dy > 0.0) {
                    f1 = Math.max(f1 * 10.0f, 0.1f);
                }
                this.field_75648_a.func_70657_f(dy > 0.0 ? f1 : -f1);
                float dh_hat = MathHelper.func_76135_e((float)(dh / ds));
                float dy_hat = (float)Math.abs(dy / (double)ds);
                Vector3d v = this.field_75648_a.func_213322_ci();
                this.field_75648_a.func_213293_j(v.field_72450_a * (double)dh_hat * (double)dot, v.field_72448_b * (double)dy_hat * (double)dot, v.field_72449_c * (double)dh_hat * (double)dot);
            } else {
                this.field_75648_a.field_70747_aH = 0.02f;
                this.field_75648_a.func_70657_f(0.0f);
                this.field_75648_a.func_191989_p(0.0f);
            }
        }
    }

    public static class SwimController
    extends MovementController {
        final DigimonEntity digimon;

        public SwimController(DigimonEntity mob) {
            super((MobEntity)mob);
            this.digimon = mob;
        }

        public double func_75638_b() {
            return super.func_75638_b() * 1.25;
        }

        public void func_75641_c() {
            this.field_75648_a.func_189654_d(this.field_75648_a.func_70090_H());
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.field_75648_a.func_70661_as().func_75500_f()) {
                double dz;
                double dy;
                this.field_188491_h = MovementController.Action.WAIT;
                double dx = this.field_75646_b - this.field_75648_a.func_226277_ct_();
                double ds2 = dx * dx + (dy = this.field_75647_c - this.field_75648_a.func_226278_cu_()) * dy + (dz = this.field_75644_d - this.field_75648_a.func_226281_cx_()) * dz;
                if (ds2 < (double)0.01f) {
                    this.field_75648_a.func_70657_f(0.0f);
                    this.field_75648_a.func_191989_p(0.0f);
                    return;
                }
                float dh = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
                float ds = MathHelper.func_76133_a((double)ds2);
                float f = (float)(MathHelper.func_181159_b((double)dz, (double)dx) * 57.2957763671875) - 90.0f;
                this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, f, 10.0f);
                float angleDiff = this.field_75648_a.field_70177_z - f;
                float dot = MathHelper.func_76134_b((float)(angleDiff /= 57.295776f));
                float f1 = (float)(this.func_75638_b() * (double)0.1f);
                this.field_75648_a.func_70659_e(f1 * dot);
                this.field_75648_a.field_70747_aH = (float)((double)f1 * 0.05);
                float f2 = (float)(-(MathHelper.func_181159_b((double)dy, (double)dh) * 57.2957763671875));
                this.field_75648_a.field_70125_A = this.func_75639_a(this.field_75648_a.field_70125_A, f2, 10.0f);
                f1 = (float)((double)f1 * Math.abs(dy / (double)ds));
                if (dy < 2.0 && dy > 0.0) {
                    f1 = Math.max(f1 * 10.0f, 0.1f);
                }
                this.field_75648_a.func_70657_f(dy > 0.0 ? f1 : -f1);
                float dh_hat = MathHelper.func_76135_e((float)(dh / ds));
                float dy_hat = (float)Math.abs(dy / (double)ds);
                Vector3d v = this.field_75648_a.func_213322_ci();
                this.field_75648_a.func_213293_j(v.field_72450_a * (double)dh_hat * (double)dot, v.field_72448_b * (double)dy_hat * (double)dot, v.field_72449_c * (double)dh_hat * (double)dot);
            } else {
                this.field_75648_a.func_70659_e(0.0f);
            }
        }
    }

    public static class WalkController
    extends MovementController {
        public WalkController(DigimonEntity mob) {
            super((MobEntity)mob);
        }

        public double func_75638_b() {
            return super.func_75638_b();
        }

        public void func_75641_c() {
            super.func_75641_c();
        }
    }
}

