/*
 * Decompiled with CFR 0.152.
 */
package mod.cyan.digimobs.entities.ai;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import mod.cyan.digimobs.entities.DigimonEntity;
import mod.cyan.digimobs.entities.ai.LogicBase;
import mod.cyan.digimobs.entities.setup.FieldGuide;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.server.permission.IPermissionHandler;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.context.PlayerContext;

public class LogicMounts
extends LogicBase {
    public static Set<RegistryKey<World>> BLACKLISTED = Sets.newHashSet();
    public boolean leftInputDown = false;
    public boolean rightInputDown = false;
    public boolean forwardInputDown = false;
    public boolean backInputDown = false;
    public boolean upInputDown = false;
    public boolean downInputDown = false;
    public boolean followOwnerLook = false;
    public double throttle = 0.5;
    private boolean input = false;
    private boolean wasRiding = false;
    public boolean canFly;
    public boolean canSurf;
    public boolean canDive;
    public boolean inFluid;

    public LogicMounts(DigimonEntity digimon) {
        super(digimon);
        if (this.entity.getPersistentData().func_74764_b("digimobs:mob_throttle")) {
            this.throttle = this.entity.getPersistentData().func_74769_h("digimobs:mob_throttle");
        }
    }

    public void refreshInput() {
        this.input = this.leftInputDown || this.rightInputDown || this.forwardInputDown || this.backInputDown || this.upInputDown || this.downInputDown;
        Entity rider = this.entity.func_184179_bs();
        ServerPlayerEntity player = null;
        this.inFluid = this.entity.func_70090_H() || this.entity.func_180799_ab();
        this.canFly = this.entity.flys();
        this.canSurf = this.entity.swims();
        this.canDive = this.entity.swims();
        if (rider instanceof ServerPlayerEntity) {
            player = (ServerPlayerEntity)rider;
            IPermissionHandler handler = PermissionAPI.getPermissionHandler();
            PlayerContext context = new PlayerContext((PlayerEntity)player);
            FieldGuide.DigimonTypes digimonTypes = FieldGuide.DigimonTypes.valueOf(this.entity.getInternalDigimonName().toUpperCase());
        }
        if (this.canFly) {
            this.canFly = !BLACKLISTED.contains(rider.func_130014_f_().func_234923_W_());
        }
    }

    public boolean hasInput() {
        return this.input;
    }

    @Override
    public void tick(World world) {
        float moveFwd;
        boolean fluidRestricted;
        Entity rider = this.entity.func_184179_bs();
        this.entity.field_70138_W = 1.1f;
        if (rider == null) {
            if (this.wasRiding && !this.entity.func_233570_aj_()) {
                this.entity.func_189654_d(false);
                this.wasRiding = false;
            }
            return;
        }
        this.wasRiding = true;
        boolean move = false;
        boolean shouldControl = this.entity.func_233570_aj_() || this.entity.flys();
        boolean verticalControl = false;
        boolean waterSpeed = false;
        boolean airSpeed = !this.entity.func_233570_aj_();
        boolean bl = fluidRestricted = this.inFluid && !this.canSurf && !this.canDive;
        if (this.canFly) {
            shouldControl = verticalControl = shouldControl;
            if (verticalControl) {
                this.entity.func_189654_d(true);
            }
        }
        if ((this.canSurf || this.canDive) && (waterSpeed = this.entity.func_70090_H())) {
            shouldControl = verticalControl = shouldControl;
        }
        if (waterSpeed) {
            airSpeed = false;
        }
        Entity controller = rider;
        ItemStack stack = new ItemStack((IItemProvider)Blocks.field_180401_cv);
        ArrayList buffs = Lists.newArrayList();
        if (this.entity.swims()) {
            EffectInstance vision = new EffectInstance(Effects.field_76439_r, 300, 1, true, false);
            EffectInstance breathing = new EffectInstance(Effects.field_76427_o, 300, 1, true, false);
            vision.setCurativeItems((List)Lists.newArrayList());
            breathing.setCurativeItems((List)Lists.newArrayList());
            buffs.add(vision);
            buffs.add(breathing);
        }
        if (this.entity.func_180799_ab() && this.entity.func_230279_az_()) {
            EffectInstance no_burning = new EffectInstance(Effects.field_76426_n, 60, 1, true, false);
            shouldControl = true;
            verticalControl = true;
            no_burning.setCurativeItems((List)Lists.newArrayList());
            buffs.add(no_burning);
        }
        shouldControl = verticalControl || this.inFluid;
        this.entity.func_189654_d(verticalControl);
        for (Entity e : this.entity.func_184188_bt()) {
            boolean doBuffs;
            if (!(e instanceof LivingEntity)) continue;
            boolean bl2 = doBuffs = !buffs.isEmpty();
            if (doBuffs) {
                for (EffectInstance buff : buffs) {
                    ((LivingEntity)e).func_195064_c(buff);
                }
                continue;
            }
            ((LivingEntity)e).curePotionEffects(stack);
        }
        float speedFactor = (float)(1.0 + Math.sqrt(this.entity.stats.getSpeed()) / 5.0);
        float baseSpd = (float)(0.25 * this.throttle * (double)speedFactor);
        float f = moveFwd = this.backInputDown ? -baseSpd / 2.0f : baseSpd;
        float moveUp = this.upInputDown ? baseSpd : (this.downInputDown ? -baseSpd : 0.0f);
        float pitch = controller.field_70125_A;
        System.out.println("working!");
        if (Math.abs(pitch) > 25.0f && this.followOwnerLook) {
            pitch *= (float)(-Math.PI) / 180;
            if (this.backInputDown) {
                pitch *= -1.0f;
            }
            float sin = (float)Math.sin(pitch);
            float cos = (float)Math.cos(pitch);
            moveUp = baseSpd;
            moveFwd *= cos;
            moveUp *= sin;
            if (Math.abs(pitch) > 75.0f) {
                moveFwd = 0.0f;
                moveUp = Math.signum(pitch) * baseSpd;
            }
            if (this.upInputDown) {
                moveUp = Math.abs(moveUp);
            } else if (this.downInputDown) {
                moveUp = -Math.abs(moveUp);
            }
        }
        moveUp = (float)((double)moveUp * 0.25);
        boolean goUp = this.upInputDown || moveUp > 0.0f;
        boolean goDown = this.downInputDown || moveUp < 0.0f;
        double vx = this.entity.func_213322_ci().field_72450_a;
        double vy = this.entity.func_213322_ci().field_72448_b;
        double vz = this.entity.func_213322_ci().field_72449_c;
        if (this.forwardInputDown || this.backInputDown) {
            move = true;
            float f2 = moveFwd;
            f2 = airSpeed ? (f2 *= 1.0f) : (waterSpeed ? (f2 *= 1.0f) : (f2 *= 1.0f));
            if (fluidRestricted) {
                f2 = (float)((double)f2 * 0.1);
            }
            if (shouldControl) {
                vx += (double)(MathHelper.func_76126_a((float)(-this.entity.field_70177_z * ((float)Math.PI / 180))) * f2);
                vz += (double)(MathHelper.func_76134_b((float)(this.entity.field_70177_z * ((float)Math.PI / 180))) * f2);
            }
        }
        if ((goUp || goDown) && verticalControl) {
            vy += (double)moveUp;
            move = true;
        } else if (fluidRestricted) {
            vy += 0.05 * this.throttle;
            move = true;
        } else if (!verticalControl && !this.entity.func_233570_aj_()) {
            vy -= 0.1;
        }
        if (this.inFluid && !this.upInputDown && !this.downInputDown) {
            double threshold;
            double fraction = -1.0;
            if (this.entity.func_70090_H()) {
                fraction = this.entity.func_233571_b_((ITag)FluidTags.field_206959_a);
            }
            if (this.entity.func_180799_ab()) {
                fraction = this.entity.func_233571_b_((ITag)FluidTags.field_206960_b);
            }
            if (fraction > (threshold = this.entity.func_233579_cu_())) {
                vy += 0.05;
            }
        }
        if (!this.entity.func_184188_bt().isEmpty()) {
            float f3 = moveFwd / 2.0f;
            if (this.leftInputDown) {
                move = true;
                if (shouldControl) {
                    f3 = airSpeed ? (f3 *= 1.0f) : (waterSpeed ? (f3 *= 1.0f) : (f3 *= 1.0f));
                    vx += (double)(MathHelper.func_76134_b((float)(-this.entity.field_70177_z * ((float)Math.PI / 180))) * f3);
                    vz += (double)(MathHelper.func_76126_a((float)(this.entity.field_70177_z * ((float)Math.PI / 180))) * f3);
                } else if (this.inFluid) {
                    f3 = (float)((double)f3 * 0.1);
                    vx += (double)(MathHelper.func_76134_b((float)(-this.entity.field_70177_z * ((float)Math.PI / 180))) * f3);
                    vz += (double)(MathHelper.func_76126_a((float)(this.entity.field_70177_z * ((float)Math.PI / 180))) * f3);
                }
            }
            if (this.rightInputDown) {
                move = true;
                if (shouldControl) {
                    f3 = airSpeed ? (f3 *= 1.0f) : (waterSpeed ? (f3 *= 1.0f) : (f3 *= 1.0f));
                    vx -= (double)(MathHelper.func_76134_b((float)(-this.entity.field_70177_z * ((float)Math.PI / 180))) * f3);
                    vz -= (double)(MathHelper.func_76126_a((float)(this.entity.field_70177_z * ((float)Math.PI / 180))) * f3);
                } else if (this.inFluid) {
                    f3 = (float)((double)f3 * 0.1);
                    vx -= (double)(MathHelper.func_76134_b((float)(-this.entity.field_70177_z * ((float)Math.PI / 180))) * f3);
                    vz -= (double)(MathHelper.func_76126_a((float)(this.entity.field_70177_z * ((float)Math.PI / 180))) * f3);
                }
            }
        }
        if (!move) {
            vx *= 0.5;
            vz *= 0.5;
            if (verticalControl) {
                vy *= 0.5;
            }
        }
        this.entity.func_213293_j(vx, vy, vz);
    }
}

