/*
 * Decompiled with CFR 0.152.
 */
package mod.cyan.digimobs.entities.setup;

import java.util.Arrays;
import java.util.List;
import mod.cyan.digimobs.entities.DigimonEntity;
import mod.cyan.digimobs.entities.setup.helpers.AEF;
import mod.cyan.digimobs.entities.setup.helpers.Form;
import mod.cyan.digimobs.entities.setup.helpers.Genetics;
import mod.cyan.digimobs.init.ModItems;
import mod.cyan.digimobs.util.Tools;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.math.BlockPos;

public class DigimonSetup {
    public DigimonEntity digi;
    public Item[] favoritefood = new Item[]{ItemStack.field_190927_a.func_77973_b()};
    public static List<Item> thanksgivingdrops = Arrays.asList((Item)ModItems.MEATSMALL.get(), (Item)ModItems.SUPERCARROT.get(), (Item)ModItems.SUPERVEGGY.get(), (Item)ModItems.ACORN.get(), (Item)ModItems.HAWKRADISH.get(), (Item)ModItems.MUSCLEYAM.get());
    public static List<Item> easterdrops = Arrays.asList((Item)ModItems.BOTAEGGRUST.get(), (Item)ModItems.NYOKIEGGFLORA.get(), (Item)ModItems.YURAEGGNOBLE.get(), (Item)ModItems.PICHIEGGPLESIO.get(), (Item)ModItems.POYOEGGGODDRA.get(), (Item)ModItems.YUKIMIBOTAEGGMOON.get(), (Item)ModItems.METALKOROEGGCRANIA.get(), (Item)ModItems.MOKUEGGSUN.get(), (Item)ModItems.PURURUEGGGRYPHO.get());

    public DigimonSetup(DigimonEntity digimon) {
        this.digi = digimon;
    }

    public void initDigimon() {
        this.setName(this.digi.func_145748_c_().getString());
        this.setNickname("");
        this.setDigimonTexture(this.digi.getInternalDigimonName().toLowerCase());
        this.createFavoriteFood();
        this.setCanBeRecruited(false);
        this.setGenetics();
    }

    public String convertToInternalDigimonName(String name) {
        return name.replaceAll("entity.digimobs.", "").toUpperCase();
    }

    public String getName() {
        return this.digi.getDigimon().func_74779_i("Name");
    }

    public void setName(String name) {
        this.digi.getDigimon().func_74778_a("Name", name);
    }

    public String getTrueName() {
        String name = this.digi.setup.getNickname().equals("") ? this.digi.setup.getName() : this.digi.setup.getNickname();
        return name;
    }

    public String getNickname() {
        return this.digi.getDigimon().func_74779_i("Nickname");
    }

    public void setNickname(String nickname) {
        this.digi.getDigimon().func_74778_a("Nickname", nickname);
    }

    public String getDigimonTexture() {
        return this.digi.getDigimon().func_74779_i("Texture");
    }

    public void setDigimonTexture(String texture) {
        this.digi.getDigimon().func_74778_a("Texture", texture);
    }

    public String getSpecialTexture() {
        return this.digi.getDigimon().func_74779_i("Skin");
    }

    public void setSpecialTexture(String skin) {
        this.digi.getDigimon().func_74778_a("Skin", skin);
    }

    public String getPassive() {
        return this.digi.getDigimon().func_74779_i("Passive");
    }

    public void setPassive(String pass) {
        this.digi.getDigimon().func_74778_a("Passive", pass);
    }

    public String getColor() {
        return this.digi.getDigimon().func_74779_i("Color");
    }

    public void setColor(String color) {
        this.digi.getDigimon().func_74778_a("Color", color);
    }

    public String getScale() {
        return this.digi.getDigimon().func_74779_i("Scale");
    }

    public void setScale(String scale) {
        this.digi.getDigimon().func_74778_a("Scale", scale);
    }

    public String getPersonality() {
        return this.digi.getDigimon().func_74779_i("Personality");
    }

    public void setPersonality(String personality) {
        this.digi.getDigimon().func_74778_a("Personality", personality);
    }

    public int getFavoriteFood() {
        return this.digi.getDigimon().func_74762_e("FavoriteFoodValue");
    }

    public void setFavoriteFood(int food) {
        this.digi.getDigimon().func_74768_a("FavoriteFoodValue", food);
    }

    public boolean canBeRecruited() {
        return this.digi.getDigimon().func_74767_n("CanBeRecruited");
    }

    public void setCanBeRecruited(boolean recruit) {
        this.digi.getDigimon().func_74757_a("CanBeRecruited", recruit);
    }

    public String getSignature() {
        return this.digi.getDigimon().func_74779_i("Signature");
    }

    public void setSignature(String signature) {
        this.digi.getDigimon().func_74778_a("Signature", signature);
    }

    public String getSpecial1() {
        return this.digi.getDigimon().func_74779_i("Special1");
    }

    public void setSpecial1(String special1) {
        this.digi.getDigimon().func_74778_a("Special1", special1);
    }

    public String getSpecial2() {
        return this.digi.getDigimon().func_74779_i("Special2");
    }

    public void setSpecial2(String special2) {
        this.digi.getDigimon().func_74778_a("Special2", special2);
    }

    public double getBaseX() {
        return this.digi.getDigimon().func_74769_h("baseX");
    }

    public void setBaseX(double pos) {
        this.digi.getDigimon().func_74780_a("baseX", pos);
    }

    public double getBaseY() {
        return this.digi.getDigimon().func_74769_h("baseY");
    }

    public void setBaseY(double pos) {
        this.digi.getDigimon().func_74780_a("baseY", pos);
    }

    public double getBaseZ() {
        return this.digi.getDigimon().func_74769_h("baseZ");
    }

    public void setBaseZ(double pos) {
        this.digi.getDigimon().func_74780_a("baseZ", pos);
    }

    public BlockPos getBasePos() {
        return new BlockPos(this.getBaseX(), this.getBaseY(), this.getBaseZ());
    }

    public void setBasePos(int x, int y, int z) {
        this.setBaseX(x);
        this.setBaseY(y);
        this.setBaseZ(z);
    }

    public void setGenetics() {
        if (!(this.digi.stats.getForm() != Form.FormTypes.BABY && this.digi.stats.getForm() != Form.FormTypes.INTRAINING && this.digi.stats.getForm() != Form.FormTypes.ROOKIE || this.digi.getStats().func_74764_b("Genetics"))) {
            this.digi.stats.setGenetics();
        }
        if (Arrays.asList(this.digi.stats.dinotype).contains(this.digi.getInternalDigimonName())) {
            this.digi.stats.setTypeGenetics(Genetics.GeneticTypes.DINO.getAllele());
        }
        if (Arrays.asList(this.digi.stats.beasttype).contains(this.digi.getInternalDigimonName())) {
            this.digi.stats.setTypeGenetics(Genetics.GeneticTypes.BEAST.getAllele());
        }
        if (Arrays.asList(this.digi.stats.aviantype).contains(this.digi.getInternalDigimonName())) {
            this.digi.stats.setTypeGenetics(Genetics.GeneticTypes.AVIAN.getAllele());
        }
        if (Arrays.asList(this.digi.stats.insecttype).contains(this.digi.getInternalDigimonName())) {
            this.digi.stats.setTypeGenetics(Genetics.GeneticTypes.INSECT.getAllele());
        }
        if (Arrays.asList(this.digi.stats.planttype).contains(this.digi.getInternalDigimonName())) {
            this.digi.stats.setTypeGenetics(Genetics.GeneticTypes.PLANT.getAllele());
        }
        if (Arrays.asList(this.digi.stats.aquatictype).contains(this.digi.getInternalDigimonName())) {
            this.digi.stats.setTypeGenetics(Genetics.GeneticTypes.AQUATIC.getAllele());
        }
        if (Arrays.asList(this.digi.stats.holytype).contains(this.digi.getInternalDigimonName())) {
            this.digi.stats.setTypeGenetics(Genetics.GeneticTypes.HOLY.getAllele());
        }
        if (Arrays.asList(this.digi.stats.shadetype).contains(this.digi.getInternalDigimonName())) {
            this.digi.stats.setTypeGenetics(Genetics.GeneticTypes.SHADE.getAllele());
        }
        if (Arrays.asList(this.digi.stats.ghosttype).contains(this.digi.getInternalDigimonName())) {
            this.digi.stats.setTypeGenetics(Genetics.GeneticTypes.GHOST.getAllele());
        }
        if (Arrays.asList(this.digi.stats.machinetype).contains(this.digi.getInternalDigimonName())) {
            this.digi.stats.setTypeGenetics(Genetics.GeneticTypes.MACHINE.getAllele());
        }
        if (Arrays.asList(this.digi.stats.cyborgtype).contains(this.digi.getInternalDigimonName())) {
            this.digi.stats.setTypeGenetics(Genetics.GeneticTypes.CYBORG.getAllele());
        }
        if (Arrays.asList(this.digi.stats.puppettype).contains(this.digi.getInternalDigimonName())) {
            this.digi.stats.setTypeGenetics(Genetics.GeneticTypes.PUPPET.getAllele());
        }
        if (Arrays.asList(this.digi.stats.fairytype).contains(this.digi.getInternalDigimonName())) {
            this.digi.stats.setTypeGenetics(Genetics.GeneticTypes.FAIRY.getAllele());
        }
        if (Arrays.asList(this.digi.stats.dragontype).contains(this.digi.getInternalDigimonName())) {
            this.digi.stats.setTypeGenetics(Genetics.GeneticTypes.DRAGON.getAllele());
        }
        if (Arrays.asList(this.digi.stats.mutanttype).contains(this.digi.getInternalDigimonName())) {
            this.digi.stats.setTypeGenetics(Genetics.GeneticTypes.MUTANT.getAllele());
        }
        if (Arrays.asList(this.digi.stats.unknowntype).contains(this.digi.getInternalDigimonName())) {
            this.digi.stats.setTypeGenetics(Genetics.GeneticTypes.UNKNOWN.getAllele());
        }
        this.digi.stats.setAttributeGenetics(Genetics.GeneticTypes.valueOf(this.digi.stats.getAttribute().toString().toUpperCase()).getAllele());
        String hasColor = this.digi.setup.getColor().isEmpty() ? "WW" : Genetics.GeneticTypes.valueOf(this.digi.setup.getColor().toUpperCase()).getAllele();
        this.digi.stats.setColorGenetics(hasColor);
        String hasSize = this.digi.setup.getScale().isEmpty() ? "WW" : Genetics.GeneticTypes.valueOf(this.digi.setup.getScale().toUpperCase()).getAllele();
        this.digi.stats.setSizeGenetics(hasSize);
        String hasXAntibody = Arrays.asList(this.digi.stats.unknowntype).contains(this.digi.getInternalDigimonName()) ? "xx" : "XX";
        this.digi.stats.setXAntibodyGenetics(hasXAntibody);
    }

    public void createFavoriteFood() {
        if (this.digi.stats.getForm() == Form.FormTypes.BABY) {
            this.favoritefood = new Item[]{Items.field_151015_O, (Item)ModItems.ENERGYPACKET.get(), Items.field_151106_aX, ItemStack.field_190927_a.func_77973_b()};
        }
        if (this.digi.stats.getForm() == Form.FormTypes.INTRAINING) {
            this.favoritefood = new Item[]{Items.field_151083_be, Items.field_151077_bg, Items.field_196104_bb, Items.field_151103_aS, Items.field_151025_P, ItemStack.field_190927_a.func_77973_b()};
        }
        if (this.digi.stats.getForm() == Form.FormTypes.ROOKIE) {
            if (this.digi.stats.getField() == AEF.AefTypes.DRAGONSROAR) {
                this.favoritefood = new Item[]{(Item)ModItems.MEATSMALL.get(), ItemStack.field_190927_a.func_77973_b()};
            }
            if (this.digi.stats.getField() == AEF.AefTypes.NATURESPIRITS) {
                this.favoritefood = new Item[]{(Item)ModItems.GOLDENACORN.get(), (Item)ModItems.SWEETNUT.get(), (Item)ModItems.ACORN.get(), ItemStack.field_190927_a.func_77973_b()};
            }
            if (this.digi.stats.getField() == AEF.AefTypes.WINDGUARDIANS) {
                this.favoritefood = new Item[]{(Item)ModItems.HAWKRADISH.get(), (Item)ModItems.SUPERVEGGY.get(), (Item)ModItems.SUPERCARROT.get(), ItemStack.field_190927_a.func_77973_b()};
            }
            if (this.digi.stats.getField() == AEF.AefTypes.JUNGLETROOPERS) {
                this.favoritefood = new Item[]{(Item)ModItems.ORANGEBANANA.get(), (Item)ModItems.CHAINMELON.get(), (Item)ModItems.CALMBERRY.get(), (Item)ModItems.BLUEAPPLE.get(), (Item)ModItems.BIGBERRY.get(), ItemStack.field_190927_a.func_77973_b()};
            }
            if (this.digi.stats.getField() == AEF.AefTypes.DEEPSAVERS) {
                this.favoritefood = new Item[]{(Item)ModItems.DIGIBLACKTROUT.get(), (Item)ModItems.DIGITROUT.get(), (Item)ModItems.DIGIANCHOVY.get(), ItemStack.field_190927_a.func_77973_b()};
            }
            if (this.digi.stats.getField() == AEF.AefTypes.METALEMPIRE) {
                this.favoritefood = new Item[]{(Item)ModItems.PRICKLYPEAR.get(), (Item)ModItems.MUSCLEYAM.get(), ItemStack.field_190927_a.func_77973_b()};
            }
            if (this.digi.stats.getField() == AEF.AefTypes.VIRUSBUSTERS) {
                this.favoritefood = new Item[]{(Item)ModItems.DIGICORE.get(), ItemStack.field_190927_a.func_77973_b()};
            }
            if (this.digi.stats.getField() == AEF.AefTypes.NIGHTMARESOLDIERS) {
                this.favoritefood = new Item[]{(Item)ModItems.CORRUPTEDCORE.get(), ItemStack.field_190927_a.func_77973_b()};
            }
        }
        if (this.digi.getInternalDigimonName().equals("hiyarimon")) {
            this.favoritefood = new Item[]{Item.func_150898_a((Block)Blocks.field_196604_cC), Item.func_150898_a((Block)Blocks.field_196604_cC), ItemStack.field_190927_a.func_77973_b()};
        }
        if (this.digi.getInternalDigimonName().equals("bulucomon")) {
            this.favoritefood = new Item[]{Item.func_150898_a((Block)Blocks.field_196604_cC), Item.func_150898_a((Block)Blocks.field_196604_cC), ItemStack.field_190927_a.func_77973_b()};
        }
        if (this.digi.getInternalDigimonName().equals("hackmon")) {
            this.favoritefood = new Item[]{ItemStack.field_190927_a.func_77973_b()};
        }
        if (this.digi.getInternalDigimonName().equals("zubamon")) {
            this.favoritefood = new Item[]{ItemStack.field_190927_a.func_77973_b()};
        }
        if (this.digi.getInternalDigimonName().equals("veemons")) {
            this.favoritefood = new Item[]{ItemStack.field_190927_a.func_77973_b()};
        }
        if (this.digi.getInternalDigimonName().equals("gammamon")) {
            this.favoritefood = new Item[]{ItemStack.field_190927_a.func_77973_b()};
        }
        if (this.digi.getInternalDigimonName().equals("vorvomon")) {
            this.favoritefood = new Item[]{ItemStack.field_190927_a.func_77973_b()};
        }
        if (this.digi.getInternalDigimonName().equals("meicoonyaromon")) {
            this.favoritefood = new Item[]{ItemStack.field_190927_a.func_77973_b()};
        }
        if (this.digi.getInternalDigimonName().equals("meicoosalamon")) {
            this.favoritefood = new Item[]{ItemStack.field_190927_a.func_77973_b()};
        }
        if (this.digi.getInternalDigimonName().equals("piedmon") && Tools.isAprilFools()) {
            this.favoritefood = new Item[]{Items.field_151170_bI};
        }
        if (this.digi.isNPC()) {
            this.favoritefood = new Item[]{ItemStack.field_190927_a.func_77973_b()};
        }
        this.setFavoriteFood((int)(Math.random() * (double)(this.favoritefood.length - 0) + 0.0));
    }

    public void createPersonality(int personality) {
        switch (personality) {
            case 0: {
                this.digi.setup.setPersonality("Balanced");
                return;
            }
            case 1: {
                this.digi.setup.setPersonality("Headstrong");
                return;
            }
            case 2: {
                this.digi.setup.setPersonality("Cautious");
                return;
            }
            case 3: {
                this.digi.setup.setPersonality("Agile");
                return;
            }
            case 4: {
                this.digi.setup.setPersonality("Intelligent");
                return;
            }
            case 5: {
                this.digi.setup.setPersonality("Intuitive");
                return;
            }
            case 6: {
                this.digi.setup.setPersonality("Deft");
                return;
            }
        }
        this.digi.setup.setPersonality("Balanced");
    }
}

