/*
 * Decompiled with CFR 0.152.
 */
package mod.cyan.digimobs.entities.setup;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mod.cyan.digimobs.config.DigimobsConfig;
import mod.cyan.digimobs.entities.DigimonEntity;
import mod.cyan.digimobs.entities.setup.helpers.VendorSaleValues;
import mod.cyan.digimobs.util.Tools;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class NPCSetup {
    public DigimonEntity npc;
    public static List<String> foodnpc = Arrays.asList("palmon", "lalamon", "floramon", "penguinmon", "togemon", "vegiemon", "lilymon", "rosemon");
    public static List<String> npcvendorlistmid = Arrays.asList("toyagumon", "hagurumon", "tentomon", "candlemon", "hackmon");
    public static List<String> plainsnpcmid = Arrays.asList("agumon", "biyomon", "lalamon", "floramon");
    public static List<String> snowynpcmid = Arrays.asList("gabumon", "bearmon", "penguinmon");
    public static List<String> hotnpcmid = Arrays.asList("armadillomon", "agumon", "palmon");
    public static List<String> npcvendorlistmidhigh = Arrays.asList("deputymon", "guardromon", "kabuterimon", "greymon", "garurumon", "birdramon", "togemon", "ankylomon", "grizzmon", "meramon", "vegiemon");
    public static List<String> npcvendorlisthigh = Arrays.asList("andromon", "megakabuterimonred", "metalgreymon", "weregarurumon", "garudamon", "lilymon", "skullmeramon");
    public static List<String> veryhighnpclist = Arrays.asList("wargreymon", "metalgarurumon", "hiandromon", "rosemon");
    public static List<String> veryhighquestnpc = Arrays.asList("gankoomon");
    public List<String> weaponvendor = Arrays.asList("noviceblade", "bronzeblade", "silverblade", "goldblade", "crystalsword", "doubleaxe", "shamanspear", "auxdagger", "scalescimitar", "titaniumsaber", "shademace", "broadrapier", "leafdagger", "chickendagger", "lumberaxe", "ankh");
    public List<String> armorvendor = Arrays.asList("crystalguard", "doubleplate", "shamanhelm", "auxhelm", "scaleshield", "titaniumshield", "shadehelm", "broadshield");
    public List<String> foodvendor = Arrays.asList("acorn", "bigberry", "blueapple", "supercarrot", "superveggy", "sweetnut", "calmberry", "chainmelon", "digianchovy", "digiblacktrout", "digitrout", "goldenacorn", "hawkradish", "meatsmall", "muscleyam", "orangebanana", "pricklypear", "redberry");

    public NPCSetup(DigimonEntity digimonEntity) {
        this.npc = digimonEntity;
    }

    public void initNPC() {
        this.setJob(this.initJobs());
    }

    public String initJobs() {
        int job = Tools.getRandomNumber(1, 100);
        if (this.npc.getInternalDigimonName().equals("gankoomon")) {
            // empty if block
        }
        if (this.npc.getInternalDigimonName().equals("hackmon")) {
            if (Tools.getRandomNumber(1, 100) <= 98) {
                this.npc.func_70106_y();
            }
            return "Traveler";
        }
        if (Tools.isBetween(job, 1, 10)) {
            this.initShop(DigimobsConfig.ServerConfig.VENDORSHOPS.spawnBiomes);
            return "Vendor";
        }
        if (Tools.isBetween(job, 11, 20)) {
            this.initShop(this.weaponvendor);
            return "Weapon Vendor";
        }
        if (Tools.isBetween(job, 21, 30)) {
            this.initShop(this.armorvendor);
            return "Armor Vendor";
        }
        if (Tools.isBetween(job, 31, 40) && foodnpc.contains(this.npc.getInternalDigimonName())) {
            this.initShop(this.foodvendor);
            return "Food Vendor";
        }
        return "Traveler";
    }

    public void initShop(List<? extends String> spawnBiomes) {
        if (this.npc.inventory.func_191420_l()) {
            Collections.shuffle(spawnBiomes);
            this.npc.inventory.func_70299_a(0, new ItemStack((IItemProvider)VendorSaleValues.VendorTypes.valueOf(spawnBiomes.get(0).toUpperCase()).getItem()));
            this.npc.inventory.func_70299_a(1, new ItemStack((IItemProvider)VendorSaleValues.VendorTypes.valueOf(spawnBiomes.get(1).toUpperCase()).getItem()));
            this.npc.inventory.func_70299_a(2, new ItemStack((IItemProvider)VendorSaleValues.VendorTypes.valueOf(spawnBiomes.get(2).toUpperCase()).getItem()));
            this.npc.inventory.func_70299_a(3, new ItemStack((IItemProvider)VendorSaleValues.VendorTypes.valueOf(spawnBiomes.get(3).toUpperCase()).getItem()));
            this.npc.inventory.func_70299_a(4, new ItemStack((IItemProvider)VendorSaleValues.VendorTypes.valueOf(spawnBiomes.get(4).toUpperCase()).getItem()));
            this.npc.inventory.func_70299_a(5, new ItemStack((IItemProvider)VendorSaleValues.VendorTypes.valueOf(spawnBiomes.get(5).toUpperCase()).getItem()));
            this.npc.inventory.func_70299_a(6, new ItemStack((IItemProvider)VendorSaleValues.VendorTypes.valueOf(spawnBiomes.get(6).toUpperCase()).getItem()));
            this.npc.inventory.func_70299_a(7, new ItemStack((IItemProvider)VendorSaleValues.VendorTypes.valueOf(spawnBiomes.get(7).toUpperCase()).getItem()));
        }
    }

    public void refreshShop(List<? extends String> spawnBiomes) {
        Collections.shuffle(spawnBiomes);
        this.npc.inventory.func_70299_a(0, new ItemStack((IItemProvider)VendorSaleValues.VendorTypes.valueOf(spawnBiomes.get(0).toUpperCase()).getItem()));
        this.npc.inventory.func_70299_a(1, new ItemStack((IItemProvider)VendorSaleValues.VendorTypes.valueOf(spawnBiomes.get(1).toUpperCase()).getItem()));
        this.npc.inventory.func_70299_a(2, new ItemStack((IItemProvider)VendorSaleValues.VendorTypes.valueOf(spawnBiomes.get(2).toUpperCase()).getItem()));
        this.npc.inventory.func_70299_a(3, new ItemStack((IItemProvider)VendorSaleValues.VendorTypes.valueOf(spawnBiomes.get(3).toUpperCase()).getItem()));
        this.npc.inventory.func_70299_a(4, new ItemStack((IItemProvider)VendorSaleValues.VendorTypes.valueOf(spawnBiomes.get(4).toUpperCase()).getItem()));
        this.npc.inventory.func_70299_a(5, new ItemStack((IItemProvider)VendorSaleValues.VendorTypes.valueOf(spawnBiomes.get(5).toUpperCase()).getItem()));
        this.npc.inventory.func_70299_a(6, new ItemStack((IItemProvider)VendorSaleValues.VendorTypes.valueOf(spawnBiomes.get(6).toUpperCase()).getItem()));
        this.npc.inventory.func_70299_a(7, new ItemStack((IItemProvider)VendorSaleValues.VendorTypes.valueOf(spawnBiomes.get(7).toUpperCase()).getItem()));
    }

    public int getLevelBasedOnDistance(Entity entity, World world) {
        BlockPos spawnPos = ((ServerWorld)world).func_241135_u_();
        double distanceFromSpawn = NPCSetup.distance(spawnPos, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        int levelBase = (int)(distanceFromSpawn / 10.0);
        return Math.abs(levelBase) + 1;
    }

    public static double distance(BlockPos pos, double p_218140_1_, double p_218140_3_, double p_218140_5_) {
        double d1 = Math.abs((double)pos.func_177958_n() - p_218140_1_);
        double d2 = Math.abs((double)pos.func_177956_o() - p_218140_3_);
        double d3 = Math.abs((double)pos.func_177952_p() - p_218140_5_);
        return d1 + d2 + d3;
    }

    public String getModel() {
        return this.npc.getNPC().func_74779_i("Model");
    }

    public void setModel(String name) {
        this.npc.getNPC().func_74778_a("Model", name);
    }

    public String getJob() {
        return this.npc.getNPC().func_74779_i("Job");
    }

    public void setJob(String name) {
        this.npc.getNPC().func_74778_a("Job", name);
    }

    public String getOfferedQuest() {
        return this.npc.getNPC().func_74779_i("Quest");
    }

    public void setOfferedQuest(String name) {
        this.npc.getNPC().func_74778_a("Quest", name);
    }

    public int getVendorRefresh() {
        return this.npc.getNPC().func_74762_e("VendorRefresh");
    }

    public void setVendorRefresh(int refresh) {
        this.npc.getNPC().func_74768_a("VendorRefresh", refresh);
    }
}

