/*
 * Decompiled with CFR 0.152.
 */
package mod.cyan.digimobs.entities.setup;

import java.util.Arrays;
import mod.cyan.digimobs.entities.DigimonEntity;
import mod.cyan.digimobs.entities.setup.FieldGuide;
import mod.cyan.digimobs.entities.setup.helpers.AEF;
import mod.cyan.digimobs.entities.setup.helpers.AccessoryValues;
import mod.cyan.digimobs.entities.setup.helpers.ArmorValues;
import mod.cyan.digimobs.entities.setup.helpers.EXPTable;
import mod.cyan.digimobs.entities.setup.helpers.Form;
import mod.cyan.digimobs.entities.setup.helpers.StatGrades;
import mod.cyan.digimobs.entities.setup.helpers.WeaponValues;
import mod.cyan.digimobs.util.CommandChatHandler;
import mod.cyan.digimobs.util.Tools;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import org.apache.commons.lang3.EnumUtils;

public class Stats {
    public DigimonEntity digi;
    public String[] superrare = new String[]{"sakumon", "sakuttomon", "hackmon", "baohackmon", "saviorhackmon", "jesmon"};
    public String[] rare = new String[]{"meicoonyaromon", "meicoosalamon", "meicoomon", "meicrackmon", "meicrackmonvm", "rasielmon", "raguelmon", "puttimon", "kyupimon"};
    public String[] uncommon = new String[]{"dodomon", "dorimon", "dorumon", "dorugamon", "dorugreymon", "alphamon", "fufumon", "kyokyomon", "ryudamon", "hiyarimon", "bulucomon", "sunmon", "moonmon", "lunamon", "coronamon"};
    public String[] dinotype = new String[]{"botamon", "yukimibotamon", "curimon", "gurimon", "koromon", "agumon", "agumons", "blackagumon", "blackagumons", "gammamon", "gaossmon", "kotemon", "snowagumon", "snowagumons"};
    public String[] beasttype = new String[]{"cocomon", "paomon", "punimon", "tsubumon", "zerimon", "frimon", "gummymon", "kokomon", "moonmon", "nyaromon", "meicoonyaromon", "sunmon", "tokomon", "tsunomon", "upamon", "wanyamon", "xiaomon", "armadillomon", "bearmon", "blackgabumon", "chuumon", "coronamon", "elecmon", "gabumon", "gaomon", "gazimon", "labramon", "liollmon", "lopmon", "lunamon", "monmon", "patamon", "psychemon", "salamon", "meicoosalamon", "terriermon", "tsukaimon", "vielecmon"};
    public String[] planttype = new String[]{"nyokimon", "popomon", "yuramon", "budmon", "tanemon", "yokomon", "aruraumon", "floramon", "lalamon", "mushroomon", "palmon", "pomumon"};
    public String[] mutanttype = new String[]{"pabumon", "zurumon", "motimon", "bacomon", "gotsumon"};
    public String[] aquatictype = new String[]{"pichimon", "poyomon", "bukamon", "chapmon", "betamon", "crabmon", "gizamon", "gomamon", "modokibetamon", "otamamon", "otamamonred", "sangomon", "syakomon"};
    public String[] aviantype = new String[]{"pururumon", "puwamon", "chicchimon", "pinamon", "poromon", "biyomon", "falcomon", "hawkmon", "hyokomon", "muchomon", "penguinmon"};
    public String[] dragontype = new String[]{"chibomon", "dodomon", "fufumon", "jyarimon", "ketomon", "petitmon", "babydmon", "demiveemon", "dorimon", "gigimon", "hopmon", "hiyarimon", "kyokyomon", "blackguilmon", "bulucomon", "dorumon", "dracomon", "guilmon", "hackmon", "veemon", "vorvomon"};
    public String[] ghosttype = new String[]{"mokumon", "demimeramon", "candlemon"};
    public String[] puppettype = new String[]{"kapurimon", "clearagumon", "pawnchessmonblack", "pawnchessmonwhite", "shadowtoyagumon", "toyagumon"};
    public String[] cyborgtype = new String[]{"commandramon", "kamemon"};
    public String[] fairytype = new String[]{"cutemon"};
    public String[] shadetype = new String[]{"kiimon", "pagumon", "yaamon", "demidevimon", "goblimon", "impmon", "phascomon", "shamamon", "snowgoblimon"};
    public String[] insecttype = new String[]{"leafmon", "pupumon", "minomon", "puroromon", "dokunemon", "fanbeemon", "kunemon", "morphomon", "tentomon", "wormmon"};
    public String[] machinetype = new String[]{"bommon", "metalkoromon", "sakumon", "missimon", "sakuttomon", "hagurumon", "kokuwamon", "solarmon", "zubamon"};
    public String[] unknowntype = new String[]{"kuramon", "arkadimonfresh", "tsumemon", "keramon"};
    public String[] holytype = new String[]{"pafumon", "puttimon", "relemon", "kyaromon", "kyupimon", "viximon", "kudamon", "kudamono", "lucemon", "renamon", "tapirmon"};
    public String[] xcarrier = new String[]{"dodomon", "dorimon", "fufumon", "kyokyomon", "dorumon", "ryudamon", "dorugamon", "ginryumon", "dorugreymon", "alphamon", "pupumon", "puroromon", "fanbeemon", "waspmon", "cannonbeemon", "tigervespamon"};

    public void setupStats() {
        this.digi.setup.createPersonality(Tools.getRandomNumber(0, 6));
        this.digi.stats.setGrades();
        this.digi.stats.setSpeciesGradeHP(Tools.getRandomNumber(3, 7));
        this.digi.stats.setSpeciesGradeEG(Tools.getRandomNumber(3, 7));
        this.digi.stats.setSpeciesGradeATK(Tools.getRandomNumber(3, 7));
        this.digi.stats.setSpeciesGradeDEF(Tools.getRandomNumber(3, 7));
        this.digi.stats.setSpeciesGradeSATK(Tools.getRandomNumber(3, 7));
        this.digi.stats.setSpeciesGradeSDEF(Tools.getRandomNumber(3, 7));
        this.digi.stats.setSpeciesGradeSPE(Tools.getRandomNumber(3, 7));
        this.digi.stats.setSpeciesGradeLUK(Tools.getRandomNumber(3, 7));
        if (this.digi.setup.getPersonality().equals("Balanced")) {
            this.digi.stats.setPersonalityGradeHP(3);
            this.digi.stats.setPersonalityGradeEG(3);
            this.digi.stats.setPersonalityGradeATK(3);
            this.digi.stats.setPersonalityGradeDEF(3);
            this.digi.stats.setPersonalityGradeSATK(3);
            this.digi.stats.setPersonalityGradeSDEF(3);
            this.digi.stats.setPersonalityGradeSPE(3);
            this.digi.stats.setPersonalityGradeLUK(3);
        }
        if (this.digi.setup.getPersonality().equals("Headstrong")) {
            this.digi.stats.setPersonalityGradeHP(4);
            this.digi.stats.setPersonalityGradeEG(7);
            this.digi.stats.setPersonalityGradeATK(1);
            this.digi.stats.setPersonalityGradeDEF(3);
            this.digi.stats.setPersonalityGradeSATK(7);
            this.digi.stats.setPersonalityGradeSDEF(7);
            this.digi.stats.setPersonalityGradeSPE(5);
            this.digi.stats.setPersonalityGradeLUK(5);
        }
        if (this.digi.setup.getPersonality().equals("Cautious")) {
            this.digi.stats.setPersonalityGradeHP(3);
            this.digi.stats.setPersonalityGradeEG(7);
            this.digi.stats.setPersonalityGradeATK(4);
            this.digi.stats.setPersonalityGradeDEF(1);
            this.digi.stats.setPersonalityGradeSATK(6);
            this.digi.stats.setPersonalityGradeSDEF(4);
            this.digi.stats.setPersonalityGradeSPE(7);
            this.digi.stats.setPersonalityGradeLUK(5);
        }
        if (this.digi.setup.getPersonality().equals("Agile")) {
            this.digi.stats.setPersonalityGradeHP(5);
            this.digi.stats.setPersonalityGradeEG(6);
            this.digi.stats.setPersonalityGradeATK(3);
            this.digi.stats.setPersonalityGradeDEF(5);
            this.digi.stats.setPersonalityGradeSATK(3);
            this.digi.stats.setPersonalityGradeSDEF(6);
            this.digi.stats.setPersonalityGradeSPE(1);
            this.digi.stats.setPersonalityGradeLUK(3);
        }
        if (this.digi.setup.getPersonality().equals("Intelligent")) {
            this.digi.stats.setPersonalityGradeHP(7);
            this.digi.stats.setPersonalityGradeEG(2);
            this.digi.stats.setPersonalityGradeATK(7);
            this.digi.stats.setPersonalityGradeDEF(7);
            this.digi.stats.setPersonalityGradeSATK(1);
            this.digi.stats.setPersonalityGradeSDEF(4);
            this.digi.stats.setPersonalityGradeSPE(6);
            this.digi.stats.setPersonalityGradeLUK(5);
        }
        if (this.digi.setup.getPersonality().equals("Intuitive")) {
            this.digi.stats.setPersonalityGradeHP(4);
            this.digi.stats.setPersonalityGradeEG(3);
            this.digi.stats.setPersonalityGradeATK(7);
            this.digi.stats.setPersonalityGradeDEF(4);
            this.digi.stats.setPersonalityGradeSATK(4);
            this.digi.stats.setPersonalityGradeSDEF(1);
            this.digi.stats.setPersonalityGradeSPE(5);
            this.digi.stats.setPersonalityGradeLUK(5);
        }
        if (this.digi.setup.getPersonality().equals("Deft")) {
            this.digi.stats.setPersonalityGradeHP(5);
            this.digi.stats.setPersonalityGradeEG(5);
            this.digi.stats.setPersonalityGradeATK(5);
            this.digi.stats.setPersonalityGradeDEF(5);
            this.digi.stats.setPersonalityGradeSATK(5);
            this.digi.stats.setPersonalityGradeSDEF(5);
            this.digi.stats.setPersonalityGradeSPE(5);
            this.digi.stats.setPersonalityGradeLUK(1);
        }
        this.digi.func_70606_j(this.getSpeciesStatusHealth() + this.getPersonalityStatusHealth());
        this.digi.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)(this.getSpeciesStatusHealth() + this.getPersonalityStatusHealth()));
        this.digi.stats.setEnergy(1);
        this.digi.stats.setMaxEnergy(this.getSpeciesStatusEnergy() + this.getPersonalityStatusEnergy());
        this.digi.stats.setAttack(this.getSpeciesStatusAttack() + this.getPersonalityStatusAttack());
        this.digi.stats.setDefense(this.getSpeciesStatusDefense() + this.getPersonalityStatusDefense());
        this.digi.stats.setSpecialAttack(this.getSpeciesStatusSAttack() + this.getPersonalityStatusSAttack());
        this.digi.stats.setSpecialDefense(this.getSpeciesStatusSDefense() + this.getPersonalityStatusSDefense());
        this.digi.stats.setSpeed(this.getSpeciesStatusSpeed() + this.getPersonalityStatusSpeed());
        this.digi.stats.setLuck(this.getSpeciesStatusLuck() + this.getPersonalityStatusLuck());
        this.digi.stats.setDigimonAge(1);
        this.digi.stats.setBond(100);
        this.digi.stats.setWeight(10);
        this.digi.stats.setExp(0);
        this.digi.func_70691_i(this.digi.func_110138_aP());
    }

    public void initStats() {
        if (!this.digi.getStats().func_74764_b("Energy")) {
            this.digi.stats.setEnergy(1);
        }
        if (!this.digi.getStats().func_74764_b("MaxEnergy")) {
            this.digi.stats.setMaxEnergy(1);
        }
        if (!this.digi.getStats().func_74764_b("World")) {
            this.digi.stats.setLevel(1);
        }
        if (!this.digi.getStats().func_74764_b("Exp")) {
            this.digi.stats.setExp(1);
        }
    }

    public void updateStats() {
    }

    public int getEnergy() {
        return this.digi.getStats().func_74762_e("Energy");
    }

    public void setEnergy(int energy) {
        this.digi.getStats().func_74768_a("Energy", energy);
    }

    public void incrementEnergy(int energy) {
        this.digi.getStats().func_74768_a("Energy", this.digi.getStats().func_74762_e("Energy") + energy);
        if (this.digi.stats.getEnergy() > this.digi.stats.getMaxEnergy()) {
            this.digi.stats.setEnergy(this.digi.stats.getMaxEnergy());
        }
    }

    public int getMaxEnergy() {
        return this.digi.getStats().func_74762_e("MaxEnergy") + this.digi.getStats().func_74762_e("BonusEnergy");
    }

    public void setMaxEnergy(int maxenergy) {
        this.digi.getStats().func_74768_a("MaxEnergy", maxenergy);
    }

    public void incrementBonusEnergy(int maxenergy) {
        this.digi.getStats().func_74768_a("BonusEnergy", this.digi.getStats().func_74762_e("BonusEnergy") + maxenergy);
    }

    public void incrementBonusHealth(int health) {
        this.digi.getStats().func_74768_a("BonusHealth", this.digi.getStats().func_74762_e("BonusHealth") + health);
    }

    public int getHealthBonusFromEquipment() {
        int weapon = !this.digi.inventory.func_70301_a(0).func_190926_b() && EnumUtils.isValidEnum(WeaponValues.WeaponTypes.class, (String)this.digi.inventory.func_70301_a(0).func_77973_b().toString().toUpperCase()) ? WeaponValues.WeaponTypes.valueOf(this.digi.inventory.func_70301_a(0).func_77973_b().toString().toUpperCase()).getHPBonus() : 0;
        int armor = !this.digi.inventory.func_70301_a(1).func_190926_b() && EnumUtils.isValidEnum(ArmorValues.ArmorTypes.class, (String)this.digi.inventory.func_70301_a(1).func_77973_b().toString().toUpperCase()) ? ArmorValues.ArmorTypes.valueOf(this.digi.inventory.func_70301_a(1).func_77973_b().toString().toUpperCase()).getHPBonus() : 0;
        int accessory = !this.digi.inventory.func_70301_a(2).func_190926_b() && EnumUtils.isValidEnum(AccessoryValues.AccessoryTypes.class, (String)this.digi.inventory.func_70301_a(2).func_77973_b().toString().toUpperCase()) ? AccessoryValues.AccessoryTypes.valueOf(this.digi.inventory.func_70301_a(2).func_77973_b().toString().toUpperCase()).getHPBonus() : 0;
        return weapon + armor + accessory;
    }

    public int getLevel() {
        return this.digi.getStats().func_74762_e("World");
    }

    public void setLevel(int level) {
        this.digi.getStats().func_74768_a("World", level);
    }

    public void incrementLevel(int level) {
        this.digi.getStats().func_74768_a("World", this.digi.getStats().func_74762_e("World") + level);
    }

    public int getExp() {
        return this.digi.getStats().func_74762_e("Exp");
    }

    public void setExp(int exp) {
        this.digi.getStats().func_74768_a("Exp", exp);
    }

    public void incrementExp(int exp) {
        this.digi.getStats().func_74768_a("Exp", this.digi.getStats().func_74762_e("Exp") + exp);
    }

    public int baseExp() {
        int form = 0;
        if (this.digi.stats.getForm() == Form.FormTypes.EGG) {
            form = 0;
        }
        if (this.digi.stats.getForm() == Form.FormTypes.BABY) {
            form = 2;
        }
        if (this.digi.stats.getForm() == Form.FormTypes.INTRAINING) {
            form = 2;
        }
        if (this.digi.stats.getForm() == Form.FormTypes.ROOKIE) {
            form = 3;
        }
        if (this.digi.stats.getForm() == Form.FormTypes.CHAMPION) {
            form = 4;
        }
        if (this.digi.stats.getForm() == Form.FormTypes.ARMOR) {
            form = 4;
        }
        if (this.digi.stats.getForm() == Form.FormTypes.ULTIMATE) {
            form = 5;
        }
        if (this.digi.stats.getForm() == Form.FormTypes.MEGA) {
            form = 6;
        }
        return (25 + this.digi.stats.getLevel() / 2) * form / 2;
    }

    public int baseBits() {
        int form = 0;
        if (this.digi.stats.getForm() == Form.FormTypes.EGG) {
            form = 0;
        }
        if (this.digi.stats.getForm() == Form.FormTypes.BABY) {
            form = 1;
        }
        if (this.digi.stats.getForm() == Form.FormTypes.INTRAINING) {
            form = 2;
        }
        if (this.digi.stats.getForm() == Form.FormTypes.ROOKIE) {
            form = 3;
        }
        if (this.digi.stats.getForm() == Form.FormTypes.CHAMPION) {
            form = 4;
        }
        if (this.digi.stats.getForm() == Form.FormTypes.ARMOR) {
            form = 4;
        }
        if (this.digi.stats.getForm() == Form.FormTypes.ULTIMATE) {
            form = 5;
        }
        if (this.digi.stats.getForm() == Form.FormTypes.MEGA) {
            form = 6;
        }
        return form;
    }

    public int gainedBits(DigimonEntity dead) {
        int b = dead.stats.baseBits();
        double e = 1.0;
        int l = dead.stats.getLevel();
        double p = this.spiralBonus(dead);
        int gained = (int)((double)b * e * (double)l * p);
        return gained / 2 * 1;
    }

    public int gainedExp(DigimonEntity dead) {
        double a = 1.5;
        double t = 1.0;
        int b = dead.stats.baseExp();
        double e = !this.digi.inventory.func_70301_a(2).func_190926_b() && EnumUtils.isValidEnum(AccessoryValues.AccessoryTypes.class, (String)this.digi.inventory.func_70301_a(2).func_77973_b().toString().toUpperCase()) ? 1.0 + AccessoryValues.AccessoryTypes.valueOf(this.digi.inventory.func_70301_a(2).func_77973_b().toString().toUpperCase()).getExp() : 1.0;
        int l = dead.stats.getLevel();
        double p = this.spiralBonus(dead);
        double f = 1.0;
        int s = 1;
        int gained = (int)(a * t * (double)b * e * (double)l * f * p / (double)(7 * s));
        return gained * 1;
    }

    public double spiralBonus(DigimonEntity dead) {
        if (dead.isSpiral()) {
            return 2.0;
        }
        return 1.0;
    }

    public void determineLevelUp(DigimonEntity attacker, DigimonEntity dead) {
        attacker.stats.setExp(attacker.stats.getExp() + attacker.stats.gainedExp(dead));
        if (attacker.func_70902_q() != null) {
            CommandChatHandler.sendChat((ICommandSource)attacker.func_70902_q(), attacker.func_184753_b(), "\u6402a" + attacker.setup.getTrueName() + "\u947e\u5cf0\u7df1\u6d5c\ufffd" + attacker.stats.gainedExp(dead) + "\u9410\u572d\u7ca1\u6960\ufffd", new Object[0]);
        }
        if (this.digi.stats.getExp() > this.digi.stats.getNeededExp()) {
            this.levelUp();
        }
    }

    public int getNeededExp() {
        if (this.getLevel() < 100) {
            return EXPTable.ExpTypes.values()[this.digi.stats.getLevel()].getMediumSlowExp() - EXPTable.ExpTypes.values()[this.digi.stats.getLevel() - 1].getMediumSlowExp();
        }
        return 1;
    }

    public void levelUp() {
        int remainder = 0;
        if (this.digi.stats.getExp() > this.digi.stats.getNeededExp()) {
            remainder = this.digi.stats.getExp() - this.digi.stats.getNeededExp();
        }
        this.digi.stats.incrementLevel(1);
        this.digi.stats.setMaxEnergy(this.getSpeciesStatusEnergy() + this.getPersonalityStatusEnergy());
        this.digi.stats.setAttack(this.getSpeciesStatusAttack() + this.getPersonalityStatusAttack());
        this.digi.stats.setDefense(this.getSpeciesStatusDefense() + this.getPersonalityStatusDefense());
        this.digi.stats.setSpecialAttack(this.getSpeciesStatusSAttack() + this.getPersonalityStatusSAttack());
        this.digi.stats.setSpecialDefense(this.getSpeciesStatusSDefense() + this.getPersonalityStatusSDefense());
        this.digi.stats.setSpeed(this.getSpeciesStatusSpeed() + this.getPersonalityStatusSpeed());
        this.digi.stats.setLuck(this.getSpeciesStatusLuck() + this.getPersonalityStatusLuck());
        this.digi.stats.setEnergy(this.digi.stats.getMaxEnergy());
        if (remainder > 1) {
            this.digi.stats.setExp(remainder - 1);
        } else {
            this.digi.stats.setExp(1);
        }
        if (this.digi.func_70902_q() != null) {
            CommandChatHandler.sendChat((ICommandSource)this.digi.func_70902_q(), this.digi.func_184753_b(), "\u6402C" + this.digi.setup.getTrueName() + " leveled up!", new Object[0]);
        }
        this.updateStats();
        this.digi.func_70606_j(this.getSpeciesStatusHealth() + this.getPersonalityStatusHealth());
        this.digi.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)(this.getSpeciesStatusHealth() + this.getPersonalityStatusHealth() + this.digi.getStats().func_74762_e("BonusHealth") + this.digi.stats.getHealthBonusFromEquipment()));
        this.digi.func_70691_i(this.digi.func_110138_aP());
    }

    public int getRank() {
        int speedscore;
        int spdefensescore;
        int spattackscore;
        int defensescore;
        int attackscore;
        int form;
        int isuncommon;
        int level = this.digi.stats.getLevel();
        int issuperrare = Arrays.asList(this.superrare).contains(this.digi.getInternalDigimonName()) ? 300 : 0;
        int israre = Arrays.asList(this.rare).contains(this.digi.getInternalDigimonName()) ? 200 : 0;
        int n = isuncommon = Arrays.asList(this.uncommon).contains(this.digi.getInternalDigimonName()) ? 100 : 0;
        int n2 = this.getForm() == Form.FormTypes.BABY ? 10 : (this.getForm() == Form.FormTypes.INTRAINING ? 20 : (this.getForm() == Form.FormTypes.ROOKIE ? 40 : (this.getForm() == Form.FormTypes.CHAMPION ? 50 : (this.getForm() == Form.FormTypes.ARMOR ? 60 : (this.getForm() == Form.FormTypes.ULTIMATE ? 80 : (form = this.getForm() == Form.FormTypes.MEGA ? 100 : 0))))));
        int n3 = this.getSpeciesGradeATK() == 7 ? 6 : (this.getSpeciesGradeATK() == 6 ? 12 : (this.getSpeciesGradeATK() == 5 ? 18 : (this.getSpeciesGradeATK() == 4 ? 24 : (this.getSpeciesGradeATK() == 3 ? 30 : (this.getSpeciesGradeATK() == 2 ? 36 : (this.getSpeciesGradeATK() == 1 ? 42 : (attackscore = this.getSpeciesGradeATK() == 0 ? 50 : 0)))))));
        int n4 = this.getSpeciesGradeDEF() == 7 ? 6 : (this.getSpeciesGradeDEF() == 6 ? 12 : (this.getSpeciesGradeDEF() == 5 ? 18 : (this.getSpeciesGradeDEF() == 4 ? 24 : (this.getSpeciesGradeDEF() == 3 ? 30 : (this.getSpeciesGradeDEF() == 2 ? 36 : (this.getSpeciesGradeDEF() == 1 ? 42 : (defensescore = this.getSpeciesGradeDEF() == 0 ? 50 : 0)))))));
        int n5 = this.getSpeciesGradeSATK() == 7 ? 6 : (this.getSpeciesGradeSATK() == 6 ? 12 : (this.getSpeciesGradeSATK() == 5 ? 18 : (this.getSpeciesGradeSATK() == 4 ? 24 : (this.getSpeciesGradeSATK() == 3 ? 30 : (this.getSpeciesGradeSATK() == 2 ? 36 : (this.getSpeciesGradeSATK() == 1 ? 42 : (spattackscore = this.getSpeciesGradeSATK() == 0 ? 50 : 0)))))));
        int n6 = this.getSpeciesGradeSDEF() == 7 ? 6 : (this.getSpeciesGradeSDEF() == 6 ? 12 : (this.getSpeciesGradeSDEF() == 5 ? 18 : (this.getSpeciesGradeSDEF() == 4 ? 24 : (this.getSpeciesGradeSDEF() == 3 ? 30 : (this.getSpeciesGradeSDEF() == 2 ? 36 : (this.getSpeciesGradeSDEF() == 1 ? 42 : (spdefensescore = this.getSpeciesGradeSDEF() == 0 ? 50 : 0)))))));
        int n7 = this.getSpeciesGradeSPE() == 7 ? 6 : (this.getSpeciesGradeSPE() == 6 ? 12 : (this.getSpeciesGradeSPE() == 5 ? 18 : (this.getSpeciesGradeSPE() == 4 ? 24 : (this.getSpeciesGradeSPE() == 3 ? 30 : (this.getSpeciesGradeSPE() == 2 ? 36 : (this.getSpeciesGradeSPE() == 1 ? 42 : (speedscore = this.getSpeciesGradeSPE() == 0 ? 50 : 0)))))));
        int luckscore = this.getSpeciesGradeLUK() == 7 ? 6 : (this.getSpeciesGradeLUK() == 6 ? 12 : (this.getSpeciesGradeLUK() == 5 ? 18 : (this.getSpeciesGradeLUK() == 4 ? 24 : (this.getSpeciesGradeLUK() == 3 ? 30 : (this.getSpeciesGradeLUK() == 2 ? 36 : (this.getSpeciesGradeLUK() == 1 ? 42 : (this.getSpeciesGradeLUK() == 0 ? 50 : 0)))))));
        int total = level + issuperrare + israre + isuncommon + form + attackscore + defensescore + spattackscore + spdefensescore + speedscore + luckscore;
        if (total >= 550) {
            return 10;
        }
        if (total < 550 && total >= 500) {
            return 9;
        }
        if (total < 500 && total >= 450) {
            return 8;
        }
        if (total < 450 && total >= 400) {
            return 7;
        }
        if (total < 400 && total >= 350) {
            return 6;
        }
        if (total < 350 && total >= 300) {
            return 5;
        }
        if (total < 300 && total >= 250) {
            return 4;
        }
        if (total < 250 && total >= 200) {
            return 3;
        }
        if (total < 200 && total >= 150) {
            return 2;
        }
        if (total < 150 && total >= 100) {
            return 1;
        }
        if (total < 100 && total >= 0) {
            return 0;
        }
        return 0;
    }

    public int getStrength() {
        return (int)Math.floor(this.digi.stats.getAttack() / 2);
    }

    public int getVitality() {
        int equipment = !this.digi.inventory.func_70301_a(1).func_190926_b() && EnumUtils.isValidEnum(ArmorValues.ArmorTypes.class, (String)this.digi.inventory.func_70301_a(1).func_77973_b().toString().toUpperCase()) ? ArmorValues.ArmorTypes.valueOf(this.digi.inventory.func_70301_a(1).func_77973_b().toString().toUpperCase()).getDef() : 0;
        return (int)Math.floor((double)equipment + (double)this.digi.stats.getDefense() * 1.5);
    }

    public int getAccuracy() {
        return (int)Math.floor(this.digi.stats.getSpeed() / 2);
    }

    public int getEvasion() {
        return (int)Math.floor(this.digi.stats.getLuck() / 2);
    }

    public int getBonusLimit() {
        return this.digi.getStats().func_74762_e("ChipsBonus");
    }

    public Stats(DigimonEntity digimon) {
        this.digi = digimon;
    }

    public void setBonusLimit(int bonus) {
        this.digi.getStats().func_74768_a("ChipsBonus", bonus);
    }

    public void incrementBonusLimit(int bonus) {
        this.digi.getStats().func_74768_a("ChipsBonus", this.digi.getStats().func_74762_e("ChipsBonus") + bonus);
    }

    public int getAttack() {
        return this.digi.getStats().func_74762_e("Attack") + this.digi.getStats().func_74762_e("BonusAttack");
    }

    public void setAttack(int attack) {
        this.digi.getStats().func_74768_a("Attack", attack);
    }

    public void incrementAttack(int attack) {
        this.digi.getStats().func_74768_a("Attack", this.digi.getStats().func_74762_e("Attack") + attack);
    }

    public void incrementBonusAttack(int attack) {
        this.digi.getStats().func_74768_a("BonusAttack", this.digi.getStats().func_74762_e("BonusAttack") + attack);
    }

    public int getDefense() {
        return this.digi.getStats().func_74762_e("Defense") + this.digi.getStats().func_74762_e("BonusDefense");
    }

    public void setDefense(int defense) {
        this.digi.getStats().func_74768_a("Defense", defense);
    }

    public void incrementDefense(int defense) {
        this.digi.getStats().func_74768_a("Defense", this.digi.getStats().func_74762_e("Defense") + defense);
    }

    public void incrementBonusDefense(int defense) {
        this.digi.getStats().func_74768_a("BonusDefense", this.digi.getStats().func_74762_e("BonusDefense") + defense);
    }

    public int getSpeed() {
        return this.digi.getStats().func_74762_e("Speed") + this.digi.getStats().func_74762_e("BonusSpeed");
    }

    public void setSpeed(int speed) {
        this.digi.getStats().func_74768_a("Speed", speed);
    }

    public void incrementSpeed(int speed) {
        this.digi.getStats().func_74768_a("Speed", this.digi.getStats().func_74762_e("Speed") + speed);
    }

    public void incrementBonusSpeed(int speed) {
        this.digi.getStats().func_74768_a("BonusSpeed", this.digi.getStats().func_74762_e("BonusSpeed") + speed);
    }

    public int getSpecialAttack() {
        return this.digi.getStats().func_74762_e("SpecialAttack") + this.digi.getStats().func_74762_e("BonusSpecialAttack");
    }

    public void setSpecialAttack(int specialweight) {
        this.digi.getStats().func_74768_a("SpecialAttack", specialweight);
    }

    public void incrementSpecialAttack(int specialweight) {
        this.digi.getStats().func_74768_a("SpecialAttack", this.digi.getStats().func_74762_e("SpecialAttack") + specialweight);
    }

    public void incrementBonusSpecialAttack(int spattack) {
        this.digi.getStats().func_74768_a("BonusSpecialAttack", this.digi.getStats().func_74762_e("BonusSpecialAttack") + spattack);
    }

    public int getSpecialDefense() {
        return this.digi.getStats().func_74762_e("SpecialDefense") + this.digi.getStats().func_74762_e("BonusSpecialDefense");
    }

    public void setSpecialDefense(int specialdefense) {
        this.digi.getStats().func_74768_a("SpecialDefense", specialdefense);
    }

    public void incrementSpecialDefense(int specialdefense) {
        this.digi.getStats().func_74768_a("SpecialDefense", this.digi.getStats().func_74762_e("SpecialDefense") + specialdefense);
    }

    public void incrementBonusSpecialDefense(int spdefense) {
        this.digi.getStats().func_74768_a("BonusSpecialDefense", this.digi.getStats().func_74762_e("BonusSpecialDefense") + spdefense);
    }

    public int getLuck() {
        return this.digi.getStats().func_74762_e("Luck") + this.digi.getStats().func_74762_e("BonusLuck");
    }

    public void setLuck(int luck) {
        this.digi.getStats().func_74768_a("Luck", luck);
    }

    public void incrementLuck(int luck) {
        this.digi.getStats().func_74768_a("Luck", this.digi.getStats().func_74762_e("Luck") + luck);
    }

    public void incrementBonusLuck(int luck) {
        this.digi.getStats().func_74768_a("BonusLuck", this.digi.getStats().func_74762_e("BonusLuck") + luck);
    }

    public int getWeight() {
        return this.digi.getStats().func_74762_e("Weight");
    }

    public void setWeight(int weight) {
        this.digi.getStats().func_74768_a("Weight", weight);
    }

    public void incrementWeight(int weight) {
        this.digi.getStats().func_74768_a("Weight", this.digi.getStats().func_74762_e("Weight") + weight);
    }

    public void decrementWeight(int weight) {
        this.digi.getStats().func_74768_a("Weight", this.digi.getStats().func_74762_e("Weight") - weight);
    }

    public int getMaxWeight() {
        int passive = this.digi.setup.getPassive().equals("Glutton") ? 100 : 0;
        return (int)((double)(0.5f * (float)this.digi.stats.getLevel() + (float)(2 * this.digi.stats.getSpecialDefense())) + 0.1 * (double)this.digi.stats.getDigimonAge() + (double)passive);
    }

    public void checkForHunger() {
        if (Tools.getRandomNumber(1, 4) == 1) {
            if (this.digi.stats.getWeight() > -10) {
                this.digi.stats.decrementWeight(1);
                this.digi.stats.updateStats();
            }
            if (this.digi.stats.getWeight() <= 0) {
                // empty if block
            }
        }
    }

    public void checkForFailure() {
        if (Tools.getRandomNumber(1, 10) == 1) {
            this.digi.digivolutions.failureEvolve(this.digi, "numemon");
        }
    }

    public int getDigimonAge() {
        return this.digi.getStats().func_74762_e("DigimonAge");
    }

    public void setDigimonAge(int digimonage) {
        this.digi.getStats().func_74768_a("DigimonAge", digimonage);
    }

    public void incrementDigimonAge(int digimonage) {
        this.digi.getStats().func_74768_a("DigimonAge", this.digi.getStats().func_74762_e("DigimonAge") + digimonage);
    }

    public int getDigimonAgeTimer() {
        return this.digi.getStats().func_74762_e("DigimonAgeTimer");
    }

    public void setDigimonAgeTimer(int digimonagetimer) {
        this.digi.getStats().func_74768_a("DigimonAgeTimer", digimonagetimer);
    }

    public int getBond() {
        return this.digi.getStats().func_74762_e("Bond");
    }

    public void setBond(int bond) {
        this.digi.getStats().func_74768_a("Bond", bond);
    }

    public void incrementBond(int bond) {
        this.digi.getStats().func_74768_a("Bond", this.digi.getStats().func_74762_e("Bond") + bond);
    }

    public int getTameAmount() {
        return this.digi.getStats().func_74762_e("TameAmount");
    }

    public void setTameAmount(int tame) {
        this.digi.getStats().func_74768_a("TameAmount", tame);
    }

    public void incrementTameAmount(int tame) {
        this.digi.getStats().func_74768_a("TameAmount", this.digi.getStats().func_74762_e("TameAmount") + tame);
    }

    public int getMaxTameAmount() {
        return this.getLevel() + this.getSpecialDefense() + this.getLuck();
    }

    public CompoundNBT getGrades() {
        return this.digi.getStats().func_74775_l("Grades");
    }

    public float getDelay() {
        int passive = this.digi.setup.getPassive().equals("Haste") ? 156 : 0;
        int equipment = !this.digi.inventory.func_70301_a(0).func_190926_b() && EnumUtils.isValidEnum(WeaponValues.WeaponTypes.class, (String)this.digi.inventory.func_70301_a(0).func_77973_b().toString().toUpperCase()) ? WeaponValues.WeaponTypes.valueOf(this.digi.inventory.func_70301_a(0).func_77973_b().toString().toUpperCase()).getDelay() : 480;
        float delay = Math.abs(equipment * (1 - passive / 1024) / 60);
        return delay * 20.0f;
    }

    public void setGrades() {
        this.digi.getStats().func_218657_a("Grades", (INBT)new CompoundNBT());
    }

    public int getSpeciesGradeHP() {
        return this.digi.stats.getGrades().func_74762_e("SpeciesGradeHP");
    }

    public void setSpeciesGradeHP(int grades) {
        this.digi.stats.getGrades().func_74768_a("SpeciesGradeHP", grades);
    }

    public int getSpeciesGradeEG() {
        return this.digi.stats.getGrades().func_74762_e("SpeciesGradeEG");
    }

    public void setSpeciesGradeEG(int grades) {
        this.digi.stats.getGrades().func_74768_a("SpeciesGradeEG", grades);
    }

    public int getSpeciesGradeATK() {
        return this.digi.stats.getGrades().func_74762_e("SpeciesGradeATK");
    }

    public void setSpeciesGradeATK(int grades) {
        this.digi.stats.getGrades().func_74768_a("SpeciesGradeATK", grades);
    }

    public int getSpeciesGradeDEF() {
        return this.digi.stats.getGrades().func_74762_e("SpeciesGradeDEF");
    }

    public void setSpeciesGradeDEF(int grades) {
        this.digi.stats.getGrades().func_74768_a("SpeciesGradeDEF", grades);
    }

    public int getSpeciesGradeSATK() {
        return this.digi.stats.getGrades().func_74762_e("SpeciesGradeSATK");
    }

    public void setSpeciesGradeSATK(int grades) {
        this.digi.stats.getGrades().func_74768_a("SpeciesGradeSATK", grades);
    }

    public int getSpeciesGradeSDEF() {
        return this.digi.stats.getGrades().func_74762_e("SpeciesGradeSDEF");
    }

    public void setSpeciesGradeSDEF(int grades) {
        this.digi.stats.getGrades().func_74768_a("SpeciesGradeSDEF", grades);
    }

    public int getSpeciesGradeSPE() {
        return this.digi.stats.getGrades().func_74762_e("SpeciesGradeSPE");
    }

    public void setSpeciesGradeSPE(int grades) {
        this.digi.stats.getGrades().func_74768_a("SpeciesGradeSPE", grades);
    }

    public int getSpecialDelay() {
        int delay = Math.abs((900 - this.digi.stats.getSpeed() - this.digi.stats.getSpecialAttack()) / 60);
        return delay * 20;
    }

    public int getSpeciesGradeLUK() {
        return this.digi.stats.getGrades().func_74762_e("SpeciesGradeLUK");
    }

    public void setSpeciesGradeLUK(int grades) {
        this.digi.stats.getGrades().func_74768_a("SpeciesGradeLUK", grades);
    }

    public int getPersonalityGradeHP() {
        return this.digi.stats.getGrades().func_74762_e("PersonalityGradeHP");
    }

    public void setPersonalityGradeHP(int grades) {
        this.digi.stats.getGrades().func_74768_a("PersonalityGradeHP", grades);
    }

    public int getPersonalityGradeEG() {
        return this.digi.stats.getGrades().func_74762_e("PersonalityGradeEG");
    }

    public void setPersonalityGradeEG(int grades) {
        this.digi.stats.getGrades().func_74768_a("PersonalityGradeEG", grades);
    }

    public int getPersonalityGradeATK() {
        return this.digi.stats.getGrades().func_74762_e("PersonalityGradeATK");
    }

    public void setPersonalityGradeATK(int grades) {
        this.digi.stats.getGrades().func_74768_a("PersonalityGradeATK", grades);
    }

    public int getPersonalityGradeDEF() {
        return this.digi.stats.getGrades().func_74762_e("PersonalityGradeDEF");
    }

    public void setPersonalityGradeDEF(int grades) {
        this.digi.stats.getGrades().func_74768_a("PersonalityGradeDEF", grades);
    }

    public int getPersonalityGradeSATK() {
        return this.digi.stats.getGrades().func_74762_e("PersonalityGradeSATK");
    }

    public void setPersonalityGradeSATK(int grades) {
        this.digi.stats.getGrades().func_74768_a("PersonalityGradeSATK", grades);
    }

    public int getPersonalityGradeSDEF() {
        return this.digi.stats.getGrades().func_74762_e("PersonalityGradeSDEF");
    }

    public void setPersonalityGradeSDEF(int grades) {
        this.digi.stats.getGrades().func_74768_a("PersonalityGradeSDEF", grades);
    }

    public int getPersonalityGradeSPE() {
        return this.digi.stats.getGrades().func_74762_e("PersonalityGradeSPE");
    }

    public void setPersonalityGradeSPE(int grades) {
        this.digi.stats.getGrades().func_74768_a("PersonalityGradeSPE", grades);
    }

    public int getPersonalityGradeLUK() {
        return this.digi.stats.getGrades().func_74762_e("PersonalityGradeLUK");
    }

    public void setPersonalityGradeLUK(int grades) {
        this.digi.stats.getGrades().func_74768_a("PersonalityGradeLUK", grades);
    }

    public int getSpeciesStatusHealth() {
        return (int)(StatGrades.GradeTypes.values()[this.digi.stats.getSpeciesGradeHP()].getHPScale() * (float)(this.getLevel() - 1) + StatGrades.GradeTypes.values()[this.digi.stats.getSpeciesGradeHP()].getHPBase() + (float)(2 * this.MLvX()) + StatGrades.GradeTypes.values()[this.digi.stats.getSpeciesGradeHP()].getHPScaleXXX() * (float)this.MLvXXX());
    }

    public CompoundNBT getGenetics() {
        return this.digi.getStats().func_74775_l("Genetics");
    }

    public void setGenetics() {
        this.digi.getStats().func_218657_a("Genetics", (INBT)new CompoundNBT());
    }

    public String getTypeGenetics() {
        return this.digi.stats.getGenetics().func_74779_i("GeneticType");
    }

    public void setTypeGenetics(String nbt) {
        this.digi.stats.getGenetics().func_74778_a("GeneticType", nbt);
    }

    public String getAttributeGenetics() {
        return this.digi.stats.getGenetics().func_74779_i("AttributeType");
    }

    public void setAttributeGenetics(String nbt) {
        this.digi.stats.getGenetics().func_74778_a("AttributeType", nbt);
    }

    public String getColorGenetics() {
        return this.digi.stats.getGenetics().func_74779_i("ColorType");
    }

    public void setColorGenetics(String nbt) {
        this.digi.stats.getGenetics().func_74778_a("ColorType", nbt);
    }

    public String getSizeGenetics() {
        return this.digi.stats.getGenetics().func_74779_i("SizeType");
    }

    public void setSizeGenetics(String nbt) {
        this.digi.stats.getGenetics().func_74778_a("SizeType", nbt);
    }

    public String getXAntibodyGenetics() {
        return this.digi.stats.getGenetics().func_74779_i("XAntibodyType");
    }

    public void setXAntibodyGenetics(String nbt) {
        this.digi.stats.getGenetics().func_74778_a("XAntibodyType", nbt);
    }

    public int MLvX() {
        if (this.getLevel() > 10) {
            return this.getLevel() - 10;
        }
        return 0;
    }

    public int MLvXXX() {
        if (this.getLevel() > 30) {
            return this.getLevel() - 30;
        }
        return 0;
    }

    public int getSpeciesStatusEnergy() {
        return (int)(StatGrades.GradeTypes.values()[this.digi.stats.getSpeciesGradeEG()].getEGScale() * (float)(this.getLevel() - 1) + StatGrades.GradeTypes.values()[this.digi.stats.getSpeciesGradeEG()].getEGBase());
    }

    public int getSpeciesStatusAttack() {
        return (int)(StatGrades.GradeTypes.values()[this.digi.stats.getSpeciesGradeATK()].getStatScale() * (float)(this.getLevel() - 1) + StatGrades.GradeTypes.values()[this.digi.stats.getSpeciesGradeATK()].getStatBase());
    }

    public int getSpeciesStatusDefense() {
        return (int)(StatGrades.GradeTypes.values()[this.digi.stats.getSpeciesGradeDEF()].getStatScale() * (float)(this.getLevel() - 1) + StatGrades.GradeTypes.values()[this.digi.stats.getSpeciesGradeDEF()].getStatBase());
    }

    public int getSpeciesStatusSAttack() {
        return (int)(StatGrades.GradeTypes.values()[this.digi.stats.getSpeciesGradeSATK()].getStatScale() * (float)(this.getLevel() - 1) + StatGrades.GradeTypes.values()[this.digi.stats.getSpeciesGradeSATK()].getStatBase());
    }

    public int getSpeciesStatusSDefense() {
        return (int)(StatGrades.GradeTypes.values()[this.digi.stats.getSpeciesGradeSDEF()].getStatScale() * (float)(this.getLevel() - 1) + StatGrades.GradeTypes.values()[this.digi.stats.getSpeciesGradeSDEF()].getStatBase());
    }

    public int getSpeciesStatusSpeed() {
        return (int)(StatGrades.GradeTypes.values()[this.digi.stats.getSpeciesGradeSPE()].getStatScale() * (float)(this.getLevel() - 1) + StatGrades.GradeTypes.values()[this.digi.stats.getSpeciesGradeSPE()].getStatBase());
    }

    public int getSpeciesStatusLuck() {
        return (int)(StatGrades.GradeTypes.values()[this.digi.stats.getSpeciesGradeLUK()].getStatScale() * (float)(this.getLevel() - 1) + StatGrades.GradeTypes.values()[this.digi.stats.getSpeciesGradeLUK()].getStatBase());
    }

    public int getPersonalityStatusHealth() {
        return (int)(StatGrades.GradeTypes.values()[this.digi.stats.getPersonalityGradeHP()].getHPScale() * (float)(this.getLevel() - 1) + StatGrades.GradeTypes.values()[this.digi.stats.getPersonalityGradeHP()].getHPBase() + StatGrades.GradeTypes.values()[this.digi.stats.getPersonalityGradeHP()].getHPScaleXXX() * (float)this.MLvXXX());
    }

    public int getPersonalityStatusEnergy() {
        return (int)(StatGrades.GradeTypes.values()[this.digi.stats.getSpeciesGradeEG()].getEGScale() * (float)(this.getLevel() - 1) + StatGrades.GradeTypes.values()[this.digi.stats.getSpeciesGradeEG()].getEGBase());
    }

    public int getPersonalityStatusAttack() {
        return (int)(StatGrades.GradeTypes.values()[this.digi.stats.getPersonalityGradeATK()].getStatScale() * (float)(this.getLevel() - 1) + StatGrades.GradeTypes.values()[this.digi.stats.getPersonalityGradeATK()].getStatBase());
    }

    public int getPersonalityStatusDefense() {
        return (int)(StatGrades.GradeTypes.values()[this.digi.stats.getPersonalityGradeDEF()].getStatScale() * (float)(this.getLevel() - 1) + StatGrades.GradeTypes.values()[this.digi.stats.getPersonalityGradeDEF()].getStatBase());
    }

    public int getPersonalityStatusSAttack() {
        return (int)(StatGrades.GradeTypes.values()[this.digi.stats.getPersonalityGradeSATK()].getStatScale() * (float)(this.getLevel() - 1) + StatGrades.GradeTypes.values()[this.digi.stats.getPersonalityGradeSATK()].getStatBase());
    }

    public int getPersonalityStatusSDefense() {
        return (int)(StatGrades.GradeTypes.values()[this.digi.stats.getPersonalityGradeSDEF()].getStatScale() * (float)(this.getLevel() - 1) + StatGrades.GradeTypes.values()[this.digi.stats.getPersonalityGradeSDEF()].getStatBase());
    }

    public int getPersonalityStatusSpeed() {
        return (int)(StatGrades.GradeTypes.values()[this.digi.stats.getPersonalityGradeSPE()].getStatScale() * (float)(this.getLevel() - 1) + StatGrades.GradeTypes.values()[this.digi.stats.getPersonalityGradeSPE()].getStatBase());
    }

    public int getPersonalityStatusLuck() {
        return (int)(StatGrades.GradeTypes.values()[this.digi.stats.getPersonalityGradeLUK()].getStatScale() * (float)(this.getLevel() - 1) + StatGrades.GradeTypes.values()[this.digi.stats.getPersonalityGradeLUK()].getStatBase());
    }

    public AEF.AefTypes getAttribute() {
        return FieldGuide.DigimonTypes.valueOf(this.digi.getInternalDigimonName().toUpperCase()).getAttribute();
    }

    public AEF.AefTypes getElement() {
        return FieldGuide.DigimonTypes.valueOf(this.digi.getInternalDigimonName().toUpperCase()).getElement();
    }

    public AEF.AefTypes getField() {
        return FieldGuide.DigimonTypes.valueOf(this.digi.getInternalDigimonName().toUpperCase()).getField();
    }

    public Form.FormTypes getForm() {
        return FieldGuide.DigimonTypes.valueOf(this.digi.getInternalDigimonName().toUpperCase()).getForm();
    }
}

