/*
 * Decompiled with CFR 0.152.
 */
package mod.cyan.digimobs.util;

import java.util.Random;
import mod.cyan.digimobs.entities.DigimonEntity;
import mod.cyan.digimobs.entities.setup.helpers.AEF;
import mod.cyan.digimobs.entities.setup.helpers.Form;
import mod.cyan.digimobs.entities.setup.helpers.WeaponValues;
import mod.cyan.digimobs.init.ModItems;
import mod.cyan.digimobs.util.CommandChatHandler;
import mod.cyan.digimobs.util.Tools;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.EnumUtils;

@Mod.EventBusSubscriber(modid="digimobs", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DigimobsBattleHandler {
    @SubscribeEvent
    public static void onEntityHurt(LivingHurtEvent event) {
        DigimonEntity theattacker;
        if (event.getEntity() instanceof PlayerEntity && event.getSource().func_76364_f() instanceof DigimonEntity) {
            theattacker = (DigimonEntity)event.getSource().func_76364_f();
            if (theattacker.stats.getForm() == Form.FormTypes.BABY) {
                event.setAmount(2.0f);
            }
            if (theattacker.stats.getForm() == Form.FormTypes.INTRAINING) {
                event.setAmount(4.0f);
            }
            if (theattacker.stats.getForm() == Form.FormTypes.ROOKIE) {
                event.setAmount(6.0f);
            }
            if (theattacker.stats.getForm() == Form.FormTypes.CHAMPION) {
                event.setAmount(8.0f);
            }
            if (theattacker.stats.getForm() == Form.FormTypes.ARMOR) {
                event.setAmount(8.0f);
            }
            if (theattacker.stats.getForm() == Form.FormTypes.ULTIMATE) {
                event.setAmount(10.0f);
            }
            if (theattacker.stats.getForm() == Form.FormTypes.MEGA) {
                event.setAmount(10.0f);
            }
        }
        if (event.getEntity() instanceof LivingEntity && !(event.getEntity() instanceof DigimonEntity) && event.getSource().func_76364_f() instanceof DigimonEntity) {
            theattacker = (DigimonEntity)event.getSource().func_76364_f();
            if (theattacker.stats.getForm() == Form.FormTypes.BABY) {
                event.setAmount(4.0f);
            }
            if (theattacker.stats.getForm() == Form.FormTypes.INTRAINING) {
                event.setAmount(8.0f);
            }
            if (theattacker.stats.getForm() == Form.FormTypes.ROOKIE) {
                event.setAmount(12.0f);
            }
            if (theattacker.stats.getForm() == Form.FormTypes.CHAMPION) {
                event.setAmount(20.0f);
            }
            if (theattacker.stats.getForm() == Form.FormTypes.ARMOR) {
                event.setAmount(20.0f);
            }
            if (theattacker.stats.getForm() == Form.FormTypes.ULTIMATE) {
                event.setAmount(30.0f);
            }
            if (theattacker.stats.getForm() == Form.FormTypes.MEGA) {
                event.setAmount(40.0f);
            }
        }
        if (event.getEntity() instanceof DigimonEntity) {
            DigimonEntity theattacker2;
            DigimonEntity thehurt = (DigimonEntity)event.getEntity();
            if (event.getSource().func_76364_f() instanceof DigimonEntity) {
                theattacker2 = (DigimonEntity)event.getSource().func_76364_f();
                if (theattacker2.func_70909_n()) {
                    theattacker2.stats.checkForHunger();
                }
                if (thehurt.func_70909_n() && thehurt.func_70902_q() == null) {
                    thehurt.func_70691_i(100.0f);
                }
                float a = DigimobsBattleHandler.getAttributeAdvantage(theattacker2, thehurt) + DigimobsBattleHandler.getFieldAdvantage(theattacker2, thehurt) + DigimobsBattleHandler.getFormAdvantage(theattacker2, thehurt);
                double basedamage = DigimobsBattleHandler.getMonsterBaseDamage(theattacker2) + DigimobsBattleHandler.getMonsterfSTRFormula(theattacker2, thehurt);
                double physicaldmg = Math.floor(basedamage * (double)DigimobsBattleHandler.monsterpDIF(theattacker2, thehurt) + basedamage * (double)DigimobsBattleHandler.monsterpDIF(theattacker2, thehurt) * (double)a);
                if (physicaldmg < 0.0) {
                    physicaldmg = 0.0;
                }
                thehurt.setEnemyInfo(theattacker2.func_145782_y());
                theattacker2.setAttackType(1);
                if (Tools.getRandomNumber(1, 100) > DigimobsBattleHandler.getHitRate(theattacker2, thehurt)) {
                    event.setAmount(0.0f);
                    if (theattacker2.func_70902_q() != null) {
                        CommandChatHandler.sendChat((ICommandSource)theattacker2.func_70902_q(), theattacker2.func_184753_b(), "\u6402C" + theattacker2.setup.getTrueName() + " missed!", new Object[0]);
                    }
                    if (thehurt.func_70902_q() != null) {
                        CommandChatHandler.sendChat((ICommandSource)thehurt.func_70902_q(), thehurt.func_184753_b(), "\u6402a" + thehurt.setup.getTrueName() + " dodged the attack!", new Object[0]);
                    }
                } else {
                    event.setAmount((float)physicaldmg);
                }
                theattacker2.checkLifeDrain(theattacker2, physicaldmg);
            }
            if (event.getSource().func_76364_f() instanceof PlayerEntity) {
                theattacker2 = (PlayerEntity)event.getSource().func_76364_f();
                if (thehurt.func_70909_n() && thehurt.func_70902_q() == null) {
                    thehurt.func_70691_i(100.0f);
                }
                if (thehurt.func_70909_n() && theattacker2 == thehurt.func_70902_q() && Tools.getRandomNumber(1, 4) == 3) {
                    thehurt.func_70099_a(new ItemStack((IItemProvider)ModItems.DIGITEAR.get()), 0.3f);
                    thehurt.stats.incrementBond(-5);
                }
            }
        }
    }

    public static int getHitRate(DigimonEntity attacker, DigimonEntity hurt) {
        int dlvl = hurt.stats.getLevel() - attacker.stats.getLevel();
        int hitrate = (int)(75.0 + Math.floor((attacker.stats.getAccuracy() - hurt.stats.getEvasion()) / 2) - (double)(2 * dlvl));
        if (hitrate > 99) {
            return 99;
        }
        return hitrate;
    }

    public static int getMonsterfSTRFormula(DigimonEntity attacker, DigimonEntity hurt) {
        int dSTR = attacker.stats.getAttack() - hurt.stats.getDefense();
        if (dSTR >= 12) {
            return (dSTR + 4) / 4;
        }
        if (dSTR >= 6 && dSTR <= 11) {
            return (dSTR + 6) / 4;
        }
        if (dSTR >= 1 && dSTR <= 5) {
            return (dSTR + 7) / 4;
        }
        if (dSTR >= -2 && dSTR <= 0) {
            return (dSTR + 8) / 4;
        }
        if (dSTR >= -7 && dSTR <= -3) {
            return (dSTR + 9) / 4;
        }
        if (dSTR >= -15 && dSTR <= -8) {
            return (dSTR + 0) / 4;
        }
        if (dSTR >= -21 && dSTR <= 16) {
            return (dSTR + 12) / 4;
        }
        if (dSTR <= -22) {
            return (dSTR + 13) / 4;
        }
        return 0;
    }

    public static int getMonsterBaseDamage(DigimonEntity monster) {
        int passive;
        ItemStack wepslot = monster.inventory.func_70301_a(0);
        int weapondmg = !wepslot.func_190926_b() && EnumUtils.isValidEnum(WeaponValues.WeaponTypes.class, (String)wepslot.func_77973_b().toString().toUpperCase()) ? WeaponValues.WeaponTypes.valueOf(wepslot.func_77973_b().toString().toUpperCase()).getDamage() : 3;
        float spiraladv = monster.setup.getDigimonTexture().equals("spiralblue") ? 0.5f : 0.0f;
        int n = passive = monster.setup.getPassive().equals("Scrappy") && monster.func_110143_aJ() <= monster.func_110138_aP() / 4.0f ? 2 : 1;
        if (monster.stats.getForm() == Form.FormTypes.BABY) {
            return (int)(5.0f + 5.0f * spiraladv) * passive;
        }
        if (monster.stats.getForm() == Form.FormTypes.INTRAINING) {
            return (int)(9.0f + 9.0f * spiraladv) * passive;
        }
        if (monster.stats.getForm() == Form.FormTypes.ROOKIE) {
            return (int)(13.0f + 13.0f * spiraladv) * passive;
        }
        if (monster.stats.getForm() == Form.FormTypes.CHAMPION) {
            return (int)(15.0f + 15.0f * spiraladv) * passive;
        }
        if (monster.stats.getForm() == Form.FormTypes.ULTIMATE) {
            return (int)(22.0f + 22.0f * spiraladv) * passive;
        }
        if (monster.stats.getForm() == Form.FormTypes.MEGA) {
            return (int)(38.0f + 38.0f * spiraladv) * passive;
        }
        return Math.round(((float)weapondmg + (float)weapondmg * spiraladv) * (float)passive);
    }

    public static float monsterpDIF(DigimonEntity attacker, DigimonEntity hurt) {
        double fraction = attacker.stats.getStrength() / hurt.stats.getVitality();
        int fractionValue = (int)(fraction * 10.0);
        int decimal = fractionValue % 10;
        double value = (double)decimal * 0.1;
        float ratio = (float)value;
        float cRatio = ratio - (float)(hurt.stats.getLevel() - attacker.stats.getLevel()) * 0.05f;
        float wRatio = cRatio + DigimobsBattleHandler.isCriticalHit(attacker, hurt);
        float qRatio = DigimobsBattleHandler.selectRandomValueLLAndUU(wRatio);
        return qRatio;
    }

    public static float isCriticalHit(DigimonEntity attacker, DigimonEntity hurt) {
        if (Tools.getRandomNumber(1, 100) <= attacker.stats.getLuck() - hurt.stats.getSpeed()) {
            if (attacker.func_70902_q() != null) {
                CommandChatHandler.sendChat((ICommandSource)attacker.func_70902_q(), attacker.func_184753_b(), "\u6402aCritical Hit!", new Object[0]);
            }
            return 1.0f;
        }
        return 0.0f;
    }

    public static float wRatioUpperLimit(float wRatio) {
        if (wRatio >= 0.0f && wRatio < 0.5f) {
            return wRatio + 0.5f;
        }
        if (wRatio >= 0.5f && wRatio < 0.7f) {
            return 1.0f;
        }
        if (wRatio >= 0.7f && wRatio < 1.2f) {
            return wRatio + 0.3f;
        }
        if ((double)wRatio >= 1.2 && wRatio < 1.5f) {
            return wRatio * 0.25f + wRatio;
        }
        if ((double)wRatio >= 1.5) {
            return wRatio + 0.375f;
        }
        return 0.0f;
    }

    public static float wRatioLowerLimit(float wRatio) {
        if (wRatio >= 0.0f && wRatio < 0.38f) {
            return 0.0f;
        }
        if (wRatio >= 0.38f && wRatio < 1.25f) {
            return wRatio * 1.0f - 0.0f;
        }
        if (wRatio >= 1.25f && wRatio < 1.51f) {
            return 1.0f;
        }
        if ((double)wRatio >= 1.51 && wRatio < 2.44f) {
            return wRatio * 1.0f - 0.0f;
        }
        if ((double)wRatio >= 2.44) {
            return wRatio - 0.375f;
        }
        return 0.0f;
    }

    public static float selectRandomValueLLAndUU(float wRatio) {
        Random rand = new Random();
        float random = DigimobsBattleHandler.wRatioLowerLimit(wRatio) + rand.nextFloat() * (DigimobsBattleHandler.wRatioUpperLimit(wRatio) - DigimobsBattleHandler.wRatioLowerLimit(wRatio));
        float finalvalue = 1.0f + rand.nextFloat() * 0.049999952f;
        if (random < 0.0f) {
            return 0.0f;
        }
        if (random > 3.25f) {
            return 3.25f * finalvalue;
        }
        return random * finalvalue;
    }

    public static float getAttributeAdvantage(DigimonEntity attacker, DigimonEntity defender) {
        if (attacker.stats.getAttribute() == AEF.AefTypes.DATA && defender.stats.getAttribute() == AEF.AefTypes.VACCINE) {
            return 0.3f;
        }
        if (attacker.stats.getAttribute() == AEF.AefTypes.VIRUS && defender.stats.getAttribute() == AEF.AefTypes.DATA) {
            return 0.3f;
        }
        if (attacker.stats.getAttribute() == AEF.AefTypes.VACCINE && defender.stats.getAttribute() == AEF.AefTypes.VIRUS) {
            return 0.3f;
        }
        if (attacker.stats.getAttribute() == AEF.AefTypes.DATA && defender.stats.getAttribute() == AEF.AefTypes.VIRUS) {
            return -0.3f;
        }
        if (attacker.stats.getAttribute() == AEF.AefTypes.VIRUS && defender.stats.getAttribute() == AEF.AefTypes.VACCINE) {
            return -0.3f;
        }
        if (attacker.stats.getAttribute() == AEF.AefTypes.VACCINE && defender.stats.getAttribute() == AEF.AefTypes.DATA) {
            return -0.3f;
        }
        return 0.0f;
    }

    public static float getFieldAdvantage(DigimonEntity attacker, DigimonEntity defender) {
        if (attacker.stats.getField() == AEF.AefTypes.DRAGONSROAR && defender.stats.getField() == AEF.AefTypes.METALEMPIRE) {
            return 0.25f;
        }
        if (attacker.stats.getField() == AEF.AefTypes.NATURESPIRITS && defender.stats.getField() == AEF.AefTypes.WINDGUARDIANS) {
            return 0.25f;
        }
        if (attacker.stats.getField() == AEF.AefTypes.WINDGUARDIANS && defender.stats.getField() == AEF.AefTypes.JUNGLETROOPERS) {
            return 0.25f;
        }
        if (attacker.stats.getField() == AEF.AefTypes.JUNGLETROOPERS && defender.stats.getField() == AEF.AefTypes.DEEPSAVERS) {
            return 0.25f;
        }
        if (attacker.stats.getField() == AEF.AefTypes.DEEPSAVERS && defender.stats.getField() == AEF.AefTypes.DRAGONSROAR) {
            return 0.25f;
        }
        if (attacker.stats.getField() == AEF.AefTypes.METALEMPIRE && defender.stats.getField() == AEF.AefTypes.NATURESPIRITS) {
            return 0.25f;
        }
        if (attacker.stats.getField() == AEF.AefTypes.VIRUSBUSTERS && defender.stats.getField() == AEF.AefTypes.NIGHTMARESOLDIERS) {
            return 0.5f;
        }
        if (attacker.stats.getField() == AEF.AefTypes.NIGHTMARESOLDIERS && defender.stats.getField() == AEF.AefTypes.VIRUSBUSTERS) {
            return 0.5f;
        }
        return 0.0f;
    }

    public static float getFormAdvantage(DigimonEntity attacker, DigimonEntity defender) {
        int intatkform = 0;
        int intdefform = 0;
        if (attacker.stats.getForm() == Form.FormTypes.BABY) {
            intatkform = 1;
        }
        if (defender.stats.getForm() == Form.FormTypes.BABY) {
            intdefform = 1;
        }
        if (attacker.stats.getForm() == Form.FormTypes.INTRAINING) {
            intatkform = 2;
        }
        if (defender.stats.getForm() == Form.FormTypes.INTRAINING) {
            intdefform = 2;
        }
        if (attacker.stats.getForm() == Form.FormTypes.ROOKIE) {
            intatkform = 3;
        }
        if (defender.stats.getForm() == Form.FormTypes.ROOKIE) {
            intdefform = 3;
        }
        if (attacker.stats.getForm() == Form.FormTypes.CHAMPION) {
            intatkform = 4;
        }
        if (defender.stats.getForm() == Form.FormTypes.CHAMPION) {
            intdefform = 4;
        }
        if (attacker.stats.getForm() == Form.FormTypes.ULTIMATE) {
            intatkform = 5;
        }
        if (defender.stats.getForm() == Form.FormTypes.ULTIMATE) {
            intdefform = 5;
        }
        if (attacker.stats.getForm() == Form.FormTypes.MEGA) {
            intatkform = 6;
        }
        if (defender.stats.getForm() == Form.FormTypes.MEGA) {
            intdefform = 6;
        }
        return (intatkform - intdefform) / 10;
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof DigimonEntity) {
            DigimonEntity dead = (DigimonEntity)event.getEntity();
            if (Tools.getRandomNumber(1, 10) == 1 && event.getSource().func_76364_f() instanceof LivingEntity) {
                event.setCanceled(true);
                dead.func_70606_j(1.0f);
                dead.digivolutions.checkForDeathEvolve(dead, (LivingEntity)event.getSource().func_76364_f(), "");
                return;
            }
            if (!dead.getDigimon().func_74767_n("pvp")) {
                if (dead.func_70909_n() && !dead.digivolutions.getEggForm().isEmpty() && !dead.getEvolutions().func_74764_b("becomeEgg") || dead.setup.getPassive().equals("Nestbound") && !dead.digivolutions.getEggForm().isEmpty()) {
                    DigimobsBattleHandler.revertToEgg(dead);
                }
                if (event.getSource().func_76364_f() instanceof PlayerEntity) {
                    PlayerEntity playerEntity = (PlayerEntity)event.getSource().func_76364_f();
                }
                if (event.getSource().func_76364_f() instanceof DigimonEntity) {
                    DigimonEntity attacker = (DigimonEntity)event.getSource().func_76364_f();
                    if (!attacker.getDigimon().func_74767_n("pvp")) {
                        if (attacker.stats.getLevel() < 100) {
                            attacker.stats.determineLevelUp(attacker, dead);
                        }
                        if (attacker.func_70909_n() && attacker.stats.getWeight() <= 0) {
                            attacker.convo.hungryConvo();
                        }
                    } else if (attacker.func_70902_q() != null) {
                        CommandChatHandler.sendChat((ICommandSource)attacker.func_70902_q(), attacker.func_184753_b(), "\u6402C" + attacker.setup.getTrueName() + " is in PVP mode! No exp or items gained!", new Object[0]);
                    }
                    if (attacker.func_70909_n() && !dead.func_70909_n() && dead.getDigimon().func_74764_b("usedspecial")) {
                        DigimobsBattleHandler.learnAttack(attacker, dead.getDigimon().func_74779_i("usedspecial"));
                    }
                }
            } else {
                if (dead.func_70902_q() != null) {
                    CommandChatHandler.sendChat((ICommandSource)dead.func_70902_q(), dead.func_184753_b(), "\u6402C" + dead.setup.getTrueName() + " was returned to its v-pet.", new Object[0]);
                }
                dead.func_70606_j(1.0f);
            }
        }
    }

    private static void learnAttack(DigimonEntity attacker, String attack) {
        if (Tools.getRandomNumber(1, 10) == 1) {
            for (int i = 0; i < attacker.getSpecials().func_186856_d() - 1; ++i) {
                if (!attacker.getSpecials().func_74779_i("special" + i).equals(attack)) continue;
                return;
            }
            if (attacker.func_70902_q() != null) {
                CommandChatHandler.sendChat((ICommandSource)attacker.func_70902_q(), attacker.func_184753_b(), "\u6402a" + attacker.setup.getTrueName() + " learned a new attack!", new Object[0]);
            }
            attacker.getSpecials().func_74778_a("special" + attacker.getSpecials().func_186856_d(), attack);
        }
    }

    private static void revertToEgg(DigimonEntity digi) {
        EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("digimobs", digi.digivolutions.getEggForm().toLowerCase()));
        DigimonEntity egg = (DigimonEntity)type.func_200721_a(digi.field_70170_p);
        if (digi.func_70909_n()) {
            egg.func_70903_f(digi.func_70909_n());
            egg.func_184754_b(digi.func_184753_b());
        }
        egg.setStats(digi.getStats());
        egg.setEvolutions(digi.getEvolutions());
        egg.setSpecials(digi.getSpecials());
        egg.stats.setLevel(digi.stats.getLevel() / 4);
        if (egg.stats.getLevel() <= 0) {
            egg.stats.setLevel(1);
        }
        egg.func_70606_j(egg.stats.getSpeciesStatusHealth() + egg.stats.getPersonalityStatusHealth());
        egg.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)(egg.stats.getSpeciesStatusHealth() + egg.stats.getPersonalityStatusHealth() + egg.getStats().func_74762_e("BonusHealth") + egg.stats.getHealthBonusFromEquipment()));
        egg.stats.setEnergy(1);
        egg.stats.setMaxEnergy(egg.stats.getSpeciesStatusEnergy() + egg.stats.getPersonalityStatusEnergy());
        egg.stats.setAttack(egg.stats.getSpeciesStatusAttack() + egg.stats.getPersonalityStatusAttack());
        egg.stats.setDefense(egg.stats.getSpeciesStatusDefense() + egg.stats.getPersonalityStatusDefense());
        egg.stats.setSpecialAttack(egg.stats.getSpeciesStatusSAttack() + egg.stats.getPersonalityStatusSAttack());
        egg.stats.setSpecialDefense(egg.stats.getSpeciesStatusSDefense() + egg.stats.getPersonalityStatusSDefense());
        egg.stats.setSpeed(egg.stats.getSpeciesStatusSpeed() + egg.stats.getPersonalityStatusSpeed());
        egg.stats.setLuck(egg.stats.getSpeciesStatusLuck() + egg.stats.getPersonalityStatusLuck());
        egg.stats.setDigimonAge(1);
        egg.setup.setNickname(digi.setup.getNickname());
        egg.setup.setPersonality(digi.setup.getPersonality());
        egg.setup.setColor(digi.setup.getColor());
        egg.setup.setScale(digi.setup.getScale());
        egg.setup.setPassive(digi.setup.getPassive());
        egg.setup.setSpecialTexture(digi.setup.getSpecialTexture());
        egg.vpetcolor = digi.vpetcolor;
        egg.func_70691_i(egg.func_110138_aP());
        egg.func_225653_b_(digi.func_226277_ct_(), digi.func_226278_cu_(), digi.func_226281_cx_() - 1.0);
        digi.field_70170_p.func_217376_c((Entity)egg);
        if (digi.getEvolutions().func_74764_b("jogresspartner")) {
            EntityType jogtype = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("digimobs", digi.getEvolutions().func_74775_l("jogresspartner").func_74775_l("Digimon").func_74779_i("Name").toLowerCase()));
            DigimonEntity jogdegen = (DigimonEntity)jogtype.func_200721_a(digi.field_70170_p);
            jogdegen.func_70020_e(digi.getEvolutions().func_74775_l("jogresspartner"));
            jogdegen.getDigimon().func_82580_o("digivolvingstart");
            jogdegen.getDigimon().func_82580_o("todelete");
            jogdegen.getDigimon().func_82580_o("evolutiontype");
            jogdegen.func_226275_c_(digi.func_226277_ct_());
            jogdegen.func_226283_e_(digi.func_226278_cu_());
            jogdegen.func_226285_f_(digi.func_226281_cx_());
            digi.getEvolutions().func_82580_o("jogresspartner");
            DigimobsBattleHandler.revertToEgg(jogdegen);
        }
        digi.func_70106_y();
    }
}

