/*
 * Decompiled with CFR 0.152.
 */
package mod.cyan.digimobs.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import mod.cyan.digimobs.util.Vector3;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;

public class Matrix3 {
    public Vector3[] rows = new Vector3[3];
    int size = 3;
    Vector3[] pointSet;

    private static boolean containsOrigin(List<Vector3> points) {
        int index = 0;
        Vector3 base = points.get(index);
        double dist = Double.MAX_VALUE;
        for (int i = 0; i < points.size(); ++i) {
            double d;
            Vector3 v = points.get(i);
            if (v == null || !((d = v.magSq()) < dist)) continue;
            base = points.get(i);
            dist = d;
            index = i;
        }
        Vector3 mid = Vector3.findMidPoint(points);
        points.remove(index);
        boolean ret = false;
        for (Vector3 v : points) {
            if (v == null) continue;
            double d = v.dot(base);
            double d1 = v.dot(mid);
            if (!(d <= 0.0) || !(d1 <= d) || Math.signum(d) != Math.signum(d1)) continue;
            ret = true;
            return true;
        }
        return ret;
    }

    public static AxisAlignedBB copyAndChange(AxisAlignedBB box, int index, double value) {
        double x1 = box.field_72340_a;
        double x2 = box.field_72336_d;
        double y1 = box.field_72338_b;
        double y2 = box.field_72337_e;
        double z1 = box.field_72339_c;
        double z2 = box.field_72334_f;
        if (index == 0) {
            x1 = value;
        }
        if (index == 1) {
            y1 = value;
        }
        if (index == 2) {
            z1 = value;
        }
        if (index == 3) {
            x2 = value;
        }
        if (index == 4) {
            y2 = value;
        }
        if (index == 5) {
            z2 = value;
        }
        return new AxisAlignedBB(x1, y1, z1, x2, y2, z2);
    }

    public static boolean doCollision(List<AxisAlignedBB> aabbs, AxisAlignedBB entityBox, Entity e, double yShift, Vector3 diffs, Vector3 temp1) {
        double minX = entityBox.field_72340_a;
        double minY = entityBox.field_72338_b;
        double minZ = entityBox.field_72339_c;
        double maxX = entityBox.field_72336_d;
        double maxY = entityBox.field_72337_e;
        double maxZ = entityBox.field_72334_f;
        double factor = 0.75;
        Vector3d motion = e.func_213322_ci();
        double dx = Math.max(maxX - minX, 0.5) / 0.75 + motion.field_72450_a;
        double dz = Math.max(maxZ - minZ, 0.5) / 0.75 + motion.field_72449_c;
        boolean collide = false;
        AxisAlignedBB boundingBox = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
        Matrix3.mergeAABBs(aabbs, maxX - minX, maxY - minY, maxZ - minZ);
        double yTop = Math.min((double)e.field_70138_W + e.func_226278_cu_() + yShift, maxY);
        boolean floor = false;
        boolean ceiling = false;
        double yMaxFloor = minY;
        for (AxisAlignedBB aabb : aabbs) {
            double r;
            boolean vert;
            dx = 10000.0;
            dz = 10000.0;
            boolean thisFloor = false;
            boolean thisCieling = false;
            boolean collidesX = maxZ <= aabb.field_72334_f && maxZ >= aabb.field_72339_c || minZ <= aabb.field_72334_f && minZ >= aabb.field_72339_c || minZ <= aabb.field_72339_c && maxZ >= aabb.field_72334_f;
            boolean collidesY = minY >= aabb.field_72338_b && minY <= aabb.field_72337_e || maxY <= aabb.field_72337_e && maxY >= aabb.field_72338_b || minY <= aabb.field_72338_b && maxY >= aabb.field_72337_e;
            boolean collidesZ = maxX <= aabb.field_72336_d && maxX >= aabb.field_72340_a || minX <= aabb.field_72336_d && minX >= aabb.field_72340_a || minX <= aabb.field_72340_a && maxX >= aabb.field_72336_d;
            collidesZ = collidesZ && (collidesX || collidesY);
            boolean bl = collidesX = collidesX && (collidesZ || collidesY);
            if (collidesX && collidesZ && yTop >= aabb.field_72337_e && boundingBox.field_72338_b - (double)e.field_70138_W - yShift <= aabb.field_72337_e - diffs.y) {
                if (!floor) {
                    temp1.y = Math.max(aabb.field_72337_e - boundingBox.field_72338_b, temp1.y);
                }
                floor = true;
                boolean bl2 = thisFloor = aabb.field_72337_e >= yMaxFloor;
                if (thisFloor) {
                    yMaxFloor = aabb.field_72337_e;
                }
            }
            if (collidesX && collidesZ && boundingBox.field_72337_e >= aabb.field_72338_b && boundingBox.field_72338_b < aabb.field_72338_b) {
                if (!floor && !ceiling) {
                    double dy = aabb.field_72338_b - boundingBox.field_72337_e - diffs.y;
                    temp1.y = Math.min(dy, temp1.y);
                }
                thisCieling = !thisFloor && !floor;
                ceiling = true;
            }
            boolean bl3 = vert = thisFloor || thisCieling;
            if (collidesX && !vert && collidesY && boundingBox.field_72336_d >= aabb.field_72336_d && boundingBox.field_72340_a <= aabb.field_72336_d) {
                r = Math.max(aabb.field_72336_d - boundingBox.field_72340_a, temp1.x);
                dx = Math.min(dx, r);
            }
            if (collidesX && !vert && collidesY && boundingBox.field_72336_d >= aabb.field_72340_a && boundingBox.field_72340_a < aabb.field_72340_a) {
                r = Math.min(aabb.field_72340_a - boundingBox.field_72336_d, temp1.x);
                dx = Math.min(dx, r);
            }
            if (collidesZ && !vert && collidesY && boundingBox.field_72334_f >= aabb.field_72334_f && boundingBox.field_72339_c <= aabb.field_72334_f) {
                r = Math.max(aabb.field_72334_f - boundingBox.field_72339_c, temp1.z);
                dz = Math.min(dz, r);
            }
            if (collidesZ && !vert && collidesY && boundingBox.field_72334_f >= aabb.field_72339_c && boundingBox.field_72339_c < aabb.field_72339_c) {
                r = Math.min(aabb.field_72339_c - boundingBox.field_72334_f, temp1.z);
                dz = Math.min(dz, r);
            }
            if (Math.abs(dx) > Math.abs(dz) && dx < 1000.0 || dx == 10000.0 && dz < 1000.0) {
                temp1.z = dz;
                continue;
            }
            if (!(dx < 1000.0)) continue;
            temp1.x = dx;
        }
        return false;
    }

    public static void expandAABBs(List<AxisAlignedBB> aabbs, AxisAlignedBB reference) {
        double mx = reference.field_72340_a + (reference.field_72336_d - reference.field_72340_a) / 2.0;
        double my = reference.field_72338_b + (reference.field_72337_e - reference.field_72338_b) / 2.0;
        double mz = reference.field_72339_c + (reference.field_72334_f - reference.field_72339_c) / 2.0;
        int to = 100;
        int xMax = (int)(mx + 100.0);
        int xMin = (int)(mx - 100.0);
        int yMax = (int)(my + 100.0);
        int yMin = (int)(my - 100.0);
        int zMax = (int)(mz + 100.0);
        int zMin = (int)(mz - 100.0);
        for (int i = 0; i < aabbs.size(); ++i) {
            AxisAlignedBB box = aabbs.get(i);
            boolean yMinus = box.field_72338_b - 100.0 <= reference.field_72338_b && reference.field_72338_b >= box.field_72338_b;
            boolean yPlus = box.field_72337_e + 100.0 >= reference.field_72337_e && reference.field_72337_e <= box.field_72337_e;
            double y0 = yMinus && !yPlus ? (double)yMin : box.field_72338_b;
            double y1 = yPlus && !yMinus ? (double)yMax : box.field_72337_e;
            boolean xMinus = box.field_72340_a - 100.0 <= reference.field_72340_a && reference.field_72340_a >= box.field_72340_a;
            boolean xPlus = box.field_72336_d + 100.0 >= reference.field_72336_d && reference.field_72336_d <= box.field_72336_d;
            double x0 = xMinus && !xPlus ? (double)xMin : box.field_72340_a;
            double x1 = xPlus && !xMinus ? (double)xMax : box.field_72336_d;
            boolean zMinus = box.field_72339_c - 100.0 <= reference.field_72339_c && reference.field_72339_c >= box.field_72339_c;
            boolean zPlus = box.field_72334_f + 100.0 >= reference.field_72334_f && reference.field_72334_f <= box.field_72334_f;
            double z0 = zMinus && !zPlus ? (double)zMin : box.field_72339_c;
            double z1 = zPlus && !zMinus ? (double)zMax : box.field_72334_f;
            aabbs.set(i, new AxisAlignedBB(x0, y0, z0, x1, y1, z1));
        }
    }

    public static AxisAlignedBB getAABB(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static double matrixDet(Matrix3 Matrix) {
        double det = 0.0;
        int n = Matrix.size;
        if (n == 2) {
            det = Matrix.get(0, 0) * Matrix.get(1, 1) - Matrix.get(1, 0) * Matrix.get(0, 1);
        } else {
            for (int i = 0; i < n; ++i) {
                det += Math.pow(-1.0, i) * Matrix.get(0, i) * Matrix3.matrixDet(Matrix3.matrixMinor(Matrix, 0, i));
            }
        }
        return det;
    }

    public static Matrix3 matrixMinor(Matrix3 input, int i, int j) {
        int k;
        double[][] Matrix = input.toArray();
        int n = Matrix.length;
        int m = Matrix[0].length;
        Double[][] TempMinor = new Double[m - 1][n - 1];
        ArrayList row = new ArrayList();
        for (k = 0; k < n; ++k) {
            if (k == i) continue;
            row.add(new ArrayList());
            for (int l = 0; l < m; ++l) {
                if (l == j) continue;
                ((ArrayList)row.get(k - (k > i ? 1 : 0))).add(Matrix[k][l]);
            }
        }
        for (k = 0; k < n - 1; ++k) {
            TempMinor[k] = (Double[])((ArrayList)row.get(k)).toArray((Object[])new Double[0]);
        }
        Matrix3 Minor = new Matrix3();
        Minor.size = n - 1;
        for (int i1 = 0; i1 < n - 1; ++i1) {
            for (int l = 0; l < m - 1; ++l) {
                Minor.set(i1, l, TempMinor[i1][l]);
            }
        }
        return Minor;
    }

    public static Matrix3 matrixTranspose(Matrix3 Matrix) {
        Matrix3 MatrixT = new Matrix3();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                MatrixT.set(i, j, Matrix.get(j, i));
            }
        }
        return MatrixT;
    }

    public static void mergeAABBs(List<AxisAlignedBB> aabbs, double dx, double dy, double dz) {
        AxisAlignedBB b2;
        int j;
        AxisAlignedBB b1;
        int i;
        Comparator comparator = (arg0, arg1) -> {
            int minX0 = (int)(arg0.field_72340_a * 16.0);
            int minY0 = (int)(arg0.field_72338_b * 16.0);
            int minZ0 = (int)(arg0.field_72339_c * 16.0);
            int minX1 = (int)(arg1.field_72340_a * 16.0);
            int minY1 = (int)(arg1.field_72338_b * 16.0);
            int minZ1 = (int)(arg1.field_72339_c * 16.0);
            return minX0 == minX1 ? (minZ0 == minZ1 ? minY0 - minY1 : minZ0 - minZ1) : minX0 - minX1;
        };
        AxisAlignedBB[] boxes = aabbs.toArray(new AxisAlignedBB[aabbs.size()]);
        aabbs.clear();
        Arrays.sort(boxes, comparator);
        for (i = 0; i < boxes.length; ++i) {
            b1 = boxes[i];
            if (b1 == null) continue;
            for (j = 0; j < boxes.length; ++j) {
                b2 = boxes[j];
                if (i == j || b2 == null || !(Math.abs(b2.field_72337_e - b1.field_72337_e) <= dy) || !(Math.abs(b2.field_72338_b - b1.field_72338_b) <= dy) || !(Math.abs(b2.field_72336_d - b1.field_72336_d) <= dx) || !(Math.abs(b2.field_72340_a - b1.field_72340_a) <= dx) || !(Math.abs(b2.field_72339_c - b1.field_72334_f) <= dz)) continue;
                boxes[i] = b1 = b1.func_111270_a(b2);
                boxes[j] = null;
            }
        }
        for (i = 0; i < boxes.length; ++i) {
            b1 = boxes[i];
            if (b1 == null) continue;
            for (j = 0; j < boxes.length; ++j) {
                b2 = boxes[j];
                if (i == j || b2 == null || !(Math.abs(b2.field_72337_e - b1.field_72337_e) <= dy) || !(Math.abs(b2.field_72338_b - b1.field_72338_b) <= dy) || !(Math.abs(b2.field_72334_f - b1.field_72334_f) <= dz) || !(Math.abs(b2.field_72339_c - b1.field_72339_c) <= dz) || !(Math.abs(b2.field_72340_a - b1.field_72336_d) <= dx)) continue;
                boxes[i] = b1 = b1.func_111270_a(b2);
                boxes[j] = null;
            }
        }
        for (i = 0; i < boxes.length; ++i) {
            b1 = boxes[i];
            if (b1 == null) continue;
            for (j = 0; j < boxes.length; ++j) {
                b2 = boxes[j];
                if (i == j || b2 == null || !(Math.abs(b2.field_72336_d - b1.field_72336_d) <= dx) || !(Math.abs(b2.field_72340_a - b1.field_72340_a) <= dx) || !(Math.abs(b2.field_72334_f - b1.field_72334_f) <= dz) || !(Math.abs(b2.field_72339_c - b1.field_72339_c) <= dz) || !(Math.abs(b2.field_72338_b - b1.field_72337_e) <= dy)) continue;
                boxes[i] = b1 = b1.func_111270_a(b2);
                boxes[j] = null;
            }
        }
        for (i = 0; i < boxes.length; ++i) {
            b1 = boxes[i];
            if (b1 == null) continue;
            for (j = 0; j < boxes.length; ++j) {
                b2 = boxes[j];
                if (i == j || b2 == null || !(b2.field_72336_d <= b1.field_72336_d) || !(b2.field_72337_e <= b1.field_72337_e) || !(b2.field_72334_f <= b1.field_72334_f) || !(b2.field_72340_a >= b1.field_72340_a) || !(b2.field_72338_b >= b1.field_72338_b) || !(b2.field_72339_c >= b1.field_72339_c)) continue;
                boxes[i] = b1;
                boxes[j] = null;
            }
        }
        for (AxisAlignedBB b : boxes) {
            if (b == null) continue;
            aabbs.add(b);
        }
    }

    static List<Vector3> toMesh(ArrayList<Matrix3> boxes) {
        ArrayList<Vector3> ret = new ArrayList<Vector3>();
        for (Matrix3 box : boxes) {
            Vector3 vc = box.boxCentre();
            for (Vector3 v : box.corners(vc)) {
                boolean has = false;
                for (Vector3 v1 : ret) {
                    if (!v1.equals(v)) continue;
                    has = true;
                    break;
                }
                if (has) continue;
                ret.add(v);
            }
        }
        return ret;
    }

    public Matrix3() {
        this.rows[0] = Vector3.getNewVector();
        this.rows[1] = Vector3.getNewVector();
        this.rows[2] = Vector3.getNewVector();
    }

    public Matrix3(double d, double e, double f) {
        this();
        this.rows[1].set(d, e, f);
    }

    public Matrix3(double[] a, double[] b, double[] c) {
        this();
        this.rows[0].set(a[0], a[1], a[2]);
        this.rows[1].set(b[0], b[1], b[2]);
        this.rows[2].set(c[0], c[1], c[2]);
    }

    public Matrix3(Vector3 a, Vector3 b) {
        this(a, b, Vector3.empty);
    }

    public Matrix3(Vector3 a, Vector3 b, Vector3 c) {
        this.rows[0] = a.copy();
        this.rows[1] = b.copy();
        this.rows[2] = c.copy();
    }

    public Matrix3 addOffsetTo(Vector3 pushOffset) {
        this.rows[0].addTo(pushOffset);
        this.rows[1].addTo(pushOffset);
        return this;
    }

    public Vector3 boxCentre() {
        Vector3 mid = Vector3.getNewVector();
        Vector3 temp1 = this.boxMax().copy();
        Vector3 temp2 = this.boxMax().copy();
        mid.set(temp2.subtractFrom(temp1.subtractFrom(this.boxMin()).scalarMultBy(0.5)));
        return mid;
    }

    public Vector3 boxMax() {
        return this.rows[1];
    }

    public Vector3 boxMin() {
        return this.rows[0];
    }

    public Vector3 boxRotation() {
        return this.rows[2];
    }

    public Matrix3 clear() {
        this.rows[0].clear();
        this.rows[1].clear();
        this.rows[2].clear();
        return this;
    }

    public Matrix3 copy() {
        Matrix3 ret = new Matrix3();
        ret.rows[0].set(this.rows[0]);
        ret.rows[1].set(this.rows[1]);
        ret.rows[2].set(this.rows[2]);
        return ret;
    }

    public List<Vector3> corners(boolean mulPose) {
        ArrayList<Vector3> corners = new ArrayList<Vector3>();
        for (int i = 0; i < 8; ++i) {
            corners.add(Vector3.getNewVector());
        }
        ((Vector3)corners.get(0)).set(this.boxMin());
        ((Vector3)corners.get(1)).set(this.boxMax());
        ((Vector3)corners.get(2)).set(this.boxMin().x, this.boxMin().y, this.boxMax().z);
        ((Vector3)corners.get(3)).set(this.boxMin().x, this.boxMax().y, this.boxMin().z);
        ((Vector3)corners.get(4)).set(this.boxMax().x, this.boxMin().y, this.boxMin().z);
        ((Vector3)corners.get(5)).set(this.boxMin().x, this.boxMax().y, this.boxMax().z);
        ((Vector3)corners.get(6)).set(this.boxMax().x, this.boxMin().y, this.boxMax().z);
        ((Vector3)corners.get(7)).set(this.boxMax().x, this.boxMax().y, this.boxMin().z);
        Vector3 mid = mulPose && !this.boxRotation().isEmpty() ? this.boxCentre() : null;
        if (!this.boxRotation().isEmpty() && mid != null) {
            Vector3 temp = Vector3.getNewVector();
            Vector3 temp2 = Vector3.getNewVector();
            for (int j = 0; j < 8; ++j) {
                ((Vector3)corners.get(j)).subtractFrom(mid);
                temp2.clear();
                temp.clear();
                ((Vector3)corners.get(j)).set(((Vector3)corners.get(j)).mulPoseAboutAngles(this.boxRotation().y, this.boxRotation().z, temp2, temp));
                ((Vector3)corners.get(j)).addTo(mid);
            }
        }
        return corners;
    }

    public Vector3[] corners(Vector3 mid) {
        return this.corners(mid != null).toArray(new Vector3[8]);
    }

    private List<Vector3> diff(List<Vector3> cornersA, List<Vector3> cornersB) {
        ArrayList<Vector3> ret = new ArrayList<Vector3>();
        Vector3 c = Vector3.getNewVector();
        if (this.pointSet == null) {
            this.pointSet = new Vector3[100];
        }
        int n = 0;
        for (Vector3 a : cornersA) {
            for (Vector3 b : cornersB) {
                c.set(a).subtractFrom(b);
                this.pointSet[n++] = c.copy();
            }
        }
        for (int i = 0; i < n; ++i) {
            Vector3 v = this.pointSet[i];
            ret.add(v);
            this.pointSet[i] = null;
        }
        return ret;
    }

    public boolean doCollision(Vector3 boxVelocity, Entity e) {
        if (e == null) {
            return false;
        }
        Vector3 ent = Vector3.getNewVector();
        ent.set(e);
        this.corners(true);
        Matrix3 box = new Matrix3();
        box.set(e.func_174813_aQ());
        boolean hit = box.intersects(this);
        return hit;
    }

    public Vector3 get(int i) {
        assert (i < 3);
        return this.rows[i];
    }

    public double get(int i, int j) {
        assert (i < 3);
        return this.rows[i].get(j);
    }

    public AxisAlignedBB getBoundingBox() {
        Vector3 v1 = this.boxCentre();
        Vector3[] corners = this.corners(v1);
        double minX = Double.MAX_VALUE;
        double minZ = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double maxZ = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        for (Vector3 v : corners) {
            if (v.x > maxX) {
                maxX = v.x;
            }
            if (v.y > maxY) {
                maxY = v.y;
            }
            if (v.z > maxZ) {
                maxZ = v.z;
            }
            if (v.x < minX) {
                minX = v.x;
            }
            if (v.y < minY) {
                minY = v.y;
            }
            if (!(v.z < minZ)) continue;
            minZ = v.z;
        }
        return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public Matrix3 getOctant(int octant) {
        Matrix3 ret = this.copy();
        switch (octant) {
            case 0: {
                this.rows[0].x += this.rows[1].x / 2.0;
                this.rows[0].y += this.rows[1].y / 2.0;
                this.rows[0].z += this.rows[1].z / 2.0;
                return ret;
            }
            case 1: {
                this.rows[1].x -= this.rows[1].x / 2.0;
                this.rows[0].y += this.rows[1].y / 2.0;
                this.rows[0].z += this.rows[1].z / 2.0;
                return ret;
            }
            case 2: {
                this.rows[1].x -= this.rows[1].x / 2.0;
                this.rows[1].y -= this.rows[1].y / 2.0;
                this.rows[0].z += this.rows[1].z / 2.0;
                return ret;
            }
            case 3: {
                this.rows[0].x += this.rows[1].x / 2.0;
                this.rows[1].y -= this.rows[1].y / 2.0;
                this.rows[0].z += this.rows[1].z / 2.0;
                return ret;
            }
            case 4: {
                this.rows[0].x += this.rows[1].x / 2.0;
                this.rows[0].y += this.rows[1].y / 2.0;
                this.rows[1].z -= this.rows[1].z / 2.0;
                return ret;
            }
            case 5: {
                this.rows[1].x -= this.rows[1].x / 2.0;
                this.rows[0].y += this.rows[1].y / 2.0;
                this.rows[1].z -= this.rows[1].z / 2.0;
                return ret;
            }
            case 6: {
                this.rows[1].x -= this.rows[1].x / 2.0;
                this.rows[1].y -= this.rows[1].y / 2.0;
                this.rows[1].z -= this.rows[1].z / 2.0;
                return ret;
            }
            case 7: {
                this.rows[0].x += this.rows[1].x / 2.0;
                this.rows[1].y -= this.rows[1].y / 2.0;
                this.rows[1].z -= this.rows[1].z / 2.0;
                return ret;
            }
        }
        return ret;
    }

    public boolean intersects(List<Vector3> mesh) {
        ArrayList<Vector3> cornersA = new ArrayList<Vector3>();
        Vector3 v1 = this.boxCentre();
        for (Vector3 v : this.corners(v1)) {
            cornersA.add(v);
        }
        List<Vector3> diffs = this.diff(cornersA, mesh);
        boolean temp = Matrix3.containsOrigin(diffs);
        return temp;
    }

    public boolean intersects(Matrix3 b) {
        ArrayList<Vector3> cornersB = new ArrayList<Vector3>();
        Vector3 v1 = this.boxCentre();
        for (Vector3 v : b.corners(v1)) {
            cornersB.add(v);
        }
        return this.intersects(cornersB);
    }

    public boolean isInMaterial(IBlockReader world, Vector3 location, Vector3 offset, Material m) {
        boolean ret = false;
        Vector3 ent = location;
        Vector3[] corners = this.corners(this.boxCentre());
        Vector3 temp = Vector3.getNewVector();
        Vector3 dir = Vector3.getNewVector();
        for (int i = 0; i < 8; ++i) {
            Vector3 v = corners[i];
            dir.set(v);
            temp.set(dir.addTo(ent).addTo(offset));
            if (temp.getBlockMaterial(world) == m) {
                ret = true;
                break;
            }
            if (i % 2 != 0) continue;
            temp.addTo(0.0, 0.01, 0.0);
            if (temp.getBlockMaterial(world) != m) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public Matrix3 resizeBox(double x, double y, double z) {
        Matrix3 ret = this.copy();
        ret.boxMin().x -= x;
        ret.boxMin().y -= y;
        ret.boxMin().z -= z;
        ret.boxMax().x += x;
        ret.boxMax().y += y;
        ret.boxMax().z += z;
        return ret;
    }

    public void set(AxisAlignedBB aabb) {
        this.rows[0].x = aabb.field_72340_a;
        this.rows[0].y = aabb.field_72338_b;
        this.rows[0].z = aabb.field_72339_c;
        this.rows[1].x = aabb.field_72336_d;
        this.rows[1].y = aabb.field_72337_e;
        this.rows[1].z = aabb.field_72334_f;
        this.rows[2].clear();
    }

    public void set(int i, int j, double k) {
        this.rows[i].set(j, k);
    }

    public Matrix3 set(int i, Vector3 j) {
        assert (i < 3);
        this.rows[i] = j;
        return this;
    }

    public void set(Matrix3 box) {
        this.rows[0].set(box.rows[0]);
        this.rows[1].set(box.rows[1]);
        this.rows[2].set(box.rows[2]);
    }

    public Vector3[][] splitBox() {
        Vector3 v1 = this.boxCentre();
        Vector3[] corners = this.corners(v1);
        double dx = this.boxMax().x - this.boxMin().x;
        double dz = this.boxMax().z - this.boxMin().z;
        dx = Math.abs(dx);
        dz = Math.abs(dz);
        if (dx <= 1.0 && dz <= 1.0 || dx < 0.1 || dz < 0.1) {
            return new Vector3[][]{corners};
        }
        if (dz > 2.0 * (dx = Math.max(dx, 1.0))) {
            int num = (int)(dz / dx);
            Vector3[][] ret = new Vector3[num][8];
            Vector3 min1 = corners[0];
            Vector3 max1 = corners[2];
            Vector3 dir1 = max1.subtract(min1).scalarMultBy(1.0 / (double)num);
            Vector3 min2 = corners[3];
            Vector3 max2 = corners[5];
            Vector3 dir2 = max2.subtract(min2).scalarMultBy(1.0 / (double)num);
            Vector3 min3 = corners[7];
            Vector3 max3 = corners[1];
            Vector3 dir3 = max3.subtract(min3).scalarMultBy(1.0 / (double)num);
            Vector3 min4 = corners[4];
            Vector3 max4 = corners[6];
            Vector3 dir4 = max4.subtract(min4).scalarMultBy(1.0 / (double)num);
            for (int i = 0; i < num; ++i) {
                ret[i][0] = dir1.scalarMult(i).addTo(min1);
                ret[i][1] = dir2.scalarMult(i).addTo(min2);
                ret[i][2] = dir3.scalarMult(i).addTo(min3);
                ret[i][3] = dir4.scalarMult(i).addTo(min4);
                ret[i][4] = dir1.scalarMult(i + 1).addTo(min1);
                ret[i][5] = dir2.scalarMult(i + 1).addTo(min2);
                ret[i][6] = dir3.scalarMult(i + 1).addTo(min3);
                ret[i][7] = dir4.scalarMult(i + 1).addTo(min4);
            }
            return ret;
        }
        return new Vector3[][]{corners};
    }

    public double[][] toArray() {
        return new double[][]{{this.rows[0].x, this.rows[0].y, this.rows[0].z}, {this.rows[1].x, this.rows[1].y, this.rows[1].z}, {this.rows[2].x, this.rows[2].y, this.rows[2].z}};
    }

    public String toString() {
        String eol = System.getProperty("line.separator");
        return eol + "0: " + this.rows[0].toString() + eol + "1: " + this.rows[1].toString() + eol + "2 : " + this.rows[2].toString();
    }
}

