/*
 * Decompiled with CFR 0.152.
 */
package mod.cyan.digimobs.util;

import java.util.Arrays;
import mod.cyan.digimobs.entities.DigimonEntity;
import mod.cyan.digimobs.util.Tools;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="digimobs", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ModSpawnEventSubscriber {
    @SubscribeEvent
    public static void onEntitySpawn(LivingSpawnEvent.CheckSpawn event) {
        if (event.getEntity() instanceof DigimonEntity) {
            DigimonEntity digi = (DigimonEntity)event.getEntity();
            digi.stats.setLevel(ModSpawnEventSubscriber.getLevelBasedOnDistance((Entity)digi, digi.field_70170_p));
            if (ModSpawnEventSubscriber.canSpawn(digi)) {
                digi.stats.setupStats();
                digi.specials.initSpecials();
                digi.digivolutions.initEvolutions();
                digi.createPassives();
                if (!digi.func_70909_n()) {
                    digi.vpetcolor = (short)-1;
                    digi.specials.initSpecialsExtras();
                    if (Tools.getRandomNumber(1, 50) == 5) {
                        digi.spiralize();
                    }
                    if (Tools.isAprilFools() && Arrays.asList(digi.pokemonskin).contains(digi.getInternalDigimonName()) && !digi.isSpiral()) {
                        digi.setup.setSpecialTexture("pokemon");
                    }
                    if (Tools.isGreenDay()) {
                        digi.setup.setColor("Green");
                    }
                }
            }
            if (!ModSpawnEventSubscriber.canSpawn(digi)) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    public static int getLevelBasedOnDistance(Entity entity, World world) {
        double distanceFromSpawn;
        BlockPos spawnPos = ((ServerWorld)world).func_241135_u_();
        double d = distanceFromSpawn = ModSpawnEventSubscriber.distance(spawnPos, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        double t = MathHelper.func_181159_b((double)entity.func_226277_ct_(), (double)entity.func_226281_cx_());
        int levelBase = Math.abs((int)(distanceFromSpawn / 10.0) / 10) + 1;
        if (levelBase > 100 && levelBase < 200) {
            levelBase = 100 - levelBase - 100;
        }
        if (levelBase >= 200 && levelBase < 300) {
            levelBase = levelBase - 200 + 1;
        }
        if (levelBase >= 300 && levelBase < 400) {
            levelBase = 100 - levelBase - 300;
        }
        if (levelBase >= 400 && levelBase < 500) {
            levelBase = levelBase - 400 + 1;
        }
        if (levelBase >= 500 && levelBase < 600) {
            levelBase = 100 - levelBase - 500;
        }
        if (levelBase >= 600 && levelBase < 700) {
            levelBase = levelBase - 600 + 1;
        }
        if (levelBase >= 700 && levelBase < 800) {
            levelBase = 100 - levelBase - 700;
        }
        if (levelBase >= 800 && levelBase < 900) {
            levelBase = levelBase - 800 + 1;
        }
        if (levelBase >= 900 && levelBase < 1000) {
            levelBase = 100 - levelBase - 900;
        }
        return levelBase;
    }

    public static double distance(BlockPos pos, double p_218140_1_, double p_218140_3_, double p_218140_5_) {
        double d1 = Math.abs((double)pos.func_177958_n() - p_218140_1_);
        double d2 = Math.abs((double)pos.func_177956_o() - p_218140_3_);
        double d3 = Math.abs((double)pos.func_177952_p() - p_218140_5_);
        return d1 + d2 + d3;
    }

    public static boolean canSpawn(DigimonEntity digi) {
        if (Tools.isHalloween() && Arrays.asList(Tools.halloween).contains(digi.getInternalDigimonName())) {
            return ModSpawnEventSubscriber.isRightLevel(digi) && ModSpawnEventSubscriber.isHalloweenEvent(digi);
        }
        return ModSpawnEventSubscriber.isRightWeather(digi) && ModSpawnEventSubscriber.isRightTime(digi) && ModSpawnEventSubscriber.isRightMoonPhase(digi) && ModSpawnEventSubscriber.isRightLevel(digi);
    }

    public static boolean isHalloweenEvent(DigimonEntity digi) {
        if (Arrays.asList(Tools.halloween).contains(digi.getInternalDigimonName())) {
            if (Tools.getRandomNumber(0, 100) >= 90) {
                digi.setup.setColor("Black");
            } else {
                digi.setup.setColor("Orange");
            }
            return true;
        }
        return false;
    }

    public static boolean isRightLevel(DigimonEntity digi) {
        if (digi.levelrange.equals("Low") && digi.stats.getLevel() >= 1 && digi.stats.getLevel() <= 5) {
            return true;
        }
        if (digi.levelrange.equals("MidLow") && digi.stats.getLevel() >= 6 && digi.stats.getLevel() <= 10) {
            return true;
        }
        if (digi.levelrange.equals("Mid") && digi.stats.getLevel() >= 11 && digi.stats.getLevel() <= 21) {
            return true;
        }
        if (digi.levelrange.equals("MidHigh") && digi.stats.getLevel() >= 22 && digi.stats.getLevel() <= 35) {
            return true;
        }
        if (digi.levelrange.equals("High") && digi.stats.getLevel() >= 36 && digi.stats.getLevel() <= 45) {
            return true;
        }
        if (digi.levelrange.equals("VeryHigh") && digi.stats.getLevel() >= 46 && digi.stats.getLevel() <= 100) {
            return true;
        }
        return digi.levelrange.equals("All") && digi.stats.getLevel() >= 1 && digi.stats.getLevel() <= 100;
    }

    public static boolean isRightWeather(DigimonEntity digi) {
        if (digi.weathercond == 0) {
            return true;
        }
        if (digi.weathercond == 1 && !digi.field_70170_p.func_72896_J()) {
            return true;
        }
        if (digi.weathercond == 2 && digi.field_70170_p.func_72896_J()) {
            return true;
        }
        return digi.weathercond == 3 && digi.field_70170_p.func_72911_I();
    }

    public static boolean isRightTime(DigimonEntity digi) {
        if (digi.timecond == 0) {
            return true;
        }
        if (digi.timecond == 1 && digi.field_70170_p.func_72820_D() % 24000L > 23000L && digi.field_70170_p.func_72820_D() % 24000L <= 24000L) {
            return true;
        }
        if (digi.timecond == 2 && digi.field_70170_p.func_72820_D() % 24000L > 0L && digi.field_70170_p.func_72820_D() % 24000L <= 3000L) {
            return true;
        }
        if (digi.timecond == 3 && digi.field_70170_p.func_72820_D() % 24000L > 3000L && digi.field_70170_p.func_72820_D() % 24000L <= 13000L) {
            return true;
        }
        if (digi.timecond == 4 && digi.field_70170_p.func_72820_D() % 24000L > 9000L && digi.field_70170_p.func_72820_D() % 24000L <= 12040L) {
            return true;
        }
        if (digi.timecond == 5 && digi.field_70170_p.func_72820_D() % 24000L > 12040L && digi.field_70170_p.func_72820_D() % 24000L <= 13000L) {
            return true;
        }
        return digi.timecond == 6 && digi.field_70170_p.func_72820_D() % 24000L > 13000L && digi.field_70170_p.func_72820_D() % 24000L <= 23000L;
    }

    public static boolean isRightMoonPhase(DigimonEntity digi) {
        if (digi.moonphasecond == 0) {
            return true;
        }
        if (digi.moonphasecond == 1 && (float)digi.field_70170_p.func_242414_af() == 1.0f) {
            return true;
        }
        return digi.moonphasecond == 2 && (float)digi.field_70170_p.func_242414_af() == 0.0f;
    }
}

