/*
 * Decompiled with CFR 0.152.
 */
package mod.cyan.digimobs.util;

import java.util.Calendar;
import java.util.UUID;
import java.util.function.Predicate;
import mod.cyan.digimobs.util.Vector3;
import net.minecraft.entity.Entity;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.entity.PartEntity;

public class Tools {
    public static final UUID SORA = UUID.fromString("295a304d-31f9-4569-9af7-3bbd87c99b6f");
    public static final UUID MC5303 = UUID.fromString("e04e2ded-2c52-457a-bfa8-ac6890ffcff9");
    public static final UUID CYANXI = UUID.fromString("d749d2fc-33ca-436b-bb65-6f935bd4dd41");
    public static final UUID SUPERFUZZYGOAT = UUID.fromString("26750046-b753-42de-9220-30afaeac3f07");
    public static final UUID POGDA = UUID.fromString("c96029e6-85ac-4160-8742-f565cc0e6fde");
    public static final UUID KIT = UUID.fromString("647745a9-7b33-49d0-b14c-ed1ec093ecb1");
    public static final UUID NIGHTMARE = UUID.fromString("0cd09aba-a669-4718-9732-540c11c0b07e");
    public static final UUID GINGY = UUID.fromString("b462e469-19ce-40b6-9999-d74102623b7c");
    public static final UUID THIEF = UUID.fromString("45b1bb95-f97b-40a5-9e3d-1867d67aa564");
    public static UUID[] STARTERS = new UUID[]{SUPERFUZZYGOAT, MC5303, CYANXI, POGDA, KIT, NIGHTMARE, GINGY};
    public static String[] halloween = new String[]{"zurumon", "kiimon", "mokumon", "poyomon", "kuramon", "arkadimonfresh", "demimeramon", "pinamon", "tsumemon", "pagumon", "yaamon", "blackagumon", "blackgabumon", "aruraumon", "tapirmon", "blackguilmon", "candlemon", "gazimon", "goblimon", "gotsumon", "impmon", "keramon", "demidevimon", "tsukaimon", "bakemon", "blackgreymon", "blackgarurumon", "meramon", "chrysalimon", "darktyrannomon", "devimon", "dobermon", "ogremon", "saberdramon", "soulmon", "blackgatomon", "wizardmon", "woodmon", "cerberusmon", "skullmeramon", "etemon", "phantomon", "knightmon", "ladydevimon", "metalgreymonvirus", "shadowweregarurumon", "mistymon", "pumpkinmon", "skullsatamon", "myotismon", "craniamon", "shadowseraphimon", "blackwargreymon", "blackmetalgarurumon", "boltmon", "metaletemon", "noblepumpkinmon", "piedmon", "puppetmon", "venommyotismon"};

    public static int getRandomNumber(int min, int max) {
        return (int)(Math.random() * (double)(max - min) + (double)min);
    }

    public static boolean isBetween(int x, int lower, int upper) {
        return lower <= x && x <= upper;
    }

    public static boolean isHalloween() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1 == 10 && calendar.get(5) >= 27 && calendar.get(5) <= 31;
    }

    public static boolean isThanksgiving() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1 == 11 && calendar.get(5) >= 24 && calendar.get(5) <= 30;
    }

    public static boolean isChristmas() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 31;
    }

    public static boolean isPokemonDay() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1 == 2 && calendar.get(5) >= 27 && calendar.get(5) <= 28;
    }

    public static boolean isChineseNewYear() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1 == 1 && calendar.get(5) >= 21 && calendar.get(5) <= 27;
    }

    public static boolean isJune() {
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) + 1 == 6 && calendar.get(5) >= 1 && calendar.get(5) <= 30) {
            return true;
        }
        return calendar.get(2) + 1 == 7 && calendar.get(5) >= 1 && calendar.get(5) <= 31;
    }

    public static boolean isAprilFools() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1 == 4 && calendar.get(5) == 1;
    }

    public static boolean isEaster() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1 == 4 && calendar.get(5) >= 7 && calendar.get(5) <= 9;
    }

    public static boolean isGreenDay() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1 == 4 && calendar.get(5) == 20;
    }

    public static Entity getPointedEntity(Entity entity, double distance) {
        return Tools.getPointedEntity(entity, distance, null);
    }

    public static Entity getCoreEntity(Entity in) {
        if (in instanceof PartEntity) {
            return ((PartEntity)in).getParent();
        }
        return in;
    }

    public static Entity getPointedEntity(Entity entity, double distance, Predicate<Entity> selector) {
        Vector3 pos = Vector3.getNewVector().set(entity, true);
        Vector3 loc = Tools.getPointedLocation(entity, distance);
        if (loc != null) {
            distance = loc.distanceTo(pos);
        }
        Vector3d vec31 = entity.func_70676_i(0.0f);
        Predicate<Entity> predicate = EntityPredicates.field_180132_d.and(c -> entity.func_70067_L());
        if (selector != null) {
            predicate = predicate.and(selector);
        }
        predicate = predicate.and(c -> !c.func_175149_v() && c.func_70089_S() && c.func_70067_L() && !Tools.isRidingOrRider(entity, c));
        Entity hit = pos.firstEntityExcluding(distance, vec31, entity.func_130014_f_(), entity, predicate);
        if (hit != null) {
            hit = Tools.getCoreEntity(hit);
        }
        return hit;
    }

    public static boolean isRidingOrRider(Entity a, Entity b) {
        for (Entity c : a.func_184182_bu()) {
            if (!b.equals((Object)c)) continue;
            return true;
        }
        for (Entity c : b.func_184182_bu()) {
            if (!a.equals((Object)c)) continue;
            return true;
        }
        return false;
    }

    public static Vector3 getPointedLocation(Entity entity, double distance) {
        Vector3d vec3 = new Vector3d(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_70047_e(), entity.func_226281_cx_());
        double d0 = distance;
        Vector3d vec31 = entity.func_70676_i(0.0f);
        Vector3d vec32 = vec3.func_72441_c(vec31.field_72450_a * d0, vec31.field_72448_b * d0, vec31.field_72449_c * d0);
        World world = entity.func_130014_f_();
        BlockRayTraceResult result = world.func_217299_a(new RayTraceContext(vec3, vec32, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entity));
        if (result == null || result.func_216350_a() == null) {
            return null;
        }
        Vector3 vec = Vector3.getNewVector().set(result.func_216347_e());
        return vec;
    }
}

