/*
 * Decompiled with CFR 0.152.
 */
package mod.cyan.digimobs.world;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mod.cyan.digimobs.entities.DigimonEntity;
import mod.cyan.digimobs.entities.setup.FieldGuide;
import mod.cyan.digimobs.entities.setup.NPCSetup;
import mod.cyan.digimobs.entities.setup.SpawnParameters;
import mod.cyan.digimobs.entities.setup.helpers.SpawnConditions;
import mod.cyan.digimobs.util.ChunkCoordinate;
import mod.cyan.digimobs.util.Tools;
import mod.cyan.digimobs.util.Vector3;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;

public class NewSpawner {
    private static final Map<RegistryKey<World>, Map<BlockPos, ForbiddenEntry>> forbidReasons = new HashMap<RegistryKey<World>, Map<BlockPos, ForbiddenEntry>>();
    public static boolean doSpawns = true;
    public static double MAX_DENSITY = 1.0;
    public static int MAXNUM = 5;
    public static List<String> coralmobs = Arrays.asList("sangomon");

    public static boolean canSpawnInWorld(World world, boolean respectDifficulty) {
        if (world == null) {
            return true;
        }
        if (respectDifficulty && world.func_175659_aa() == Difficulty.PEACEFUL) {
            return false;
        }
        return doSpawns;
    }

    public static boolean canSpawnInWorld(World world) {
        return NewSpawner.canSpawnInWorld(world, true);
    }

    private void spawn(ServerWorld world) {
        List players = world.func_217369_A();
        if (players.isEmpty()) {
            return;
        }
        Collections.shuffle(players);
        for (ServerPlayerEntity player : players) {
            if (player.func_130014_f_().func_234923_W_() != world.func_234923_W_()) continue;
            this.doSpawnForPlayer((PlayerEntity)player, world, 16, 32);
        }
    }

    public void doSpawnForPlayer(PlayerEntity player, ServerWorld world, int minRadius, int maxRadius) {
        Vector3 v = Vector3.getNewVector();
        v.set(player);
        this.doSpawnForPoint(v, world, minRadius, maxRadius);
    }

    public void doSpawnForPoint(Vector3 v, ServerWorld world, int minRadius, int maxRadius) {
        if (NewSpawner.getLevelBasedOnDistance(v, (World)world) <= 33) {
            MAXNUM = 7;
        } else if (NewSpawner.getLevelBasedOnDistance(v, (World)world) <= 22) {
            MAXNUM = 10;
        } else if (NewSpawner.getLevelBasedOnDistance(v, (World)world) <= 10) {
            MAXNUM = 30;
        }
        ServerChunkProvider serverChunkProvider = world.func_72863_F();
        if (minRadius > maxRadius) {
            return;
        }
        long time = System.nanoTime();
        if (!serverChunkProvider.func_212864_k_().isAreaLoaded(v.getPos(), maxRadius)) {
            return;
        }
        int height = world.func_217301_I();
        int boxR = 64;
        AxisAlignedBB box = v.getAABB().func_72314_b(64.0, (double)Math.max(height, 64), 64.0);
        int num = this.countDigimon((World)world, box);
        if ((double)num > MAX_DENSITY * (double)MAXNUM) {
            return;
        }
        Vector3 v1 = NewSpawner.getRandomPointNear(world, v, maxRadius);
        double dt = (double)(System.nanoTime() - time) / 1000.0;
        if (v1 == null) {
            return;
        }
        if (v.distanceTo(v1) < (double)minRadius) {
            return;
        }
        time = System.nanoTime();
        num = this.doSpawnForLocation(world, v1);
        dt = (double)(System.nanoTime() - time) / 1000.0;
    }

    public int countDigimon(World world, AxisAlignedBB box) {
        List list = world.func_217357_a(DigimonEntity.class, box);
        return list.size();
    }

    public int doSpawnForLocation(ServerWorld world, Vector3 v) {
        int ret = 0;
        int num = 0;
        if (!NewSpawner.checkNoSpawnerInArea((World)world, v.intX(), v.intY(), v.intZ())) {
            return ret;
        }
        if (v.y <= 0.0 || v.y >= (double)world.func_230315_m_().func_241513_m_()) {
            return ret;
        }
        long time = System.nanoTime();
        FieldGuide.DigimonTypes dbe = NewSpawner.getSpawnForLoc((World)world, v);
        if (dbe == null) {
            return ret;
        }
        if (v.isNaN()) {
            return ret;
        }
        if (!NewSpawner.isPointValidForSpawn((World)world, v, dbe)) {
            return ret;
        }
        time = System.nanoTime();
        num = this.doSpawnForType(world, v, dbe);
        return ret += num;
    }

    public static FieldGuide.DigimonTypes getSpawnForLoc(World world, Vector3 pos) {
        Vector3 v = pos;
        ArrayList entries = Lists.newArrayList();
        entries.remove((Object)FieldGuide.DigimonTypes.EVOLUTION);
        entries.remove((Object)FieldGuide.DigimonTypes.VEEMONS);
        entries.remove((Object)FieldGuide.DigimonTypes.BEELZEMONBEHEMOTH);
        Collections.shuffle(entries);
        int index = 0;
        FieldGuide.DigimonTypes dbe = (FieldGuide.DigimonTypes)((Object)entries.get(index));
        float weight = Tools.isAprilFools() ? 100.0f : (float)dbe.getConfig().spawnRate;
        double random = Tools.getRandomNumber(0, 100);
        int max = FieldGuide.DigimonTypes.values().length;
        Vector3 vbak = v.copy();
        Biome b = world.func_226691_t_(v.getPos());
        long daytime = world.func_72820_D() % 24000L;
        while ((double)weight <= random && index++ < max) {
            dbe = (FieldGuide.DigimonTypes)((Object)entries.get(index));
            weight = dbe.getConfig().spawnRate;
            if (weight == 0.0f) continue;
            if (!(FieldGuide.DigimonTypes.flyingmobs.contains(dbe.func_176610_l().toLowerCase()) || !(random >= (double)weight) || FieldGuide.DigimonTypes.watermobs.contains(dbe.func_176610_l().toLowerCase()) && v.getBlockMaterial((IBlockReader)world) == Material.field_151586_h)) {
                v = Vector3.getNextSurfacePoint((IBlockReader)world, vbak, Vector3.secondAxisNeg, 20.0);
                if (v != null) {
                    v.offsetBy(Direction.UP);
                    weight = dbe.getConfig().spawnRate;
                } else {
                    weight = 0.0f;
                }
            }
            if (v != null) continue;
            v = vbak.copy();
        }
        if (random > (double)weight || v == null) {
            return null;
        }
        if (!NewSpawner.checkLevelForSpawn(dbe, pos, world)) {
            return null;
        }
        if (SpawnParameters.SpawnParamTypes.valueOf(dbe.func_176610_l().toUpperCase()).getWeatherType() != SpawnConditions.SpawnTypes.NONE.getSpawnCond()) {
            if (SpawnParameters.SpawnParamTypes.valueOf(dbe.func_176610_l().toUpperCase()).getWeatherType() == SpawnConditions.SpawnTypes.CLEAR.getSpawnCond() && world.func_72896_J()) {
                return null;
            }
            if (SpawnParameters.SpawnParamTypes.valueOf(dbe.func_176610_l().toUpperCase()).getWeatherType() == SpawnConditions.SpawnTypes.RAIN.getSpawnCond() && !world.func_72896_J()) {
                return null;
            }
            if (SpawnParameters.SpawnParamTypes.valueOf(dbe.func_176610_l().toUpperCase()).getWeatherType() == SpawnConditions.SpawnTypes.STORM.getSpawnCond() && !world.func_72911_I()) {
                return null;
            }
        }
        if (!Tools.isAprilFools() && SpawnParameters.SpawnParamTypes.valueOf(dbe.func_176610_l().toUpperCase()).getTimeType() != SpawnConditions.SpawnTypes.NONE.getSpawnCond() && !Tools.isHalloween()) {
            if (SpawnParameters.SpawnParamTypes.valueOf(dbe.func_176610_l().toUpperCase()).getTimeType() != SpawnConditions.SpawnTypes.MORNING.getSpawnCond() && daytime <= 3000L) {
                return null;
            }
            if (SpawnParameters.SpawnParamTypes.valueOf(dbe.func_176610_l().toUpperCase()).getTimeType() != SpawnConditions.SpawnTypes.DAY.getSpawnCond() && daytime > 3000L && daytime <= 9000L) {
                return null;
            }
            if (SpawnParameters.SpawnParamTypes.valueOf(dbe.func_176610_l().toUpperCase()).getTimeType() != SpawnConditions.SpawnTypes.EVENING.getSpawnCond() && daytime > 9000L && daytime <= 12040L) {
                return null;
            }
            if (SpawnParameters.SpawnParamTypes.valueOf(dbe.func_176610_l().toUpperCase()).getTimeType() != SpawnConditions.SpawnTypes.DUSK.getSpawnCond() && daytime > 12040L && daytime <= 13000L) {
                return null;
            }
            if (SpawnParameters.SpawnParamTypes.valueOf(dbe.func_176610_l().toUpperCase()).getTimeType() != SpawnConditions.SpawnTypes.NIGHT.getSpawnCond() && daytime > 13000L && daytime <= 23000L) {
                return null;
            }
            if (SpawnParameters.SpawnParamTypes.valueOf(dbe.func_176610_l().toUpperCase()).getTimeType() != SpawnConditions.SpawnTypes.DAWN.getSpawnCond() && daytime > 23000L) {
                return null;
            }
        }
        if (!NewSpawner.checkBiomesForSpawn(dbe, b)) {
            return null;
        }
        return dbe;
    }

    private static boolean checkLevelForSpawn(FieldGuide.DigimonTypes dbe, Vector3 pos, World world) {
        if (Tools.isThanksgiving() && dbe == FieldGuide.DigimonTypes.KOKATORIMON) {
            return true;
        }
        if (Tools.isAprilFools() && dbe == FieldGuide.DigimonTypes.PIEDMON) {
            return true;
        }
        if (Tools.isEaster() && dbe == FieldGuide.DigimonTypes.RABBITMON) {
            return true;
        }
        if (Tools.isAprilFools() && dbe != FieldGuide.DigimonTypes.PIEDMON) {
            return false;
        }
        if (!SpawnParameters.SpawnParamTypes.valueOf(dbe.func_176610_l().toUpperCase()).getRange().equals("All")) {
            if (!SpawnParameters.SpawnParamTypes.valueOf(dbe.func_176610_l().toUpperCase()).getRange().equals("Low") && NewSpawner.getLevelBasedOnDistance(pos, world) >= 1 && NewSpawner.getLevelBasedOnDistance(pos, world) <= 5) {
                return false;
            }
            if (!SpawnParameters.SpawnParamTypes.valueOf(dbe.func_176610_l().toUpperCase()).getRange().equals("MidLow") && NewSpawner.getLevelBasedOnDistance(pos, world) >= 6 && NewSpawner.getLevelBasedOnDistance(pos, world) <= 10) {
                return false;
            }
            if (!SpawnParameters.SpawnParamTypes.valueOf(dbe.func_176610_l().toUpperCase()).getRange().equals("Mid") && NewSpawner.getLevelBasedOnDistance(pos, world) >= 11 && NewSpawner.getLevelBasedOnDistance(pos, world) <= 21) {
                return false;
            }
            if (!SpawnParameters.SpawnParamTypes.valueOf(dbe.func_176610_l().toUpperCase()).getRange().equals("MidHigh") && NewSpawner.getLevelBasedOnDistance(pos, world) >= 22 && NewSpawner.getLevelBasedOnDistance(pos, world) <= 35) {
                return false;
            }
            if (!SpawnParameters.SpawnParamTypes.valueOf(dbe.func_176610_l().toUpperCase()).getRange().equals("High") && NewSpawner.getLevelBasedOnDistance(pos, world) >= 36 && NewSpawner.getLevelBasedOnDistance(pos, world) <= 45) {
                return false;
            }
            if (!SpawnParameters.SpawnParamTypes.valueOf(dbe.func_176610_l().toUpperCase()).getRange().equals("VeryHigh") && NewSpawner.getLevelBasedOnDistance(pos, world) >= 46 && NewSpawner.getLevelBasedOnDistance(pos, world) <= 100) {
                return false;
            }
        }
        return true;
    }

    private static boolean checkBiomesForSpawn(FieldGuide.DigimonTypes dbe, Biome b) {
        if (Tools.isThanksgiving() && dbe == FieldGuide.DigimonTypes.KOKATORIMON) {
            return true;
        }
        if (Tools.isChristmas() && dbe == FieldGuide.DigimonTypes.HIYARIMON) {
            return true;
        }
        if (Tools.isChristmas() && dbe == FieldGuide.DigimonTypes.BULUCOMON) {
            return true;
        }
        if (Tools.isChristmas() && dbe == FieldGuide.DigimonTypes.HEXEBLAUMON) {
            return true;
        }
        if (Tools.isChineseNewYear() && dbe == FieldGuide.DigimonTypes.LUNAMON) {
            return true;
        }
        if (Tools.isChineseNewYear() && dbe == FieldGuide.DigimonTypes.LEKISMON) {
            return true;
        }
        if (Tools.isChineseNewYear() && dbe == FieldGuide.DigimonTypes.LOPMON) {
            return true;
        }
        if (Tools.isChineseNewYear() && dbe == FieldGuide.DigimonTypes.TURUIEMON) {
            return true;
        }
        if (Tools.isChineseNewYear() && dbe == FieldGuide.DigimonTypes.ANTYLAMONDATA) {
            return true;
        }
        if (Tools.isChineseNewYear() && dbe == FieldGuide.DigimonTypes.CHERUBIMONVIRTUE) {
            return true;
        }
        if (Tools.isPokemonDay() && dbe == FieldGuide.DigimonTypes.GAMMAMON) {
            return true;
        }
        if (Tools.isAprilFools() && dbe == FieldGuide.DigimonTypes.PIEDMON) {
            return true;
        }
        if (Tools.isEaster() && dbe == FieldGuide.DigimonTypes.RABBITMON) {
            return true;
        }
        return dbe.getConfig().spawnBiomes.contains(b.getRegistryName().toString());
    }

    private int doSpawnForType(ServerWorld world, Vector3 loc, FieldGuide.DigimonTypes dbe) {
        Vector3 v = Vector3.getNewVector();
        Vector3 v2 = Vector3.getNewVector();
        Vector3 v3 = Vector3.getNewVector();
        int totalSpawnCount = 0;
        Vector3 point = v2.clear();
        int distGroupZone = 4;
        Random rand = new Random();
        boolean spawnNumber = true;
        for (int i = 0; i < 1; ++i) {
            Vector3 dr = NewSpawner.getRandomPointNear(world, loc, 4);
            if (dr != null) {
                point.set(dr);
            } else {
                point.set(loc);
            }
            if (!NewSpawner.checkNoSpawnerInArea((World)world, point.intX(), point.intY(), point.intZ())) continue;
            float x = (float)point.x;
            float y = (float)point.y;
            float z = (float)point.z;
            EntityType type = world.func_241119_a_(loc.getPos(), 1) ? (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("digimobs", this.getNPC(world, loc))) : (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("digimobs", dbe.func_176610_l().toLowerCase()));
            DigimonEntity entity = (DigimonEntity)type.func_200721_a((World)world);
            try {
                if (world.func_241119_a_(loc.getPos(), 1)) {
                    type = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("digimobs", this.getNPC(world, loc)));
                    entity.npcify();
                }
                entity.func_70606_j(entity.func_110138_aP());
                entity.func_70012_b(x, y, z, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                if (entity.func_213380_a((IWorld)world, SpawnReason.NATURAL)) {
                    entity.setup.initDigimon();
                    entity.stats.setLevel(NewSpawner.getLevelBasedOnDistance(loc, (World)world));
                    entity.stats.setupStats();
                    entity.specials.initSpecials();
                    entity.digivolutions.initEvolutions();
                    entity.createPassives();
                    entity.checkForSkins();
                    if (!entity.func_70909_n()) {
                        entity.vpetcolor = (short)-1;
                        entity.specials.initSpecialsExtras();
                        if (Tools.getRandomNumber(1, 50) == 5) {
                            entity.spiralize();
                        }
                    }
                    if (Arrays.asList(Tools.halloween).contains(entity.getInternalDigimonName()) && Tools.isHalloween()) {
                        if (Tools.getRandomNumber(0, 100) >= 75) {
                            entity.setup.setColor("Black");
                        } else if (Tools.getRandomNumber(0, 100) >= 50) {
                            entity.setup.setColor("Orange");
                        }
                        if (Tools.getRandomNumber(0, 100) >= 75) {
                            entity.setup.setPassive("Vampiric");
                        } else if (Tools.getRandomNumber(0, 100) >= 75) {
                            entity.setup.setPassive("Siphonic");
                        }
                    }
                    entity.func_213386_a((IServerWorld)world, world.func_175649_E(v.getPos()), SpawnReason.NATURAL, null, null);
                    world.func_217376_c((Entity)entity);
                    ++totalSpawnCount;
                    continue;
                }
                entity.func_70106_y();
                continue;
            }
            catch (Throwable e) {
                if (entity != null) {
                    entity.func_70106_y();
                }
                System.err.println("Wrong Id while spawn: " + dbe.func_176610_l());
                e.printStackTrace();
                return totalSpawnCount;
            }
        }
        return totalSpawnCount;
    }

    private String getNPC(ServerWorld world, Vector3 loc) {
        Biome b = world.func_226691_t_(loc.getPos());
        if (NewSpawner.getLevelBasedOnDistance(loc, (World)world) <= 20) {
            ArrayList entries = Lists.newArrayList(NPCSetup.npcvendorlistmid);
            if (b.getRegistryName().equals((Object)Biomes.field_76769_d.func_240901_a_()) || b.getRegistryName().equals((Object)Biomes.field_150588_X.func_240901_a_())) {
                entries.addAll(NPCSetup.hotnpcmid);
            }
            if (b.getRegistryName().equals((Object)Biomes.field_76772_c.func_240901_a_()) || b.getRegistryName().equals((Object)Biomes.field_185441_Q.func_240901_a_())) {
                entries.addAll(NPCSetup.plainsnpcmid);
            }
            if (b.getRegistryName().equals((Object)Biomes.field_76774_n.func_240901_a_()) || b.getRegistryName().equals((Object)Biomes.field_76768_g.func_240901_a_())) {
                entries.addAll(NPCSetup.snowynpcmid);
            }
            Collections.shuffle(entries);
            return (String)entries.get(0);
        }
        if (NewSpawner.getLevelBasedOnDistance(loc, (World)world) >= 20 && NewSpawner.getLevelBasedOnDistance(loc, (World)world) < 35) {
            ArrayList entries = Lists.newArrayList(NPCSetup.npcvendorlistmidhigh);
            Collections.shuffle(entries);
            return (String)entries.get(0);
        }
        if (NewSpawner.getLevelBasedOnDistance(loc, (World)world) >= 35 && NewSpawner.getLevelBasedOnDistance(loc, (World)world) < 45) {
            ArrayList entries = Lists.newArrayList(NPCSetup.npcvendorlisthigh);
            Collections.shuffle(entries);
            return (String)entries.get(0);
        }
        if (NewSpawner.getLevelBasedOnDistance(loc, (World)world) >= 45) {
            ArrayList entries = Lists.newArrayList(NPCSetup.veryhighnpclist);
            if (NewSpawner.getLevelBasedOnDistance(loc, (World)world) >= 80) {
                entries.addAll(NPCSetup.veryhighquestnpc);
            }
            Collections.shuffle(entries);
            return (String)entries.get(0);
        }
        return "agumon";
    }

    public void tick(ServerWorld world) {
        if (!NewSpawner.canSpawnInWorld((World)world)) {
            return;
        }
        try {
            int rate = 2;
            if (world.func_82737_E() % 2L == 0L) {
                this.spawn(world);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Vector3 getRandomPointNear(ServerWorld world, Vector3 pos, int range) {
        int n = 100;
        while (n-- > 0) {
            BlockState blockstate;
            int dx = world.func_201674_k().nextInt(range);
            int dz = world.func_201674_k().nextInt(range);
            int dy = world.func_201674_k().nextInt(10);
            Vector3 vec = pos.add(dx *= world.func_201674_k().nextBoolean() ? 1 : -1, 0.0, dz *= world.func_201674_k().nextBoolean() ? 1 : -1);
            IChunk chunk = world.func_217349_x(vec.getPos());
            if (!(chunk instanceof Chunk)) continue;
            BlockPos blockpos = NewSpawner.getRandomHeight((World)world, (Chunk)chunk, vec.intY(), dy);
            int j = blockpos.func_177958_n();
            int k = blockpos.func_177956_o();
            int l = blockpos.func_177952_p();
            vec.set((double)j + 0.5, k, (double)l + 0.5);
            if (vec.distanceTo(pos) > (double)range || (blockstate = world.func_180495_p(blockpos)).func_215686_e((IBlockReader)world, blockpos)) continue;
            VoxelShape shape = blockstate.func_196952_d((IBlockReader)world, blockpos);
            if (!shape.func_197766_b()) {
                vec.y += shape.func_197758_c(Direction.Axis.Y);
            }
            return vec;
        }
        return null;
    }

    public static Vector3 getRandomPointNear(Entity player, int range) {
        if (player == null || !(player.func_130014_f_() instanceof ServerWorld)) {
            return null;
        }
        return NewSpawner.getRandomPointNear((ServerWorld)player.func_130014_f_(), Vector3.getNewVector().set(player), range);
    }

    private static BlockPos getRandomHeight(World worldIn, Chunk chunk, int yCenter, int dy) {
        int top;
        ChunkPos chunkpos = chunk.func_76632_l();
        int x = chunkpos.func_180334_c() + worldIn.field_73012_v.nextInt(16);
        int z = chunkpos.func_180333_d() + worldIn.field_73012_v.nextInt(16);
        int y = yCenter - dy + worldIn.field_73012_v.nextInt(2 * dy + 1);
        if (y > (top = chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE, x, z) + 1)) {
            y = top;
        }
        return new BlockPos(x, y, z);
    }

    public static boolean isPointValidForSpawn(World world, Vector3 point, FieldGuide.DigimonTypes dbe) {
        int k;
        int j;
        int i = point.intX();
        if (!NewSpawner.checkNoSpawnerInArea(world, i, j = point.intY(), k = point.intZ())) {
            return false;
        }
        boolean validLocation = NewSpawner.canDigimonSpawnHere(point, world, dbe);
        return validLocation;
    }

    public static boolean canDigimonSpawnHere(Vector3 location, World world, FieldGuide.DigimonTypes entry) {
        EntityType entityTypeIn = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("digimobs", entry.func_176610_l().toLowerCase()));
        if (entityTypeIn == null) {
            return false;
        }
        if (FieldGuide.DigimonTypes.watermobs.contains(entry.toString().toLowerCase()) && world.func_201671_F(location.getPos())) {
            return true;
        }
        return !FieldGuide.DigimonTypes.watermobs.contains(entry.toString().toLowerCase()) && !world.func_72953_d(location.getAABB().func_186662_g(5.0));
    }

    public static int getLevelBasedOnDistance(Vector3 loc, World world) {
        BlockPos spawnPos = ((ServerWorld)world).func_241135_u_();
        double distanceFromSpawn = NewSpawner.distance(spawnPos, loc.intX(), loc.intY(), loc.intZ());
        int levelBase = Math.abs((int)(distanceFromSpawn / 10.0) / 10) + 1;
        if (levelBase > 100 && levelBase < 200) {
            levelBase = 100 - levelBase - 100;
        }
        if (levelBase >= 200 && levelBase < 300) {
            levelBase = levelBase - 200 + 1;
        }
        if (levelBase >= 300 && levelBase < 400) {
            levelBase = 100 - levelBase - 300;
        }
        if (levelBase >= 400 && levelBase < 500) {
            levelBase = levelBase - 400 + 1;
        }
        if (levelBase >= 500 && levelBase < 600) {
            levelBase = 100 - levelBase - 500;
        }
        if (levelBase >= 600 && levelBase < 700) {
            levelBase = levelBase - 600 + 1;
        }
        if (levelBase >= 700 && levelBase < 800) {
            levelBase = 100 - levelBase - 700;
        }
        if (levelBase >= 800 && levelBase < 900) {
            levelBase = levelBase - 800 + 1;
        }
        if (levelBase >= 900 && levelBase < 1000) {
            levelBase = 100 - levelBase - 900;
        }
        return levelBase;
    }

    public static double distance(BlockPos pos, double p_218140_1_, double p_218140_3_, double p_218140_5_) {
        double d1 = Math.abs((double)pos.func_177958_n() - p_218140_1_);
        double d2 = Math.abs((double)pos.func_177956_o() - p_218140_3_);
        double d3 = Math.abs((double)pos.func_177952_p() - p_218140_5_);
        return d1 + d2 + d3;
    }

    public static boolean checkNoSpawnerInArea(World world, int x, int y, int z) {
        ForbidReason reason = NewSpawner.getNoSpawnReason(world, x, y, z);
        return reason == ForbidReason.NONE;
    }

    public static boolean addForbiddenSpawningCoord(BlockPos pos, World dim, int range, ForbidReason reason) {
        HashMap entries = forbidReasons.get(dim.func_234923_W_());
        if (entries == null) {
            entries = Maps.newHashMap();
            forbidReasons.put((RegistryKey<World>)dim.func_234923_W_(), entries);
        }
        if (entries.containsKey(pos)) {
            return false;
        }
        entries.put(pos, new ForbiddenEntry(range, reason, pos));
        return true;
    }

    public static boolean addForbiddenSpawningCoord(World dim, ForbidRegion region, ForbidReason reason) {
        HashMap entries = forbidReasons.get(dim.func_234923_W_());
        if (entries == null) {
            entries = Maps.newHashMap();
            forbidReasons.put((RegistryKey<World>)dim.func_234923_W_(), entries);
        }
        if (entries.containsKey(region.getPos())) {
            return false;
        }
        entries.put(region.getPos(), new ForbiddenEntry(reason, region));
        return true;
    }

    public static boolean removeForbiddenSpawningCoord(BlockPos pos, World world) {
        if (world == null) {
            return false;
        }
        Map<BlockPos, ForbiddenEntry> entries = forbidReasons.get(world.func_234923_W_());
        if (entries == null) {
            return false;
        }
        return entries.remove(pos) != null;
    }

    public static void clear() {
        forbidReasons.clear();
    }

    public static ForbiddenEntry getForbiddenEntry(World world, int x, int y, int z) {
        Map<BlockPos, ForbiddenEntry> entries = forbidReasons.get(world.func_234923_W_());
        if (entries == null) {
            return null;
        }
        BlockPos here = new BlockPos(x, y, z);
        for (ForbiddenEntry entry : entries.values()) {
            if (!entry.region.isInside(here)) continue;
            return entry;
        }
        return null;
    }

    public static List<ForbiddenEntry> getForbiddenEntries(World world, BlockPos pos) {
        ArrayList ret = Lists.newArrayList();
        Map<BlockPos, ForbiddenEntry> entries = forbidReasons.get(world.func_234923_W_());
        if (entries == null) {
            return ret;
        }
        for (ForbiddenEntry entry : entries.values()) {
            if (!entry.region.isInside(pos)) continue;
            ret.add(entry);
        }
        return ret;
    }

    public static ForbidReason getNoSpawnReason(World world, BlockPos pos) {
        return NewSpawner.getNoSpawnReason(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static ForbidReason getNoSpawnReason(World world, int x, int y, int z) {
        ForbiddenEntry entry = NewSpawner.getForbiddenEntry(world, x, y, z);
        return entry == null ? ForbidReason.NONE : entry.reason;
    }

    public static class ForbidReason {
        public static final ForbidReason NONE = new ForbidReason("digimobs:none");
        public static final ForbidReason REPEL = new ForbidReason("digimobs:repel");
        public static final ForbidReason NEST = new ForbidReason("digimobs:nest");
        public final ResourceLocation name;

        public ForbidReason(String name) {
            this.name = new ResourceLocation(name);
        }

        public String toString() {
            return this.name.toString();
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ForbidReason) {
                return ((ForbidReason)obj).name.equals((Object)this.name);
            }
            return false;
        }
    }

    public static class ForbiddenEntry {
        public final ForbidReason reason;
        public final ForbidRegion region;

        public ForbiddenEntry(ForbidReason reason, ForbidRegion region) {
            this.reason = reason;
            this.region = region;
        }

        public ForbiddenEntry(int range, ForbidReason reason, BlockPos origin) {
            this(reason, new CubeRegion(range, origin));
        }
    }

    public static class AABBRegion
    implements ForbidRegion {
        private final AxisAlignedBB box;
        private final BlockPos mid;

        public AABBRegion(AxisAlignedBB box) {
            this.box = box;
            this.mid = new BlockPos(box.func_189972_c());
        }

        @Override
        public boolean isInside(BlockPos pos) {
            return this.box.func_197744_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        }

        @Override
        public BlockPos getPos() {
            return this.mid;
        }
    }

    public static class CubeRegion
    implements ForbidRegion {
        public final int range;
        public final BlockPos origin;

        public CubeRegion(int range, BlockPos origin) {
            this.range = range;
            this.origin = origin;
        }

        @Override
        public boolean isInside(BlockPos pos) {
            return ChunkCoordinate.isWithin(pos, this.origin, this.range);
        }

        @Override
        public BlockPos getPos() {
            return this.origin;
        }
    }

    public static interface ForbidRegion {
        public boolean isInside(BlockPos var1);

        public BlockPos getPos();
    }
}

