/*
 * Decompiled with CFR 0.152.
 */
package top.codephon.digi_tsuuruzu.utils;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.entity.PartEntity;
import top.codephon.digi_tsuuruzu.utils.Matrix3;

public class Vector3 {
    public double x = 0.0;
    public double y = 0.0;
    public double z = 0.0;

    public static Vector3 entity(Entity e) {
        return e != null ? Vector3.getNewVector().set(e.func_226277_ct_(), e.func_226278_cu_() + (double)e.func_70047_e(), e.func_226281_cx_()) : null;
    }

    public static Vector3 getNewVector() {
        return new Vector3();
    }

    private Vector3() {
    }

    public Vector3 add(double i, double j, double k) {
        return Vector3.getNewVector().set(this.x + i, j + this.y, k + this.z);
    }

    public void add(int i, double j) {
        if (i == 0) {
            this.x += j;
        } else if (i == 1) {
            this.y += j;
        } else if (i == 2) {
            this.z += j;
        }
    }

    public Vector3 add(Vector3 vectorB) {
        Vector3 vectorC = Vector3.getNewVector();
        for (int i = 0; i < 3; ++i) {
            vectorC.set(i, this.get(i) + vectorB.get(i));
        }
        return vectorC;
    }

    public double distanceTo(Vector3 vec) {
        return this.subtract(vec).mag();
    }

    public boolean equals(Object vec) {
        if (!(vec instanceof Vector3)) {
            return false;
        }
        Vector3 v = (Vector3)vec;
        return v.x == this.x && v.y == this.y && v.z == this.z;
    }

    public Entity firstEntityExcluding(double range, Vector3d vec31, World world, Entity entity, Predicate<Entity> predicate) {
        Entity pointedEntity = null;
        if (predicate == null) {
            predicate = EntityPredicates.field_180132_d;
        }
        Vector3d vec3 = this.toVec3d();
        Vector3d vec32 = vec3.func_72441_c(vec31.field_72450_a * range, vec31.field_72448_b * range, vec31.field_72449_c * range);
        float f = 2.5f;
        AxisAlignedBB aabb = this.getAABB().func_72321_a(vec31.field_72450_a * range, vec31.field_72448_b * range, vec31.field_72449_c * range).func_72314_b(2.5, 2.5, 2.5);
        List mobs = world.func_175674_a(entity, aabb, predicate);
        double ds = range * range;
        block0: for (Entity entity1 : mobs) {
            double d1;
            PartEntity[] parts = entity1.getParts();
            if (parts != null && parts.length > 0) {
                PartEntity[] var26 = parts;
                int var27 = parts.length;
                for (int var28 = 0; var28 < var27; ++var28) {
                    double d12;
                    PartEntity part = var26[var28];
                    AxisAlignedBB axisalignedbb = part.func_174813_aQ().func_186662_g((double)0.3f);
                    Optional optional = axisalignedbb.func_216365_b(vec3, vec32);
                    if (!optional.isPresent() || !((d12 = vec3.func_72436_e((Vector3d)optional.get())) < ds)) continue;
                    pointedEntity = entity1;
                    ds = d12;
                    continue block0;
                }
                continue;
            }
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f);
            Optional optional = axisalignedbb.func_216365_b(vec3, vec32);
            if (!optional.isPresent() || !((d1 = vec3.func_72436_e((Vector3d)optional.get())) < ds)) continue;
            pointedEntity = entity1;
            ds = d1;
        }
        return pointedEntity;
    }

    public Vector3d toVec3d() {
        return new Vector3d(this.x, this.y, this.z);
    }

    public double get(int i) {
        assert (i < 3);
        return i == 0 ? this.x : (i == 1 ? this.y : this.z);
    }

    public AxisAlignedBB getAABB() {
        return Matrix3.getAABB(this.x, this.y, this.z, this.x, this.y, this.z);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public double mag() {
        double vmag = Math.sqrt(this.magSq());
        return vmag;
    }

    public double magSq() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Vector3 set(Direction dir) {
        this.x = dir.func_82601_c();
        this.y = dir.func_96559_d();
        this.z = dir.func_82599_e();
        return this;
    }

    public Vector3 set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Vector3 set(double[] vec) {
        this.x = vec[0];
        this.y = vec[1];
        this.z = vec[2];
        return this;
    }

    public Vector3 set(Entity e, boolean b) {
        if (e != null && b) {
            this.x = e.func_226277_ct_();
            this.y = e.func_226278_cu_() + (double)(e.func_213302_cg() / 2.0f);
            this.z = e.func_226281_cx_();
        } else if (e != null) {
            this.x = e.func_226277_ct_();
            this.y = e.func_226278_cu_() + (double)e.func_70047_e();
            this.z = e.func_226281_cx_();
        }
        return this;
    }

    public void set(int i, double j) {
        if (i == 0) {
            this.x = j;
        } else if (i == 1) {
            this.y = j;
        } else if (i == 2) {
            this.z = j;
        }
    }

    public Vector3 set(Object o) {
        if (o instanceof Entity) {
            Entity e = (Entity)o;
            this.set(e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_());
        } else if (o instanceof TileEntity) {
            TileEntity te = (TileEntity)o;
            this.set(te.func_174877_v());
        } else if (o instanceof double[]) {
            double[] d = (double[])o;
            this.set(d[0], d[1], d[2]);
        } else if (o instanceof Direction) {
            Direction side = (Direction)o;
            this.set(side.func_82601_c(), side.func_96559_d(), side.func_82599_e());
        } else if (o instanceof Vector3) {
            this.set((Vector3)o);
        } else if (o instanceof BlockPos) {
            BlockPos c = (BlockPos)o;
            this.set(c.func_177958_n(), c.func_177956_o(), c.func_177952_p());
        } else if (o instanceof GlobalPos) {
            BlockPos c = ((GlobalPos)o).func_218180_b();
            this.set(c.func_177958_n(), c.func_177956_o(), c.func_177952_p());
        } else if (o instanceof PathPoint) {
            PathPoint p = (PathPoint)o;
            this.set(p.field_75839_a, p.field_75837_b, p.field_75838_c);
        } else if (o instanceof Vector3d) {
            Vector3d p = (Vector3d)o;
            this.set(p.field_72450_a, p.field_72448_b, p.field_72449_c);
        } else if (o instanceof int[]) {
            int[] p = (int[])o;
            this.set(p[0], p[1], p[2]);
        } else if (o instanceof byte[]) {
            byte[] p = (byte[])o;
            this.set(p[0], p[1], p[2]);
        } else if (o instanceof short[]) {
            short[] p = (short[])o;
            this.set(p[0], p[1], p[2]);
        } else if (o instanceof Double) {
            this.y = this.z = ((Double)o).doubleValue();
            this.x = this.z;
        }
        return this;
    }

    public Vector3 set(Vector3 vec) {
        if (vec != null) {
            this.x = vec.x;
            this.y = vec.y;
            this.z = vec.z;
        }
        return this;
    }

    public Vector3 subtract(Vector3 vectorB) {
        Vector3 vectorC = Vector3.getNewVector();
        for (int i = 0; i < 3; ++i) {
            vectorC.set(i, this.get(i) - vectorB.get(i));
        }
        return vectorC;
    }

    public String toString() {
        return "x:" + this.x + " y:" + this.y + " z:" + this.z;
    }

    public void set(int x0, int y0, int z0) {
        this.x = x0;
        this.y = y0;
        this.z = z0;
    }
}

